/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection;

import java.io.IOException;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.connection.ConnectionResourceBundle;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;

public abstract class Connection
extends EscObject
implements ConnectionService {
    protected static final int OPEN_RESOURCE = 1001;
    protected static final int CLOSE_RESOURCE = 1002;
    protected static final int CLOSED_RESOURCE = 1003;
    protected static final int OPENFAILED_RESOURCE = 1004;
    protected static final int READ_BYTES_RESOURCE = 1005;
    protected static final int WRITE_BYTES_RESOURCE = 1006;
    protected static final int CLIENT_WAIT_RESOURCE = 1007;
    private static ResourceBundle DefaultResourceBundle;
    private boolean isOpen = false;
    protected ConfigurationService configurationService = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.connection.ConnectionResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public static String getDefaultResource(int resourceId) {
        return DefaultResourceBundle.getString(ConnectionResourceBundle.getKey(resourceId));
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        if (errorNumber == 1004) {
            return false;
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void close() throws IOException {
        this.setOpen(false);
    }

    public void exit() throws IOException {
        this.close();
    }

    protected void finalize() throws Throwable {
        this.exit();
    }

    public void flush() throws IOException {
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 1005: 
            case 1006: {
                return 5;
            }
            case 1001: 
            case 1002: {
                return 3;
            }
            case 1003: 
            case 1004: 
            case 1007: {
                return 4;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(ConnectionResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized void open() throws IOException {
        this.setOpen(true);
        this.report(null, 1001, this.getConfigurationService());
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }
}

