/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.TestGroupRunner;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.osgi.framework.InvalidSyntaxException;

public class TestSession
implements TestSessionService {
    private TestConfigurationService testConfigurationService;
    private TestSynchronizationService syncService;
    private List globalRunListeners;
    private ThreadGroup sessionGroup;
    private boolean interrupted;

    public TestSession(TestConfigurationService testConfigurationService, TestSynchronizationService syncService) {
        this.testConfigurationService = testConfigurationService;
        this.syncService = syncService;
        this.globalRunListeners = new ArrayList();
        this.sessionGroup = new ThreadGroup("TestSession");
    }

    public synchronized void addGlobalTestRunListener(TestRunListenerService runListener) {
        this.globalRunListeners.add(runListener);
    }

    public synchronized void removeGlobalTestRunListener(TestRunListenerService runListener) {
        this.globalRunListeners.remove(runListener);
    }

    private synchronized TestRunListenerService[] getRunListeners(TestRunListenerService runListener) {
        int size = this.globalRunListeners.size();
        TestRunListenerService[] listeners = new TestRunListenerService[runListener == null ? size : size + 1];
        this.globalRunListeners.toArray(listeners);
        if (runListener != null) {
            listeners[size] = runListener;
        }
        return listeners;
    }

    public TestConfigurationService getTestConfigurationService() {
        return this.testConfigurationService;
    }

    public void runSingleTest(String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        TestAgentService[] agents = this.testConfigurationService.findTests(filter, className);
        if (agents.length == 1) {
            this.runTest(runId, agents, properties, runListener);
        } else {
            TestRunListenerService[] listeners = this.getRunListeners(runListener);
            int i = 0;
            while (i < listeners.length) {
                Object[] parms1 = new Object[]{new Integer(agents.length)};
                Object[] parms2 = new Object[]{filter, className};
                listeners[i].testRunError(runId, Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7050)), (Object[])parms1), Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7069)), (Object[])parms2));
                ++i;
            }
        }
    }

    public void runMultipleTests(String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        TestAgentService[] agents = this.testConfigurationService.findTests(filter, className);
        this.runTest(runId, agents, properties, runListener);
    }

    public void interrupt() {
        this.interrupted = true;
        this.sessionGroup.setDaemon(true);
        Thread[] threads = new Thread[this.sessionGroup.activeCount()];
        this.sessionGroup.enumerate(threads);
        int i = 0;
        while (i < threads.length) {
            threads[i].interrupt();
            ++i;
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void close() {
        this.sessionGroup.setDaemon(true);
        Thread[] threads = new Thread[this.sessionGroup.activeCount()];
        this.sessionGroup.enumerate(threads);
        try {
            int i = 0;
            while (i < threads.length) {
                if (threads[i] != null) {
                    threads[i].join();
                }
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {}
        this.globalRunListeners.clear();
    }

    private TestGroupRunner runTest(String runId, TestAgentService[] agents, Dictionary properties, TestRunListenerService runListener) {
        TestGroupRunner runner = new TestGroupRunner(runId, agents, properties, this.syncService, this.getRunListeners(runListener));
        Thread runnerThread = new Thread(this.sessionGroup, runner, "TestGroup");
        runnerThread.start();
        return runner;
    }
}

