/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.console;

import java.io.PrintStream;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.ConsoleSynchronization;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;

public class TestControllerConsole
extends ConsoleSynchronization
implements TestRunListenerService {
    protected void printErrorEvent(String message, String trace) {
        this.printEvent(true, message, trace);
    }

    protected void printEvent(String reportLine) {
        this.printEvent(false, reportLine, null);
    }

    protected synchronized void printEvent(boolean error, String message, String detail) {
        PrintStream out = error ? System.err : System.out;
        String timestamp = Nls.formatTimestamp((long)System.currentTimeMillis());
        out.print(timestamp);
        out.print(' ');
        out.println(message);
        if (detail != null) {
            out.println(detail);
        }
        out.flush();
    }

    public void testEnded(String runId, String testName) {
    }

    public void testError(String runId, String testName, String trace) {
        Object[] parms = new Object[]{testName, runId};
        this.printErrorEvent(Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7065)), (Object[])parms), trace);
    }

    public void testFailed(String runId, String testName, String trace) {
        Object[] parms = new Object[]{testName, runId};
        this.printErrorEvent(Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7066)), (Object[])parms), trace);
    }

    public void testRunEnded(String runId) {
    }

    public void testRunError(String runId, String message, String detail) {
        Object[] parms = new Object[]{message, runId};
        this.printErrorEvent(Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7067)), (Object[])parms), detail);
    }

    public void testRunStarted(String runId) {
    }

    public void testStarted(String runId, String testName) {
        Object[] parms = new Object[]{testName, runId};
        this.printEvent(Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7068)), (Object[])parms));
    }
}

