/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.testcase;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.NotificationQueue;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.notification.testcase.NotificationTestListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class NotificationTestcase
implements NotificationListener,
BundleActivator {
    public static void main(String[] args) {
        NotificationTestcase test = new NotificationTestcase();
        test.test1();
        test.test2();
        test.test3();
        test.test4();
        test.test5();
        System.exit(0);
    }

    public void notificationReceived(String topic, Dictionary data) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("notificationReceived ");
        buffer.append(topic);
        buffer.append('=');
        buffer.append(data);
        System.out.println(buffer.toString());
    }

    public void start(BundleContext context) throws Exception {
        NotificationTestcase test = new NotificationTestcase();
        test.test1();
        test.test2();
        test.test3();
        test.test4();
        test.test5();
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void test1() {
        System.out.println("start test1");
        NotificationQueue queue = new NotificationQueue(1);
        int i = 0;
        while (i < 10) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            queue.broadcast("externalkey/" + i, data);
            ++i;
        }
        i = 0;
        while (i < 10) {
            Object[] element = queue.dequeue(1L);
            StringBuffer buffer = new StringBuffer(256);
            buffer.append("dequeue ");
            buffer.append(element[0]);
            buffer.append('=');
            buffer.append(element[1]);
            System.out.println(buffer.toString());
            ++i;
        }
    }

    public void test2() {
        System.out.println("start test2");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)this);
        miniBroker.register(new String[]{"#"}, (NotificationListener)this);
        NotificationTestListener listener = new NotificationTestListener();
        miniBroker.register(new String[]{"externalkey/0", "externalkey/9"}, (NotificationListener)listener);
        int i = 0;
        while (i < 10) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("externalkey/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
    }

    public void test3() {
        Hashtable<String, Integer> data;
        System.out.println("start test3");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"#/0", "#/middle/1"}, (NotificationListener)this);
        int i = 0;
        while (i < 3) {
            data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
        System.out.println("Should not see anything");
        i = 0;
        while (i < 3) {
            data = new Hashtable();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
    }

    public void test4() {
        System.out.println("start test4");
        NotificationService miniBroker = Notification.getBroker();
        miniBroker.register(new String[]{"key/#"}, (NotificationListener)this);
        int i = 0;
        while (i < 3) {
            Hashtable<String, Integer> data = new Hashtable<String, Integer>();
            data.put("test", new Integer(i));
            miniBroker.broadcast("key/" + i, data);
            miniBroker.broadcast("key/middle/" + i, data);
            ++i;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miniBroker.unregister((NotificationListener)this);
    }

    public void test5() {
        System.out.println("start test5");
        String[] keys = new String[]{"a", "b"};
        String[] newKeys = Notification.getExternalKeys((String)"prefix", (String[])keys);
        int i = 0;
        while (i < keys.length) {
            System.out.println(newKeys[i]);
            ++i;
        }
    }
}

