/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.CreateActivatorArtifactsOperation;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.MiscellaneousActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.NewActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.PreviewActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.JavaUtility;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.ManifestFileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.PdeUtility;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.TypeFinder;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.activator.util.ITypeModel;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ActivatorWizard
extends Wizard
implements INewWizard,
IActivatorWizard {
    private static final String WINDOW_TITLE_KEY = "ActivatorWizard.WindowTitle";
    private static final String MANIFEST_MF_FILENAME = "MANIFEST.MF";
    private static final String META_INF_FOLDER = "META-INF";
    private IActivatorWizardModel model;
    private IPackageFragmentRoot packageFragmentRoot;
    private ManifestFileManager manifestFileManager;

    public ActivatorWizard() {
        this.setModel(this.createModel());
        this.setDefaultPageImageDescriptor(this.getPageImageDescriptor());
        this.setWindowTitle(this.getWindowTitleString());
    }

    public void addBundleDependencyFor(IType type) {
        String bundleSymbolicName = PdeUtility.getBundleSymbolicName(type);
        if (bundleSymbolicName == null) {
            return;
        }
        IActivatorWizardModel model = this.getModel();
        String fullyQualifiedName = type.getFullyQualifiedName();
        model.addBundleDependency(fullyQualifiedName, bundleSymbolicName);
    }

    private void addExportedServicesFromManifest() {
        try {
            ManifestFileManager manager = this.getManifestFileManager();
            if (manager == null) {
                return;
            }
            FactoryUtility utility = FactoryUtility.getInstance();
            String value = manager.getHeader("Export-Service");
            IActivatorWizardPreferences preferences = this.getPreferences();
            boolean storedInField = preferences.getStoreExportedServicesInFields();
            boolean hasProperties = preferences.getExportServicesWithProperties();
            boolean proxy = preferences.getCreateExportedProxyServices();
            List services = this.tokenizeManifestValue(value);
            Iterator iterator = services.iterator();
            IActivatorWizardModel model = this.getModel();
            while (iterator.hasNext()) {
                String service = (String)iterator.next();
                IType type = this.findType(service);
                int serviceDetailsType = this.getServiceDetailsType(type);
                IExportedServiceDetails details = utility.createExportedServiceDetails(service, serviceDetailsType, storedInField, hasProperties, proxy);
                details.setFromManifestHeader(true);
                model.addExportedServiceDetails(details);
                this.addBundleDependencyFor(type);
            }
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        catch (IOException exception) {
            this.logError(exception);
        }
    }

    private void addImportedServicesFromManifest() {
        try {
            ManifestFileManager manager = this.getManifestFileManager();
            if (manager == null) {
                return;
            }
            FactoryUtility utility = FactoryUtility.getInstance();
            String value = manager.getHeader("Import-Service");
            IActivatorWizardPreferences preferences = this.getPreferences();
            boolean filtered = preferences.getImportFilteredServices();
            boolean optional = preferences.getOptionallyImportServices();
            List services = this.tokenizeManifestValue(value);
            Iterator iterator = services.iterator();
            IActivatorWizardModel model = this.getModel();
            while (iterator.hasNext()) {
                String service = (String)iterator.next();
                IType type = this.findType(service);
                int serviceDetailsType = this.getServiceDetailsType(type);
                IImportedServiceDetails details = utility.createImportedServiceDetails(service, serviceDetailsType, filtered, optional);
                details.setFromManifestHeader(true);
                model.addImportedServiceDetails(details);
                this.addBundleDependencyFor(type);
            }
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        catch (IOException exception) {
            this.logError(exception);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewActivatorWizardPage(this));
        this.addPage((IWizardPage)new ServicesActivatorWizardPage(this));
        this.addPage((IWizardPage)new MiscellaneousActivatorWizardPage(this));
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean doNotShowPreviewPage = preferences.getDoNotShowPreviewPage();
        if (doNotShowPreviewPage) {
            return;
        }
        this.addPage((IWizardPage)new PreviewActivatorWizardPage(this));
    }

    private IActivatorWizardModel createModel() {
        ITypeModel typeModel = this.createTypeModel();
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardModel model = utility.createActivatorWizardModel(typeModel);
        return model;
    }

    private IRunnableWithProgress createOperation() {
        IActivatorWizardModel model = this.getModel();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        ManifestFileManager manager = this.getManifestFileManager();
        CreateActivatorArtifactsOperation operation = new CreateActivatorArtifactsOperation(model, root, manager);
        return operation;
    }

    private ITypeModel createTypeModel() {
        return new ITypeModel(){

            public boolean hasServiceNameField(String fullyQualifiedTypeName) {
                return ActivatorWizard.this.hasServiceNameField(fullyQualifiedTypeName);
            }
        };
    }

    private IType findType(String service) throws JavaModelException {
        IJavaProject project = this.getJavaProject();
        IType type = TypeFinder.findType(project, service);
        if (type == null) {
            type = TypeFinder.findType(service);
        }
        return type;
    }

    private String getBundleSymbolicName() throws CoreException, IOException {
        ManifestFileManager manager = this.getManifestFileManager();
        if (manager == null) {
            return null;
        }
        String value = manager.getHeader("Bundle-SymbolicName");
        if (value == null) {
            return null;
        }
        int index = value.indexOf(59);
        if (index == -1) {
            return value;
        }
        value = value.substring(0, index);
        return value;
    }

    private IFile getFile(String filepath, String filename) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IFile file = JavaUtility.getFile(root, filepath, filename);
        return file;
    }

    private IJavaElement getJavaElement(IStructuredSelection selection) {
        IJavaElement javaElement = null;
        if (selection != null && !selection.isEmpty()) {
            IProject project;
            boolean open;
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IProject && !(open = (project = (IProject)selection.getFirstElement()).isOpen())) {
                return null;
            }
            javaElement = JavaUtility.getJavaElementFromAdaptable(firstElement);
            if (javaElement != null) {
                return javaElement;
            }
        }
        if ((javaElement = JavaUtility.getActiveEditorInput()) != null) {
            return javaElement;
        }
        IWorkspaceRoot root = JavaUtility.getWorkspaceRoot();
        IProject[] projects = root.getProjects();
        if (projects.length == 0) {
            return null;
        }
        IProject project = projects[0];
        javaElement = JavaCore.create((IProject)project);
        return javaElement;
    }

    private IJavaProject getJavaProject() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IJavaProject project = (IJavaProject)root.getAncestor(2);
        return project;
    }

    private IFile getManifestFile() {
        IFile file = this.getFile(META_INF_FOLDER, MANIFEST_MF_FILENAME);
        return file;
    }

    private ManifestFileManager getManifestFileManager() {
        return this.manifestFileManager;
    }

    public IActivatorWizardModel getModel() {
        return this.model;
    }

    private IPackageFragment getPackageFragment(IJavaElement element) {
        IPackageFragment fragment = null;
        if (element instanceof IPackageFragment) {
            fragment = (IPackageFragment)element;
        } else if (element != null) {
            fragment = (IPackageFragment)element.getAncestor(4);
        }
        return fragment;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        boolean found;
        if (element == null) {
            return null;
        }
        IPackageFragmentRoot root = JavaUtility.getPackageFragmentRoot(element);
        boolean bl = found = root != null && !root.isArchive();
        if (found) {
            return root;
        }
        IJavaProject javaProject = element.getJavaProject();
        boolean exists = javaProject.exists();
        if (!exists) {
            return null;
        }
        root = JavaUtility.getFirstRoot(javaProject);
        if (root == null) {
            root = javaProject.getPackageFragmentRoot("");
        }
        return root;
    }

    private String getPackageNameFromPackageFragment(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            return new String();
        }
        String text = packageFragment.getElementName();
        text = text.trim();
        return text;
    }

    private ImageDescriptor getPageImageDescriptor() {
        Activator activator = Activator.getDefault();
        ImageDescriptor descriptor = activator.getImageDescriptor("wizard-banner");
        return descriptor;
    }

    private IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    private int getServiceDetailsType(IType javaType) {
        int type = -1;
        try {
            if (javaType != null) {
                boolean isInterface = javaType.isInterface();
                type = isInterface ? 0 : 1;
            }
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return type;
    }

    private String getWindowTitleString() {
        return Messages.getString(WINDOW_TITLE_KEY);
    }

    private boolean hasServiceNameField(String fullyQualifiedTypeName) {
        IType type;
        boolean result;
        block3: {
            result = false;
            type = TypeFinder.findType(fullyQualifiedTypeName);
            if (type != null) break block3;
            return false;
        }
        try {
            IField field = type.getField("SERVICE_NAME");
            result = field.exists();
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        IJavaElement element = this.getJavaElement(selection);
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot(element);
        this.setPackageFragmentRoot(packageFragmentRoot);
        IPackageFragment packageFragment = this.getPackageFragment(element);
        IActivatorWizardModel model = this.getModel();
        model.setPackageName(this.getPackageNameFromPackageFragment(packageFragment));
        this.initialize();
    }

    private void initialize() {
        this.initializeManifestFileManager();
        this.initializeBundleSymbolicName();
        this.initializeModel();
    }

    private void initializeBundleSymbolicName() {
        try {
            String name = this.getBundleSymbolicName();
            this.model.setBundleSymbolicName(name);
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        catch (IOException exception) {
            this.logError(exception);
        }
    }

    private void initializeManifestFileManager() {
        IFile file = this.getManifestFile();
        if (file == null) {
            return;
        }
        ManifestFileManager manager = new ManifestFileManager(file);
        this.setManifestFileManager(manager);
    }

    private void initializeModel() {
        this.initializeModelPropertiesFilename();
        this.initializeModelImportedServices();
        this.initializeModelExportedServices();
    }

    private void initializeModelExportedServices() {
        this.removeExportedServicesAddedFromManifest();
        this.addExportedServicesFromManifest();
    }

    private void initializeModelImportedServices() {
        this.removeImportedServicesAddedFromManifest();
        this.addImportedServicesFromManifest();
    }

    private void initializeModelPropertiesFilename() {
        IActivatorWizardModel model = this.getModel();
        model.setPropertiesFilename(null);
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    public boolean performFinish() {
        this.performFinishPages();
        boolean result = false;
        try {
            IWizardContainer container = this.getContainer();
            IRunnableWithProgress operation = this.createOperation();
            container.run(false, false, operation);
            result = true;
        }
        catch (InvocationTargetException exception) {
            this.logError(exception);
        }
        catch (InterruptedException exception) {
            this.logError(exception);
        }
        return result;
    }

    private void performFinishPages() {
        IWizardPage[] pages = this.getPages();
        int length = pages.length;
        int i = 0;
        while (i < length) {
            IWizardPage page = pages[i];
            IActivatorWizardPage activatorWizardPage = (IActivatorWizardPage)page;
            activatorWizardPage.finish();
            ++i;
        }
    }

    public void removeBundleDependencyFor(String fullyQualifiedName) {
        IActivatorWizardModel model = this.getModel();
        model.removeBundleDependency(fullyQualifiedName);
    }

    private void removeExportedServicesAddedFromManifest() {
        IActivatorWizardModel model = this.getModel();
        List list = model.getExportedServicesDetails();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IExportedServiceDetails details = (IExportedServiceDetails)iterator.next();
            boolean remove = details.isFromManifestHeader();
            if (!remove) continue;
            model.removeExportedServiceDetails(details);
        }
    }

    private void removeImportedServicesAddedFromManifest() {
        IActivatorWizardModel model = this.getModel();
        List list = model.getImportedServicesDetails();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IImportedServiceDetails details = (IImportedServiceDetails)iterator.next();
            boolean remove = details.isFromManifestHeader();
            if (!remove) continue;
            model.removeImportedServiceDetails(details);
        }
    }

    private void setManifestFileManager(ManifestFileManager manifestFileManager) {
        this.manifestFileManager = manifestFileManager;
    }

    private void setModel(IActivatorWizardModel model) {
        this.model = model;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        if (this.packageFragmentRoot == packageFragmentRoot) {
            return;
        }
        this.packageFragmentRoot = packageFragmentRoot;
        this.initialize();
    }

    private List tokenizeManifestValue(String value) {
        ArrayList<String> tokens = new ArrayList<String>(20);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                token = token.trim();
                tokens.add(token);
            }
            tokens.trimToSize();
        }
        return tokens;
    }
}

