/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.BuildPropertiesFileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.JavaUtility;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.ManifestFileManager;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class CreateActivatorArtifactsOperation
extends WorkspaceModifyOperation {
    private static final String BUNDLE_ACTIVATOR_MANIFEST_HEADER_IS_ALREADY_SET_KEY = "CreateActivatorArtifactsOperation.BundleActivatorManifestHeaderIsAlreadySet";
    private static final String CONFIRM_OVERWRITE_DIALOG_TITLE_KEY = "CreateActivatorArtifactsOperation.ConfirmOverwriteDialogTitle";
    private static final String OVERWRITE_IN_FUTURE_WITHOUT_WARNING = "CreateActivatorArtifactsOperation.OverwriteInFutureWithoutWarning";
    private static final String BUILD_PROPERTIES_FILENAME = "build.properties";
    private static final String COMPILATION_UNIT_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    private static final String JAVA_FILENAME_EXTENSION = ".java";
    private IActivatorWizardModel model;
    private IPackageFragmentRoot packageFragmentRoot;
    private ManifestFileManager manifestFileManager;

    CreateActivatorArtifactsOperation(IActivatorWizardModel model, IPackageFragmentRoot packageFragmentRoot, ManifestFileManager manager) {
        this.setModel(model);
        this.setPackageFragmentRoot(packageFragmentRoot);
        this.setManifestFileManager(manager);
    }

    private void createCompilationUnit(IProgressMonitor monitor) throws JavaModelException {
        String packageName;
        IActivatorWizardModel model = this.getModel();
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName = model.getPackageName());
        boolean packageFragmentExists = packageFragment.exists();
        if (!packageFragmentExists) {
            packageFragment = packageFragmentRoot.createPackageFragment(packageName, false, monitor);
        }
        String name = model.getClassName();
        String contents = model.generate();
        ICompilationUnit compilationUnit = packageFragment.createCompilationUnit(String.valueOf(name) + JAVA_FILENAME_EXTENSION, contents, false, monitor);
        IFile file = (IFile)compilationUnit.getCorrespondingResource();
        UiUtility utility = UiUtility.getInstance();
        try {
            utility.openEditor(file, COMPILATION_UNIT_EDITOR_ID);
        }
        catch (PartInitException exception) {
            this.logError(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Activator Wizard...", 100);
                this.createCompilationUnit(monitor);
                this.updateManifest();
                this.updateBuildProperties();
            }
            catch (IOException exception) {
                this.logError(exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    private IFile getBuildPropertiesFile() {
        IFile file = this.getFile(BUILD_PROPERTIES_FILENAME);
        return file;
    }

    private IFile getFile(String filename) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IFile file = JavaUtility.getFile(root, filename);
        return file;
    }

    private ManifestFileManager getManifestFileManager() {
        return this.manifestFileManager;
    }

    private IActivatorWizardModel getModel() {
        return this.model;
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    private IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    private Shell getShell() {
        UiUtility utility = UiUtility.getInstance();
        Shell shell = utility.getShell();
        return shell;
    }

    private boolean isOkToUpdateBundleActivatorManifestHeader() {
        boolean overwrite;
        block6: {
            block5: {
                overwrite = false;
                ManifestFileManager manager = this.getManifestFileManager();
                String value = manager.getHeader("Bundle-Activator");
                if (value != null) break block5;
                return true;
            }
            IActivatorWizardPreferences preferences = this.getPreferences();
            overwrite = preferences.getOverwriteBundleActivatorManifestHeader();
            if (!overwrite) break block6;
            return true;
        }
        try {
            overwrite = this.openConfirmOverwriteBundleActivatorManifestHeaderDialog();
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        catch (IOException exception) {
            this.logError(exception);
        }
        return overwrite;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private boolean openConfirmOverwriteBundleActivatorManifestHeaderDialog() {
        String message = Messages.getString(BUNDLE_ACTIVATOR_MANIFEST_HEADER_IS_ALREADY_SET_KEY);
        String title = Messages.getString(CONFIRM_OVERWRITE_DIALOG_TITLE_KEY);
        String overwriteInFuture = Messages.getString(OVERWRITE_IN_FUTURE_WITHOUT_WARNING);
        org.eclipse.soda.sat.plugin.ui.util.FactoryUtility utility = org.eclipse.soda.sat.plugin.ui.util.FactoryUtility.getInstance();
        Shell shell = this.getShell();
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, message);
        dialog.setTitle(title);
        dialog.useQuestionIcon();
        dialog.setCancelButtonText(null);
        dialog.defaultButtonIsCancel();
        int id = dialog.addCheckbox(overwriteInFuture, false);
        int rc = dialog.open();
        boolean overwrite = rc == 2;
        boolean selected = dialog.isCheckboxSelected(id);
        if (selected) {
            IActivatorWizardPreferences preferences = this.getPreferences();
            preferences.setOverwriteBundleActivatorManifestHeader(true);
            preferences.save();
        }
        return overwrite;
    }

    private void setManifestFileManager(ManifestFileManager manifestFileManager) {
        this.manifestFileManager = manifestFileManager;
    }

    private void setModel(IActivatorWizardModel model) {
        this.model = model;
    }

    private void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }

    private void updateBuildProperties() throws CoreException, IOException {
        IFile file = this.getBuildPropertiesFile();
        boolean exists = file.exists();
        if (!exists) {
            return;
        }
        BuildPropertiesFileManager manager = new BuildPropertiesFileManager(file);
        IActivatorWizardModel model = this.getModel();
        List list = model.getBundleDependencies();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String token = (String)iterator.next();
            manager.addToken("additional.bundles", token);
        }
        manager.save();
    }

    private void updateManifest() throws CoreException, IOException {
        ManifestFileManager manager = this.getManifestFileManager();
        if (manager == null) {
            return;
        }
        boolean update = this.isOkToUpdateBundleActivatorManifestHeader();
        if (!update) {
            return;
        }
        IActivatorWizardModel model = this.getModel();
        String packageName = model.getPackageName();
        String className = model.getClassName();
        String bundleActivator = packageName.length() > 0 ? String.valueOf(packageName) + '.' + className : className;
        manager.put("Bundle-Activator", bundleActivator);
        manager.save();
    }
}

