/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ExportedServicesTableLabelProvider;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ImportedServicesTableLabelProvider;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ServicesActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String ADD_KEY = "ServicesActivatorWizardPage.Add";
    private static final String ADD_EXPORTED_SERVICE_KEY = "ServicesActivatorWizardPage.AddExportedService";
    private static final String ADD_IMPORTED_SERVICE_KEY = "ServicesActivatorWizardPage.AddImportedService";
    private static final String CHOOSE_IMPLEMENTATION_CLASS_KEY = "ServicesActivatorWizardPage.ChooseImplementationClass";
    private static final String CLASS_KEY = "ServicesActivatorWizardPage.Class";
    private static final String CLASSES_AND_INTERFACES_KEY = "ServicesActivatorWizardPage.ClassesAndInterfaces";
    private static final String DESCRIPTION_KEY = "ServicesActivatorWizardPage.Description";
    private static final String EDIT_KEY = "ServicesActivatorWizardPage.Edit";
    private static final String EDIT_EXPORTED_SERVICE_KEY = "ServicesActivatorWizardPage.EditExportedService";
    private static final String EDIT_IMPORTED_SERVICE_KEY = "ServicesActivatorWizardPage.EditImportedService";
    private static final String EDIT_TYPE_SCOPE_KEY = "ServicesActivatorWizardPage.EditTypeScope";
    private static final String EXPORTED_SERVICES_KEY = "ServicesActivatorWizardPage.ExportedServices";
    private static final String FIELD_KEY = "ServicesActivatorWizardPage.Field";
    private static final String FILTERED_KEY = "ServicesActivatorWizardPage.Filtered";
    private static final String IMPLEMENTATION_CLASS_KEY = "ServicesActivatorWizardPage.ImplementationClass";
    private static final String IMPORTED_SERVICES_KEY = "ServicesActivatorWizardPage.ImportedServices";
    private static final String INTERFACES_KEY = "ServicesActivatorWizardPage.Interfaces";
    private static final String OPTIONAL_KEY = "ServicesActivatorWizardPage.Optional";
    private static final String PROJECT_KEY = "ServicesActivatorWizardPage.Project";
    private static final String PROPERTIES_KEY = "ServicesActivatorWizardPage.Properties";
    private static final String PROXY_KEY = "ServicesActivatorWizardPage.Proxy";
    private static final String REMOVE_KEY = "ServicesActivatorWizardPage.Remove";
    private static final String REMOVE_EXPORTED_SERVICES_KEY = "ServicesActivatorWizardPage.RemoveExportedServices";
    private static final String REMOVE_IMPORTED_SERVICES_KEY = "ServicesActivatorWizardPage.RemoveImportedServices";
    private static final String SERVICE_NAME_KEY = "ServicesActivatorWizardPage.ServiceName";
    private static final String TITLE_KEY = "ServicesActivatorWizardPage.Title";
    private static final String TYPE_SCOPE_PREFERENCES_PROMPT_KEY = "ServicesActivatorWizardPage.TypeScopePreferencesPrompt";
    private static final String TYPE_SCOPE_PREFERENCES_TITLE_KEY = "ServicesActivatorWizardPage.TypeScopePreferencesTitle";
    private static final String TYPE_SCOPE_TEMPLATE_KEY = "ServicesActivatorWizardPage.TypeScopeTemplateKey";
    private static final String WORKSPACE_KEY = "ServicesActivatorWizardPage.Workspace";
    private static final String FIELD_COLUMN_ID = "field";
    private static final String FILTERED_COLUMN_ID = "filtered";
    private static final String IMPLEMENTATION_CLASS_COLUMN_ID = "implementationClass";
    private static final String OPTIONAL_COLUMN_ID = "optional";
    private static final String PROPERTIES_COLUMN_ID = "properties";
    private static final String PROXY_COLUMN_ID = "proxy";
    private static final String SERVICE_NAME_COLUMN_ID = "serviceName";
    private static final int CHECKBOX_COLUMN_WIDTH = 70;
    private static final int SERVICE_NAME_COLUMN_WIDTH = 200;
    private static final int IMPLEMENTATION_CLASS_COLUMN_WIDTH = 200;
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.servicesActivatorWizardPage";
    public static final String PAGE_NAME;
    private TableViewer importedServicesTableViewer;
    private TableViewer exportedServicesTableViewer;
    private Button editExportedServiceButton;
    private Button editImportedServiceButton;
    private Button removeExportedServicesButton;
    private Button removeImportedServicesButton;
    private Button implementationClassButton;
    private Button editTypeScopeButton;
    private boolean exportedServiceIsStoredInField;
    private boolean exportedServiceHasProperties;
    private boolean exportedProxyService;
    private boolean importedServiceIsFiltered;
    private boolean importedServiceIsOptional;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesActivatorWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public ServicesActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
        this.initializeFromPreferences();
    }

    private void addExportedService(IType type) {
        org.eclipse.soda.sat.plugin.activator.util.FactoryUtility utility = org.eclipse.soda.sat.plugin.activator.util.FactoryUtility.getInstance();
        String name = type.getFullyQualifiedName();
        int serviceType = this.getServiceType(type);
        boolean storedInField = this.getExportedServiceIsStoredInField();
        boolean hasProperties = this.getExportedServiceHasProperties();
        boolean proxy = this.getExportedProxyService();
        IExportedServiceDetails details = utility.createExportedServiceDetails(name, serviceType, storedInField, hasProperties, proxy);
        IActivatorWizardModel model = this.getModel();
        model.addExportedServiceDetails(details);
        this.addBundleDependencyFor(type);
    }

    private void addImportedService(IType type) {
        org.eclipse.soda.sat.plugin.activator.util.FactoryUtility utility = org.eclipse.soda.sat.plugin.activator.util.FactoryUtility.getInstance();
        String name = type.getFullyQualifiedName();
        int serviceType = this.getServiceType(type);
        boolean filtered = this.getImportedServiceIsFiltered();
        boolean optional = this.getImportedServiceIsOptional();
        IImportedServiceDetails details = utility.createImportedServiceDetails(name, serviceType, filtered, optional);
        IActivatorWizardModel model = this.getModel();
        model.addImportedServiceDetails(details);
        this.addBundleDependencyFor(type);
    }

    private void buildEditTypeScopeRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServicesActivatorWizardPage.this.handleEditTypeScopeButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, EDIT_TYPE_SCOPE_KEY, (SelectionListener)listener);
        this.setEditTypeScopeButton(button);
        this.updateEditTypeScopeButtonToolTip();
        GridData data = new GridData(1, 1, false, false);
        button.setLayoutData((Object)data);
    }

    private void buildExportedServicesRow(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 1;
        this.createLabelComposite(composite, EXPORTED_SERVICES_KEY, "bundle-exporter", 2);
        this.createExportedServicesTableViewer(composite);
        this.createExportedServicesButtons(composite);
    }

    private void buildImportedServicesRow(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.setVerticalSpacing(composite, 3);
        this.createLabelComposite(composite, IMPORTED_SERVICES_KEY, "bundle-importer", 2);
        this.createImportedServicesTableViewer(composite);
        this.createImportedServicesButtons(composite);
    }

    protected void buildPage(Composite parent) {
        this.buildImportedServicesRow(parent);
        this.buildExportedServicesRow(parent);
        this.buildSeparator(parent);
        this.buildEditTypeScopeRow(parent);
    }

    private final int calculateRemainingHorizontalSpace(Table table, int startColumn) {
        boolean visible;
        Rectangle bounds = table.getBounds();
        boolean bl = visible = bounds.width != 0 || bounds.height != 0;
        if (!visible) {
            return 0;
        }
        int width = bounds.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        ScrollBar scrollbar = table.getVerticalBar();
        Point scrollbarSize = scrollbar.getSize();
        width -= scrollbarSize.x;
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = startColumn;
        while (i < count) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative + 10;
        return remainder;
    }

    private void createAddExportedServicesButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleAddExportedServiceButtonClicked();
            }
        };
        this.createButton(parent, 8, ADD_KEY, ADD_EXPORTED_SERVICE_KEY, (SelectionListener)listener);
    }

    private void createAddImportedServicesButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleAddImportedServiceButtonClicked();
            }
        };
        this.createButton(parent, 8, ADD_KEY, ADD_IMPORTED_SERVICE_KEY, (SelectionListener)listener);
    }

    private void createEditExportedServiceButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleEditExportedServiceButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, EDIT_KEY, EDIT_EXPORTED_SERVICE_KEY, (SelectionListener)listener);
        this.setEditExportedServiceButton(button);
        button.setEnabled(false);
    }

    private void createEditImportedServiceButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleEditImportedServiceButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, EDIT_KEY, EDIT_IMPORTED_SERVICE_KEY, (SelectionListener)listener);
        this.setEditImportedServiceButton(button);
        button.setEnabled(false);
    }

    private ICellModifier createExportedServiceCellModifier(final TableViewer viewer) {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals(ServicesActivatorWizardPage.FIELD_COLUMN_ID)) {
                    return true;
                }
                if (property.equals(ServicesActivatorWizardPage.PROPERTIES_COLUMN_ID)) {
                    return true;
                }
                return property.equals(ServicesActivatorWizardPage.PROXY_COLUMN_ID);
            }

            public Object getValue(Object element, String property) {
                boolean state;
                IExportedServiceDetails details = (IExportedServiceDetails)element;
                if (property.equals(ServicesActivatorWizardPage.FIELD_COLUMN_ID)) {
                    state = details.isStoredInField();
                } else if (property.equals(ServicesActivatorWizardPage.PROPERTIES_COLUMN_ID)) {
                    state = details.hasProperties();
                } else if (property.equals(ServicesActivatorWizardPage.PROXY_COLUMN_ID)) {
                    state = details.isProxy();
                } else {
                    return null;
                }
                Boolean value = state;
                return value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                IExportedServiceDetails details = (IExportedServiceDetails)item.getData();
                if (property.equals(ServicesActivatorWizardPage.FIELD_COLUMN_ID)) {
                    boolean state = !details.isStoredInField();
                    details.setStoredInField(state);
                } else if (property.equals(ServicesActivatorWizardPage.PROPERTIES_COLUMN_ID)) {
                    boolean state = !details.hasProperties();
                    details.setHasProperties(state);
                } else if (property.equals(ServicesActivatorWizardPage.PROXY_COLUMN_ID)) {
                    boolean state = !details.isProxy();
                    details.setProxy(state);
                } else {
                    return;
                }
                viewer.update((Object)details, null);
            }
        };
    }

    private void createExportedServicesButtons(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false, true);
        this.createAddExportedServicesButton(composite);
        this.createEditExportedServiceButton(composite);
        this.createRemoveExportedServicesButton(composite);
        this.createImplementationClassButton(composite);
    }

    private CellEditor[] createExportedServicesCellEditors(Table table) {
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[2] = new CheckboxCellEditor((Composite)table);
        cellEditorArray[3] = new CheckboxCellEditor((Composite)table);
        cellEditorArray[4] = new CheckboxCellEditor((Composite)table);
        return cellEditorArray;
    }

    private String[] createExportedServicesColumnProperties() {
        return new String[]{SERVICE_NAME_COLUMN_ID, IMPLEMENTATION_CLASS_COLUMN_ID, FIELD_COLUMN_ID, PROPERTIES_COLUMN_ID, PROXY_COLUMN_ID};
    }

    private void createExportedServicesTableColumns(Table table) {
        this.createTableColumn(table, SERVICE_NAME_KEY, 200);
        this.createTableColumn(table, IMPLEMENTATION_CLASS_KEY, 200);
        this.createTableColumn(table, FIELD_KEY, 70);
        this.createTableColumn(table, PROPERTIES_KEY, 70);
        this.createTableColumn(table, PROXY_KEY, 70);
    }

    private ControlListener createExportedServicesTableControlListener() {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ServicesActivatorWizardPage.this.handleExportedServicesTableResized();
            }
        };
    }

    private void createExportedServicesTableViewer(Composite parent) {
        int style = this.createServicesTableStyle();
        ExportedServicesTableLabelProvider labelProvider = new ExportedServicesTableLabelProvider();
        ArrayContentProvider contentProvider = new ArrayContentProvider();
        ISelectionChangedListener listener = this.createExportedServicesTableViewerSelectionChangedListener();
        TableViewer viewer = this.createTableViewer(parent, style, labelProvider, (IContentProvider)contentProvider, listener);
        this.setExportedServicesTableViewer(viewer);
        ControlListener controlListener = this.createExportedServicesTableControlListener();
        parent.addControlListener(controlListener);
        Table table = viewer.getTable();
        this.createExportedServicesTableColumns(table);
        String[] columnProperties = this.createExportedServicesColumnProperties();
        viewer.setColumnProperties(columnProperties);
        CellEditor[] editors = this.createExportedServicesCellEditors(table);
        viewer.setCellEditors(editors);
        ICellModifier modifier = this.createExportedServiceCellModifier(viewer);
        viewer.setCellModifier(modifier);
        IActivatorWizardModel model = this.getModel();
        List list = model.getExportedServicesDetails();
        viewer.setInput((Object)list);
    }

    private ISelectionChangedListener createExportedServicesTableViewerSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServicesActivatorWizardPage.this.handleExportedServicesTableSelectionChanged(event);
            }
        };
    }

    private void createImplementationClassButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleImplementationClassButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, CLASS_KEY, CHOOSE_IMPLEMENTATION_CLASS_KEY, (SelectionListener)listener);
        this.setImplementationClassButton(button);
        button.setEnabled(false);
    }

    private ICellModifier createImportedServiceCellModifier(final TableViewer viewer) {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals(ServicesActivatorWizardPage.FILTERED_COLUMN_ID)) {
                    return true;
                }
                return property.equals(ServicesActivatorWizardPage.OPTIONAL_COLUMN_ID);
            }

            public Object getValue(Object element, String property) {
                boolean state;
                IImportedServiceDetails details = (IImportedServiceDetails)element;
                if (property.equals(ServicesActivatorWizardPage.FILTERED_COLUMN_ID)) {
                    state = details.isFiltered();
                } else if (property.equals(ServicesActivatorWizardPage.OPTIONAL_COLUMN_ID)) {
                    state = details.isFiltered();
                } else {
                    return null;
                }
                Boolean value = state;
                return value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                IImportedServiceDetails details = (IImportedServiceDetails)item.getData();
                if (property.equals(ServicesActivatorWizardPage.FILTERED_COLUMN_ID)) {
                    boolean state = !details.isFiltered();
                    details.setFiltered(state);
                } else if (property.equals(ServicesActivatorWizardPage.OPTIONAL_COLUMN_ID)) {
                    boolean state = !details.isOptional();
                    details.setOptional(state);
                } else {
                    return;
                }
                viewer.update((Object)details, null);
            }
        };
    }

    private void createImportedServicesButtons(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false, true);
        this.createAddImportedServicesButton(composite);
        this.createEditImportedServiceButton(composite);
        this.createRemoveImportedServicesButton(composite);
    }

    private CellEditor[] createImportedServicesCellEditors(Table table) {
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new CheckboxCellEditor((Composite)table);
        cellEditorArray[2] = new CheckboxCellEditor((Composite)table);
        return cellEditorArray;
    }

    private String[] createImportedServicesColumnProperties() {
        return new String[]{SERVICE_NAME_COLUMN_ID, FILTERED_COLUMN_ID, OPTIONAL_COLUMN_ID};
    }

    private void createImportedServicesTableColumns(Table table) {
        this.createTableColumn(table, SERVICE_NAME_KEY, 200);
        this.createTableColumn(table, FILTERED_KEY, 70);
        this.createTableColumn(table, OPTIONAL_KEY, 70);
    }

    private ControlListener createImportedServicesTableControlListener() {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ServicesActivatorWizardPage.this.handleImportedServicesTableResized();
            }
        };
    }

    private void createImportedServicesTableViewer(Composite parent) {
        int style = this.createServicesTableStyle();
        ImportedServicesTableLabelProvider labelProvider = new ImportedServicesTableLabelProvider();
        ArrayContentProvider contentProvider = new ArrayContentProvider();
        ISelectionChangedListener listener = this.createImportedServicesTableViewerSelectionChangedListener();
        TableViewer viewer = this.createTableViewer(parent, style, labelProvider, (IContentProvider)contentProvider, listener);
        this.setImportedServicesTableViewer(viewer);
        ControlListener controlListener = this.createImportedServicesTableControlListener();
        parent.addControlListener(controlListener);
        Table table = viewer.getTable();
        Dialog.applyDialogFont((Control)table);
        this.createImportedServicesTableColumns(table);
        String[] columnProperties = this.createImportedServicesColumnProperties();
        viewer.setColumnProperties(columnProperties);
        CellEditor[] editors = this.createImportedServicesCellEditors(table);
        viewer.setCellEditors(editors);
        ICellModifier modifier = this.createImportedServiceCellModifier(viewer);
        viewer.setCellModifier(modifier);
        IActivatorWizardModel model = this.getModel();
        List list = model.getImportedServicesDetails();
        viewer.setInput((Object)list);
    }

    private ISelectionChangedListener createImportedServicesTableViewerSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Button button = ServicesActivatorWizardPage.this.getRemoveImportedServicesButton();
                boolean state = selection.isEmpty();
                button.setEnabled(!state);
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                state = structuredSelection.size() == 1;
                button = ServicesActivatorWizardPage.this.getEditImportedServiceButton();
                button.setEnabled(state);
            }
        };
    }

    private Composite createLabelComposite(Composite parent, String labelKey, String imageKey, int horizontalSpan) {
        Composite composite = this.createComposite(parent, 2, true, false);
        GridData data = new GridData(1, 0x1000000, true, false, horizontalSpan, 1);
        composite.setLayoutData((Object)data);
        Activator activator = Activator.getDefault();
        Image image = activator.getImage(imageKey);
        Label label = this.createLabel(composite, null, 1);
        label.setImage(image);
        this.createLabel(composite, labelKey, 1);
        return composite;
    }

    private void createRemoveExportedServicesButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleRemoveExportedServicesButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, REMOVE_KEY, REMOVE_EXPORTED_SERVICES_KEY, (SelectionListener)listener);
        this.setRemoveExportedServicesButton(button);
        button.setEnabled(false);
    }

    private void createRemoveImportedServicesButton(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesActivatorWizardPage.this.handleRemoveImportedServiceButtonClicked();
            }
        };
        Button button = this.createButton(parent, 8, REMOVE_KEY, REMOVE_IMPORTED_SERVICES_KEY, (SelectionListener)listener);
        this.setRemoveImportedServicesButton(button);
        button.setEnabled(false);
    }

    private int createServicesTableStyle() {
        return 67586;
    }

    private void createTableColumn(Table table, String columnLabelKey, int width) {
        TableColumn column = new TableColumn(table, 0);
        String text = Messages.getString(columnLabelKey);
        column.setText(text);
        column.setWidth(width);
    }

    private void enableEditExportedServiceButton(boolean enable) {
        Button button = this.getEditExportedServiceButton();
        button.setEnabled(enable);
    }

    private void enableImplementationClassButton(boolean enable) {
        Button button = this.getImplementationClassButton();
        button.setEnabled(enable);
    }

    private void enableRemoveExportedServicesButton(boolean enable) {
        Button button = this.getRemoveExportedServicesButton();
        button.setEnabled(enable);
    }

    public void finish() {
        this.updatePreferences();
        super.finish();
    }

    private Button getEditExportedServiceButton() {
        return this.editExportedServiceButton;
    }

    private Button getEditImportedServiceButton() {
        return this.editImportedServiceButton;
    }

    private Button getEditTypeScopeButton() {
        return this.editTypeScopeButton;
    }

    private boolean getExportedProxyService() {
        return this.exportedProxyService;
    }

    private boolean getExportedServiceHasProperties() {
        return this.exportedServiceHasProperties;
    }

    private boolean getExportedServiceIsStoredInField() {
        return this.exportedServiceIsStoredInField;
    }

    private TableViewer getExportedServicesTableViewer() {
        return this.exportedServicesTableViewer;
    }

    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private Button getImplementationClassButton() {
        return this.implementationClassButton;
    }

    private boolean getImportedServiceIsFiltered() {
        return this.importedServiceIsFiltered;
    }

    private boolean getImportedServiceIsOptional() {
        return this.importedServiceIsOptional;
    }

    private TableViewer getImportedServicesTableViewer() {
        return this.importedServicesTableViewer;
    }

    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    private Button getRemoveExportedServicesButton() {
        return this.removeExportedServicesButton;
    }

    private Button getRemoveImportedServicesButton() {
        return this.removeImportedServicesButton;
    }

    private int getServiceType(IType type) {
        int serviceType = -1;
        try {
            if (type.isClass()) {
                serviceType = 1;
            } else if (type.isInterface()) {
                serviceType = 0;
            }
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return serviceType;
    }

    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    private void handleAddExportedServiceButtonClicked() {
        IType[] types = this.openChooseServiceTypeDialog();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            this.addExportedService(type);
            ++i;
        }
    }

    private void handleAddImportedServiceButtonClicked() {
        IType[] types = this.openChooseServiceTypeDialog();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            this.addImportedService(type);
            ++i;
        }
    }

    private void handleEditExportedServiceButtonClicked() {
        TableViewer viewer = this.getExportedServicesTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        IExportedServiceDetails details = (IExportedServiceDetails)selection.getFirstElement();
        String name = details.getName();
        IType[] types = this.openChooseServiceTypeDialog(name, false);
        if (types.length == 0) {
            return;
        }
        IActivatorWizardModel model = this.getModel();
        model.removeExportedServiceDetails(details);
        IType type = types[0];
        String fullyQualifiedName = type.getFullyQualifiedName();
        boolean exists = model.containsExportedService(fullyQualifiedName);
        if (exists) {
            return;
        }
        details.setName(fullyQualifiedName);
        int serviceType = this.getServiceType(type);
        details.setType(serviceType);
        details.setImplementationClassName(null);
        model.addExportedServiceDetails(details);
    }

    private void handleEditImportedServiceButtonClicked() {
        TableViewer viewer = this.getImportedServicesTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        IImportedServiceDetails details = (IImportedServiceDetails)selection.getFirstElement();
        String name = details.getName();
        IType[] types = this.openChooseServiceTypeDialog(name, false);
        if (types.length == 0) {
            return;
        }
        IActivatorWizardModel model = this.getModel();
        model.removeImportedServiceDetails(details);
        IType type = types[0];
        String fullyQualifiedName = type.getFullyQualifiedName();
        boolean exists = model.containsImportedService(fullyQualifiedName);
        if (exists) {
            return;
        }
        details.setName(fullyQualifiedName);
        int serviceType = this.getServiceType(type);
        details.setType(serviceType);
        model.addImportedServiceDetails(details);
    }

    private void handleEditTypeScopeButtonClicked() {
        String limitServicesToInterfaceTypesLabel = Messages.getString("TypeScopePreferencesCompositeBuilder.LimitServicesToInterfaceTypes");
        String limitServicesToTypesVisibleToProjectLabel = Messages.getString("TypeScopePreferencesCompositeBuilder.LimitServicesToTypesVisibleToTheProject");
        Object[] values = new Object[]{limitServicesToInterfaceTypesLabel, limitServicesToTypesVisibleToProjectLabel};
        String pattern = Messages.getString(TYPE_SCOPE_PREFERENCES_PROMPT_KEY);
        String prompt = MessageFormat.format(pattern, values);
        Shell shell = this.getShell();
        FactoryUtility utility = FactoryUtility.getInstance();
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, prompt);
        String title = Messages.getString(TYPE_SCOPE_PREFERENCES_TITLE_KEY);
        dialog.setTitle(title);
        dialog.setYesButtonText(String.valueOf('&') + IDialogConstants.OK_LABEL);
        dialog.setNoButtonText(null);
        dialog.defaultButtonIsYes();
        dialog.setSize(525, 299);
        boolean limitServicesToInterfaceTypes = this.getLimitServicesToInterfaceTypes();
        int limitServicesToInterfaceTypesCheckboxId = dialog.addCheckbox(limitServicesToInterfaceTypesLabel, limitServicesToInterfaceTypes);
        boolean limitServicesToTypesVisibleToProject = this.getLimitServicesToTypesVisibleToProject();
        int limitServicesToTypesVisibleToProjectCheckboxId = dialog.addCheckbox(limitServicesToTypesVisibleToProjectLabel, limitServicesToTypesVisibleToProject);
        int rc = dialog.open();
        if (rc == 1) {
            return;
        }
        limitServicesToInterfaceTypes = dialog.isCheckboxSelected(limitServicesToInterfaceTypesCheckboxId);
        this.setLimitServicesToInterfaceTypes(limitServicesToInterfaceTypes);
        limitServicesToTypesVisibleToProject = dialog.isCheckboxSelected(limitServicesToTypesVisibleToProjectCheckboxId);
        this.setLimitServicesToTypesVisibleToProject(limitServicesToTypesVisibleToProject);
        this.updateEditTypeScopeButtonToolTip();
    }

    protected void handleExportedServiceDetailsChanged(List details) {
        TableViewer viewer = this.getExportedServicesTableViewer();
        viewer.setInput((Object)details);
    }

    private void handleExportedServicesTableResized() {
        TableViewer viewer = this.getExportedServicesTableViewer();
        Table table = viewer.getTable();
        int width = this.calculateRemainingHorizontalSpace(table, 2);
        if (width == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        column.setWidth(width /= 2);
        column = columns[1];
        column.setWidth(width);
    }

    private void handleExportedServicesTableSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        boolean empty = selection.isEmpty();
        boolean state = !empty;
        this.enableRemoveExportedServicesButton(state);
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        int size = structuredSelection.size();
        state = size == 1;
        this.enableEditExportedServiceButton(state);
        if (state) {
            IExportedServiceDetails details = (IExportedServiceDetails)structuredSelection.getFirstElement();
            int type = details.getType();
            state = type == 0;
        }
        this.enableImplementationClassButton(state);
    }

    private void handleImplementationClassButtonClicked() {
        TableViewer viewer = this.getExportedServicesTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        IExportedServiceDetails details = (IExportedServiceDetails)selection.getFirstElement();
        String implementationClassName = null;
        IType[] types = this.openChooseServiceTypeDialog(new String(), false, 2);
        if (types.length != 0) {
            IType type = types[0];
            String name = details.getName();
            try {
                String[] superInterfaceNames = type.getSuperInterfaceNames();
                int index = 0;
                boolean valid = false;
                while (!valid && index < superInterfaceNames.length) {
                    String superInterfaceName = superInterfaceNames[index];
                    valid = name.endsWith(superInterfaceName);
                    ++index;
                }
                if (!valid) {
                    return;
                }
                implementationClassName = type.getFullyQualifiedName();
            }
            catch (JavaModelException exception) {
                exception.printStackTrace();
            }
        }
        details.setImplementationClassName(implementationClassName);
        viewer.refresh();
    }

    protected void handleImportedServiceDetailsChanged(List details) {
        TableViewer viewer = this.getImportedServicesTableViewer();
        viewer.setInput((Object)details);
    }

    private void handleImportedServicesTableResized() {
        TableViewer viewer = this.getImportedServicesTableViewer();
        Table table = viewer.getTable();
        int width = this.calculateRemainingHorizontalSpace(table, 1);
        if (width == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        column.setWidth(width);
    }

    private void handleRemoveExportedServicesButtonClicked() {
        TableViewer viewer = this.getExportedServicesTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            IExportedServiceDetails details = (IExportedServiceDetails)iterator.next();
            this.removeExportedService(details);
        }
    }

    private void handleRemoveImportedServiceButtonClicked() {
        TableViewer viewer = this.getImportedServicesTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            IImportedServiceDetails details = (IImportedServiceDetails)iterator.next();
            this.removeImportedService(details);
        }
    }

    private void initializeFromPreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = preferences.getStoreExportedServicesInFields();
        this.setExportedServiceIsStoredInField(state);
        state = preferences.getExportServicesWithProperties();
        this.setExportedServiceHasProperties(state);
        state = preferences.getCreateExportedProxyServices();
        this.setExportedProxyService(state);
        state = preferences.getImportFilteredServices();
        this.setImportedServiceIsFiltered(state);
        state = preferences.getOptionallyImportServices();
        this.setImportedServiceIsOptional(state);
        state = preferences.getLimitServicesToInterfaceTypes();
        this.setLimitServicesToInterfaceTypes(state);
        state = preferences.getLimitServicesToTypesVisibleToTheProject();
        this.setLimitServicesToTypesVisibleToProject(state);
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private IType[] openChooseServiceTypeDialog() {
        return this.openChooseServiceTypeDialog(new String(), true);
    }

    private IType[] openChooseServiceTypeDialog(String text, boolean multipleSelection) {
        boolean state = this.getLimitServicesToInterfaceTypes();
        int style = state ? 4 : 512;
        IType[] types = this.openChooseServiceTypeDialog(text, multipleSelection, style);
        return types;
    }

    private IType[] openChooseServiceTypeDialog(String text, boolean multipleSelection, int style) {
        IType[] types = AbstractActivatorWizardPage.NO_TYPES;
        try {
            types = this.openChooseTypeDialog(text, multipleSelection, style);
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        return types;
    }

    private void removeExportedService(IExportedServiceDetails details) {
        IActivatorWizardModel model = this.getModel();
        model.removeExportedServiceDetails(details);
        String fullyQualifiedName = details.getName();
        this.removeBundleDependencyFor(fullyQualifiedName);
    }

    private void removeImportedService(IImportedServiceDetails details) {
        IActivatorWizardModel model = this.getModel();
        model.removeImportedServiceDetails(details);
        String fullyQualifiedName = details.getName();
        this.removeBundleDependencyFor(fullyQualifiedName);
    }

    private void setEditExportedServiceButton(Button editExportedServiceButton) {
        this.editExportedServiceButton = editExportedServiceButton;
    }

    private void setEditImportedServiceButton(Button editImportedServiceButton) {
        this.editImportedServiceButton = editImportedServiceButton;
    }

    private void setEditTypeScopeButton(Button editTypeScopeButton) {
        this.editTypeScopeButton = editTypeScopeButton;
    }

    private void setExportedProxyService(boolean exportedProxyService) {
        this.exportedProxyService = exportedProxyService;
    }

    private void setExportedServiceIsStoredInField(boolean exportedServiceIsStoredInField) {
        this.exportedServiceIsStoredInField = exportedServiceIsStoredInField;
    }

    private void setExportedServiceHasProperties(boolean exportedServiceHasProperties) {
        this.exportedServiceHasProperties = exportedServiceHasProperties;
    }

    private void setExportedServicesTableViewer(TableViewer exportedServicesTableViewer) {
        this.exportedServicesTableViewer = exportedServicesTableViewer;
    }

    private void setImplementationClassButton(Button implementationClassButton) {
        this.implementationClassButton = implementationClassButton;
    }

    private void setImportedServiceIsFiltered(boolean importedServiceIsFiltered) {
        this.importedServiceIsFiltered = importedServiceIsFiltered;
    }

    private void setImportedServiceIsOptional(boolean importedServiceIsOptional) {
        this.importedServiceIsOptional = importedServiceIsOptional;
    }

    private void setImportedServicesTableViewer(TableViewer importedServicesTableViewer) {
        this.importedServicesTableViewer = importedServicesTableViewer;
    }

    private void setRemoveExportedServicesButton(Button removeExportedServicesButton) {
        this.removeExportedServicesButton = removeExportedServicesButton;
    }

    private void setRemoveImportedServicesButton(Button removeImportedServicesButton) {
        this.removeImportedServicesButton = removeImportedServicesButton;
    }

    private void updateEditTypeScopeButtonToolTip() {
        boolean limitServicesToInterfaceTypes = this.getLimitServicesToInterfaceTypes();
        String key0 = limitServicesToInterfaceTypes ? INTERFACES_KEY : CLASSES_AND_INTERFACES_KEY;
        String value0 = Messages.getString(key0);
        boolean limitServicesToTypesVisibleToProject = this.getLimitServicesToTypesVisibleToProject();
        String key1 = limitServicesToTypesVisibleToProject ? PROJECT_KEY : WORKSPACE_KEY;
        String value1 = Messages.getString(key1);
        Object[] values = new Object[]{value0, value1};
        String pattern = Messages.getString(TYPE_SCOPE_TEMPLATE_KEY);
        String toolTip = MessageFormat.format(pattern, values);
        Button button = this.getEditTypeScopeButton();
        button.setToolTipText(toolTip);
    }

    private void updatePreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = this.getLimitServicesToInterfaceTypes();
        preferences.setLimitServicesToInterfaceTypes(state);
        state = this.getLimitServicesToTypesVisibleToProject();
        preferences.setLimitServicesToTypesVisibleToTheProject(state);
    }
}

