/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

class SourceFolderSelectionStatusValidator
implements ISelectionStatusValidator {
    private Class[] acceptableTypes;

    SourceFolderSelectionStatusValidator(Class[] acceptableTypes) {
        this.setAcceptableTypes(acceptableTypes);
    }

    private Class[] getAcceptableTypes() {
        return this.acceptableTypes;
    }

    private boolean isOfAcceptedType(Object o) {
        boolean acceptable = false;
        Class[] acceptableTypes = this.getAcceptableTypes();
        int i = 0;
        while (!acceptable && i < acceptableTypes.length) {
            Class type = acceptableTypes[i];
            acceptable = type.isInstance(o);
            ++i;
        }
        return acceptable;
    }

    private boolean isValid(Object element) {
        boolean valid = true;
        try {
            if (element instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)element;
                IProject project = javaProject.getProject();
                IPath path = project.getFullPath();
                IPackageFragmentRoot root = javaProject.findPackageFragmentRoot(path);
                valid = root != null;
            } else if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                int kind = root.getKind();
                valid = kind == 1;
            }
        }
        catch (JavaModelException exception) {
            this.logError(exception);
            valid = false;
        }
        return valid;
    }

    private boolean isValid(Object[] selection) {
        if (selection.length != 1) {
            return false;
        }
        Object object = selection[0];
        boolean valid = this.isOfAcceptedType(object) && this.isValid(object);
        return valid;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private void setAcceptableTypes(Class[] acceptableTypes) {
        this.acceptableTypes = acceptableTypes;
    }

    public IStatus validate(Object[] elements) {
        boolean valid = this.isValid(elements);
        StatusInfo status = valid ? new StatusInfo() : new StatusInfo(4, "");
        return status;
    }
}

