/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;

class SourceFolderViewerFilter
extends ViewerFilter {
    private Class[] types;

    SourceFolderViewerFilter(Class[] types) {
        this.setTypes(types);
    }

    private Class[] getTypes() {
        return this.types;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        boolean match = false;
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                int kind = root.getKind();
                match = kind == 1;
            }
            catch (JavaModelException exception) {
                this.logError(exception);
                return false;
            }
        } else {
            int i = 0;
            Class[] types = this.getTypes();
            while (!match && i < types.length) {
                Class type = types[i];
                match = type.isInstance(element);
                ++i;
            }
        }
        return match;
    }

    private void setTypes(Class[] types) {
        this.types = types;
    }
}

