/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigurableObject
extends EscObject {
    private ConfigurationService configurationService;

    public static void validateConfiguration(String pid, Dictionary properties, MetaTypeInformation info) throws ConfigurationException {
        try {
            String[] pids;
            String[] locales = info.getLocales();
            if (locales.length > 0 && (pids = info.getFactoryPids()).length > 0) {
                ObjectClassDefinition objectClassDefinition = info.getObjectClassDefinition(pids[0], locales[0]);
                AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(-1);
                int k = 0;
                while (k < attributeDefinitions.length) {
                    String validateResult;
                    String id = attributeDefinitions[k].getID();
                    Object value = properties.get(id);
                    if (value instanceof String && (validateResult = attributeDefinitions[k].validate(value.toString())) != null && validateResult.length() > 0) {
                        ConfigurableObject.handleStaticException((Throwable)new ConfigurationException(id, value.toString()));
                    }
                    ++k;
                }
            }
        }
        catch (Exception exception) {
            ConfigurableObject.handleStaticException(exception);
        }
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        this.configurationService = configurationInformation != null ? new EscConfiguration(configurationInformation) : null;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

