/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;

public class EscConfiguration
implements ConfigurationService {
    private static final String NAME = "esc.properties";
    private static ConfigurationService Configuration = new EscConfiguration();
    private Dictionary properties;

    public EscConfiguration() {
        this.properties = this.getDefaultProperties();
    }

    public EscConfiguration(Dictionary properties) {
        this.properties = properties;
    }

    public static ConfigurationService getConfiguration() {
        return Configuration;
    }

    public static void setConfiguration(ConfigurationService configuration) {
        Configuration = configuration;
    }

    public boolean getBoolean(String key, boolean defaultBoolean) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value != null) {
                try {
                    return Boolean.valueOf(value.toString());
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultBoolean;
    }

    protected Properties getDefaultProperties() {
        Properties result = new Properties();
        try {
            FileInputStream stream = new FileInputStream(NAME);
            BufferedInputStream bstream = new BufferedInputStream(stream);
            result.load(bstream);
            bstream.close();
        }
        catch (Exception exception) {}
        return result;
    }

    public float getFloat(String key, float defaultFloat) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            if (value != null) {
                try {
                    return Float.parseFloat(value.toString());
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultFloat;
    }

    public int getInt(String key, int defaultInt) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value != null) {
                try {
                    return Integer.parseInt(value.toString());
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultInt;
    }

    public long getLong(String key, long defaultLong) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value != null) {
                try {
                    return Long.parseLong(value.toString());
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultLong;
    }

    public Object getObject(String key, Object defaultObject) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value != null) {
                return value;
            }
            Object systemValue = System.getProperties().get(key);
            if (systemValue != null) {
                return systemValue;
            }
        }
        return defaultObject;
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = properties.get(key);
            if (value != null) {
                return value;
            }
            int index = key.indexOf(46, 0);
            if (index >= 0) {
                return this.getProperty(key.substring(index + 1));
            }
        }
        return null;
    }

    public String getString(String key, String defaultString) {
        Object value;
        Dictionary properties = this.getProperties();
        if (properties != null && (value = this.getProperty(key)) != null) {
            return value.toString();
        }
        return System.getProperty(key, defaultString);
    }

    public void put(String key, Object value) {
        Dictionary properties = this.getProperties();
        if (properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
    }

    public String toString() {
        if (this.properties != null) {
            return this.properties.toString();
        }
        return super.toString();
    }
}

