/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObjectResourceBundle;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.service.log.LogService;

public abstract class EscObject {
    public static final String ID_KEY = "id";
    public static final String ID_FILTER_KEY = "idimportfilter";
    public static final String ID_KEY_ANY = "#";
    public static final String KEY_KEY = "key";
    public static final String PREFIX_KEY = "prefix";
    public static final String[] TO_STRING_CONFIGURATION_KEYS = new String[]{"id"};
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_TRACE = 5;
    public static final int TRACE_LEVEL_NONE = 0;
    public static final int TRACE_LEVEL_MIN = 1;
    public static final int TRACE_LEVEL_LOW = 3;
    public static final int TRACE_LEVEL_NORMAL = 5;
    public static final int TRACE_LEVEL_HIGH = 7;
    public static final int TRACE_LEVEL_MAX = 10;
    public static final String EMPTY_STRING = "";
    public static final String TRACELEVEL_KEY = "esc.tracelevel";
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Integer[] INTEGER_TABLE = EscObject.createIntegerTable();
    private static final int[] LOG_LEVELS = new int[]{1, 2, 3, 4, 5};
    private static final String VM_LIBRARY_VERSION = System.getProperty("com.ibm.oti.vm.library.version", "22");
    public static final int UNKNOWN_ERROR_RESOURCE = 0;
    public static final int ERROR_OCCURRED_EXCEPTION_RESOURCE = 1;
    public static final int SLEEP_EXCEPTION_RESOURCE = 2;
    public static final int CLONE_EXCEPTION_RESOURCE = 3;
    public static final int SYSTEM_INFO_RESOURCE = 4;
    private static boolean Debug = EscObject.getStaticBoolean("esc.debug", false);
    private static ResourceBundle DefaultResourceBundle;
    private static LogService DefaultLogService;
    private static String[] LogLevelStrings;
    private static int LogLevel;
    private static int TraceLevel;
    private static Long CurrentTimestamp;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.core.EscObjectResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle(clazz);
        DefaultLogService = EscObject.createDefaultLogService();
        LogLevelStrings = new String[]{"error", "warning", "info", "Debug", "trace"};
        LogLevel = EscObject.getDefaultLogLevel();
        TraceLevel = EscObject.getStaticInt(TRACELEVEL_KEY, 0);
        CurrentTimestamp = EscObject.startupEscStatic();
    }

    public static LogService createDefaultLogService() {
        return LogUtility.getInstance().getLog();
    }

    public static Integer createInteger(int value) {
        if (value < INTEGER_TABLE.length && value > -1) {
            return INTEGER_TABLE[value];
        }
        return new Integer(value);
    }

    protected static final Integer[] createIntegerTable() {
        Integer[] table = new Integer[16];
        int i = 0;
        while (i < 16) {
            table[i] = new Integer(i);
            ++i;
        }
        return table;
    }

    public static Number createNumber(long value) {
        if (value < (long)INTEGER_TABLE.length && value > -1L) {
            return INTEGER_TABLE[(int)value];
        }
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new Integer((int)value);
        }
        return new Long(value);
    }

    public static Object getCurrentTimestamp() {
        long time = System.currentTimeMillis();
        if (time != CurrentTimestamp) {
            CurrentTimestamp = new Long(time);
        }
        return CurrentTimestamp;
    }

    private static int getDefaultLogLevel() {
        String log = EscObject.getStaticString("esc.loglevel", "trace");
        int i = 0;
        while (i < LogLevelStrings.length) {
            if (log.equals(LogLevelStrings[i])) {
                return LOG_LEVELS[i];
            }
            ++i;
        }
        return 5;
    }

    public static LogService getDefaultLogService() {
        return DefaultLogService;
    }

    public static String getDefaultResource(int resourceId) {
        return DefaultResourceBundle.getString(Integer.toString(resourceId));
    }

    public static String getLoadLibraryName(String baseName) {
        int length = baseName.length() + 2;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(baseName);
        buffer.append(EscObject.getVmLibraryVersion());
        return buffer.toString();
    }

    public static boolean getStaticBoolean(String key, boolean defaultBoolean) {
        return EscConfiguration.getConfiguration().getBoolean(key, defaultBoolean);
    }

    public static float getStaticFloat(String key, float defaultFloat) {
        return EscConfiguration.getConfiguration().getFloat(key, defaultFloat);
    }

    public static int getStaticInt(String key, int defaultInt) {
        return EscConfiguration.getConfiguration().getInt(key, defaultInt);
    }

    public static long getStaticLong(String key, long defaultLong) {
        return EscConfiguration.getConfiguration().getLong(key, defaultLong);
    }

    public static Object getStaticObject(String key, Object defaultObject) {
        return EscConfiguration.getConfiguration().getObject(key, defaultObject);
    }

    public static String getStaticString(String key, String defaultString) {
        return EscConfiguration.getConfiguration().getString(key, defaultString);
    }

    public static int getTraceLevel() {
        return TraceLevel;
    }

    public static String getVmLibraryVersion() {
        return VM_LIBRARY_VERSION;
    }

    public static void handleStaticError(String string) {
        EscObject.getDefaultLogService().log(1, string);
    }

    public static void handleStaticException(Throwable exception) {
        EscObject.getDefaultLogService().log(1, exception.getMessage(), exception);
    }

    public static boolean isDebug() {
        return Debug;
    }

    public static boolean isTrace() {
        return TraceLevel > 0;
    }

    public static Object loadService(String serviceName, String defaultClassName) throws RuntimeException {
        try {
            String className = EscObject.getStaticString(serviceName, defaultClassName);
            Class<?> implementationClass = Class.forName(className);
            return implementationClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void setDebug(boolean debug) {
        Debug = debug;
    }

    public static void setDefaultLogService(LogService defaultLogService) {
        DefaultLogService = defaultLogService == null ? LogUtility.getInstance().getLog() : defaultLogService;
    }

    public static void setTraceLevel(int traceLevel) {
        TraceLevel = traceLevel;
    }

    public static boolean shouldLog(int code) {
        return code <= LogLevel;
    }

    public static Long startupEscStatic() {
        ConfigurableObject object = new ConfigurableObject();
        object.setConfigurationService(EscConfiguration.getConfiguration());
        object.reportSystemInfo();
        return new Long(System.currentTimeMillis());
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        return true;
    }

    public RuntimeException createException(int resourceId) {
        return new RuntimeException(this.getResource(resourceId));
    }

    public RuntimeException createException(int resourceId, Object[] objects) {
        return new RuntimeException(Nls.format(this.getResource(resourceId), objects));
    }

    public String format(int resourceId, Object object) {
        return Nls.format(this.getResource(resourceId), new Object[]{object});
    }

    public boolean getBoolean(String key, boolean defaultBoolean) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getBoolean(key, EscObject.getStaticBoolean(key, defaultBoolean));
        }
        return EscObject.getStaticBoolean(key, defaultBoolean);
    }

    public ConfigurationService getConfigurationService() {
        return null;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 0: 
            case 1: 
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 3;
    }

    public float getFloat(String key, float defaultFloat) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getFloat(key, EscObject.getStaticFloat(key, defaultFloat));
        }
        return EscObject.getStaticFloat(key, defaultFloat);
    }

    public int getInt(String key, int defaultInt) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getInt(key, EscObject.getStaticInt(key, defaultInt));
        }
        return EscObject.getStaticInt(key, defaultInt);
    }

    public Object[] getLogDetails(Throwable error, Object details, Object details1, Object details2, Object details3) {
        return new Object[]{this.getLogDetails0(), this.getLogDetails1(), this.getLogDetails2(), this.getLogDetails3(), this.getLogDetails4(), this.getLogDetails5(), this.getLogDetails6(), this.getLogDetails7(), error, details, details1, details2, details3};
    }

    public Object getLogDetails0() {
        return String.valueOf(this);
    }

    public Object getLogDetails1() {
        return String.valueOf(this.getClass().getName());
    }

    public Object getLogDetails2() {
        return null;
    }

    public Object getLogDetails3() {
        return null;
    }

    public Object getLogDetails4() {
        return null;
    }

    public Object getLogDetails5() {
        return null;
    }

    public Object getLogDetails6() {
        return this.getConfigurationService();
    }

    public Object getLogDetails7() {
        return System.getProperties();
    }

    public LogService getLogService() {
        return EscObject.getDefaultLogService();
    }

    public long getLong(String key, long defaultLong) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getLong(key, EscObject.getStaticLong(key, defaultLong));
        }
        return EscObject.getStaticLong(key, defaultLong);
    }

    public Object getObject(String key, Object defaultObject) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getObject(key, EscObject.getStaticObject(key, defaultObject));
        }
        return EscObject.getStaticObject(key, defaultObject);
    }

    public String getOutputName() {
        String outputName = super.toString();
        int index = outputName.lastIndexOf(46);
        if (index > 0) {
            return outputName.substring(index + 1);
        }
        return outputName;
    }

    public String getResource(int resourceId) {
        return DefaultResourceBundle.getString(EscObjectResourceBundle.getKey(resourceId));
    }

    public String getSimpleClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index > 0) {
            return className.substring(index + 1);
        }
        return className;
    }

    public String getString(String key, String defaultString) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getString(key, EscObject.getStaticString(key, defaultString));
        }
        return EscObject.getStaticString(key, defaultString);
    }

    public void handleError(Throwable error, int resourceId) {
        this.handleError(error, resourceId, this.getLogDetails(error, null, null, null, null));
    }

    public void handleError(Throwable error, int resourceId, Object details) {
        this.handleError(error, resourceId, this.getLogDetails(error, details, null, null, null));
    }

    protected void handleError(Throwable error, int resourceId, Object[] objects) {
        this.reportError(resourceId, error, objects);
    }

    public void log(int severity, String message) {
        if (EscObject.shouldLog(severity)) {
            this.log(severity, message, null);
        }
    }

    public void log(int severity, String message, Throwable exception) {
        if (EscObject.shouldLog(severity)) {
            LogService logService = this.getLogService();
            if (logService != null) {
                try {
                    logService.log(severity, message, exception);
                }
                catch (Exception exception2) {}
            } else if (EscObject.isDebug() && exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void report(Throwable error, int resourceId) {
        this.report(resourceId, this.getLogDetails(error, null, null, null, null));
    }

    public void report(Throwable error, int resourceId, Object details) {
        this.report(resourceId, this.getLogDetails(error, details, null, null, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1) {
        this.report(resourceId, this.getLogDetails(error, details, details1, null, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1, Object details2) {
        this.report(resourceId, this.getLogDetails(error, details, details1, details2, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1, Object details2, Object details3) {
        this.report(resourceId, this.getLogDetails(error, details, details1, details2, details3));
    }

    public void report(int reportNumber, Object[] errorObjects) {
        int severity = this.getErrorSeverity(reportNumber, null);
        if (EscObject.shouldLog(severity)) {
            if (severity > 4) {
                this.log(4, Nls.format(this.getResource(reportNumber), errorObjects));
            } else {
                this.log(severity, Nls.format(this.getResource(reportNumber), errorObjects));
            }
            return;
        }
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        if (this.attemptRecoveryFromError(errorNumber, error)) {
            if (EscObject.shouldLog(this.getErrorSeverity(errorNumber, error))) {
                this.log(this.getErrorSeverity(errorNumber, error), Nls.format(this.getResource(errorNumber), errorObjects), error);
            }
            return;
        }
        String message = Nls.format(this.getResource(errorNumber), errorObjects);
        this.log(this.getErrorSeverity(errorNumber, error), message, error);
        if (error != null) {
            throw new RuntimeException(error.getMessage());
        }
        throw new RuntimeException(message);
    }

    public void reportSystemInfo() {
        this.report(null, 4);
    }

    public void setLogService(LogService logService) {
        EscObject.setDefaultLogService(logService);
    }

    public void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        this.toStringInfo(buffer);
        return buffer.toString();
    }

    public String[] toStringConfigurationKeys() {
        return TO_STRING_CONFIGURATION_KEYS;
    }

    public void toStringInfo(StringBuffer buffer) {
        block6: {
            Object value;
            String key;
            String[] configurationKeys;
            Dictionary configuration;
            block7: {
                ConfigurationService configurationService = this.getConfigurationService();
                if (configurationService == null || (configuration = configurationService.getProperties()) == null) break block6;
                configurationKeys = this.toStringConfigurationKeys();
                if (configurationKeys != null) break block7;
                buffer.append(configuration);
                break block6;
            }
            int count = 0;
            int i = 0;
            while (i < configurationKeys.length) {
                key = configurationKeys[i];
                value = configuration.get(key);
                if (value != null) {
                    buffer.append(',');
                    buffer.append(key);
                    buffer.append('=');
                    buffer.append(value);
                    ++count;
                }
                ++i;
            }
            if (count != 0) break block6;
            if (configuration instanceof Hashtable) {
                Iterator iterator = ((Hashtable)configuration).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object key2 = entry.getKey();
                    String value2 = String.valueOf(entry.getValue());
                    if (value2.length() <= 0) continue;
                    buffer.append(',');
                    buffer.append(key2);
                    buffer.append('=');
                    buffer.append(value2);
                }
            } else {
                Enumeration enumeration = configuration.keys();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    value = String.valueOf(configuration.get(key));
                    if (((String)value).length() <= 0) continue;
                    buffer.append(',');
                    buffer.append((Object)key);
                    buffer.append('=');
                    buffer.append((String)value);
                }
            }
        }
    }
}

