/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.eclipse.soda.dk.core.EscObject;

public class Nls {
    public static final byte[] HEX_UPPER_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final char[] HEX_CHAR_LOWER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEX_CHAR_UPPER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String PROPERTY_EXTENSION = ".properties";
    private static final int PROPERTY_EXTENSION_LENGTH = ".properties".length();
    private static final String[] NLS_ADDITIONS = Nls.computeNlsAdditions();
    protected static final char[] CR = "\\r".toCharArray();
    protected static final char[] LF = "\\n".toCharArray();
    protected static final char[] TAB = "\\t".toCharArray();
    protected static final char[] OPEN_TIME = " (.".toCharArray();

    private static String[] computeNlsAdditions() {
        Locale locale = Locale.getDefault();
        Vector<String> list = new Vector<String>(3);
        list.addElement("");
        StringBuffer buffer = new StringBuffer();
        String[] possible = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        int plength = possible.length;
        int i = 0;
        while (i < plength) {
            if (possible[i] != null && possible[i].length() > 0) {
                buffer.append('_');
                buffer.append(possible[i]);
                list.addElement(buffer.toString());
            }
            ++i;
        }
        String[] results = new String[list.size()];
        int max = results.length - 1;
        int i2 = 0;
        while (i2 < results.length) {
            results[i2] = String.valueOf(list.elementAt(max - i2));
            ++i2;
        }
        return results;
    }

    public static String format(String pattern, Object object) {
        return Nls.format(pattern, new Object[]{object});
    }

    public static String format(String pattern, Object[] objects) {
        char[] patternChar = pattern.toCharArray();
        int length = (pattern.length() << 2) + (objects.length << 6);
        StringBuffer buffer = new StringBuffer(length);
        int index = 0;
        int copyIndex = 0;
        boolean ok = true;
        while (ok) {
            int first = pattern.indexOf(123, index);
            if (first == -1) {
                ok = false;
                continue;
            }
            int last = pattern.indexOf(125, first);
            if (last == -1) {
                ok = false;
                continue;
            }
            index = first + 1;
            if (last >= first + 3) continue;
            try {
                char number = patternChar[first + 1];
                int value = Character.digit(number, 16);
                buffer.append(patternChar, copyIndex, first - copyIndex);
                Nls.formatData(buffer, objects[value]);
                copyIndex = last + 1;
            }
            catch (Exception exception) {
                EscObject.handleStaticException(exception);
            }
        }
        buffer.append(patternChar, copyIndex, patternChar.length - copyIndex);
        return buffer.toString();
    }

    public static String formatAsciiBytes(byte[] bytes, int index, int length) {
        StringBuffer buffer = new StringBuffer(length * 5);
        Nls.formatAsciiBytes(bytes, index, length, buffer);
        return buffer.toString();
    }

    public static void formatAsciiBytes(byte[] bytes, int index, int length, StringBuffer buffer) {
        buffer.append('\"');
        int i = 0;
        while (i < length) {
            char character = (char)bytes[i + index];
            if (character < '\u0010') {
                if (character == '\r') {
                    buffer.append(CR);
                } else if (character == '\n') {
                    buffer.append(LF);
                } else if (character == '\t') {
                    buffer.append(TAB);
                } else {
                    buffer.append('\\');
                    if (character > '\t') {
                        buffer.append('1');
                        buffer.append(HEX_CHAR_LOWER_TABLE[character % 10]);
                    } else {
                        buffer.append(HEX_CHAR_LOWER_TABLE[character]);
                    }
                }
            } else {
                buffer.append(character);
            }
            ++i;
        }
        buffer.append('\"');
    }

    public static void formatData(StringBuffer buffer, Object data) {
        if (data instanceof Object[]) {
            buffer.append("[]{");
            int i = 0;
            while (i < ((Object[])data).length) {
                if (i != 0) {
                    buffer.append(' ');
                }
                Nls.formatData(buffer, ((Object[])data)[i]);
                ++i;
            }
            buffer.append('}');
        } else if (data instanceof byte[]) {
            buffer.append('[');
            int i = 0;
            while (i < ((byte[])data).length) {
                int dataByte;
                int upperByte;
                if (i != 0) {
                    buffer.append(' ');
                }
                if ((upperByte = (dataByte = ((byte[])data)[i] & 0xFF) >> 4) > 0) {
                    buffer.append(HEX_CHAR_LOWER_TABLE[upperByte]);
                }
                buffer.append(HEX_CHAR_LOWER_TABLE[dataByte & 0xF]);
                ++i;
            }
            buffer.append(']');
        } else if (data instanceof Map) {
            buffer.append('{');
            boolean first = true;
            Map map = (Map)data;
            int size = map.size();
            if (size > 0) {
                Set set = map.keySet();
                Object[] keys = new Object[size];
                keys = set.toArray(keys);
                Arrays.sort(keys);
                int i = 0;
                while (i < size) {
                    if (!first) {
                        buffer.append(',');
                    } else {
                        first = false;
                    }
                    Nls.formatData(buffer, keys[i]);
                    buffer.append('=');
                    Nls.formatData(buffer, map.get(keys[i]));
                    ++i;
                }
            }
            buffer.append('}');
        } else if (data instanceof Dictionary) {
            buffer.append('{');
            boolean first = true;
            Dictionary map = (Dictionary)data;
            int size = map.size();
            if (size > 0) {
                Enumeration enumeration = map.keys();
                while (enumeration.hasMoreElements()) {
                    String key = String.valueOf(enumeration.nextElement());
                    if (!first) {
                        buffer.append(',');
                    } else {
                        first = false;
                    }
                    Nls.formatData(buffer, key);
                    buffer.append('=');
                    Nls.formatData(buffer, map.get(key));
                }
            }
            buffer.append('}');
        } else {
            buffer.append(data);
        }
    }

    public static String formatHexBytes(byte[] bytes, int index, int length) {
        StringBuffer buffer = new StringBuffer(length << 3);
        Nls.formatHexBytes(bytes, index, length, buffer);
        return buffer.toString();
    }

    public static void formatHexBytes(byte[] bytes, int index, int length, StringBuffer buffer) {
        int saveLength = buffer.length();
        buffer.append('{');
        int charCount = 0;
        int i = 0;
        while (i < length) {
            int data;
            int upperByte;
            if (i != 0) {
                buffer.append(',');
            }
            if ((upperByte = (data = bytes[i + index] & 0xFF) >> 4) > 0) {
                buffer.append(HEX_CHAR_LOWER_TABLE[upperByte]);
                if (data >= 32 && data <= 127) {
                    ++charCount;
                }
            } else if (data == 13 || data == 10 || data == 9) {
                ++charCount;
            }
            buffer.append(HEX_CHAR_LOWER_TABLE[data & 0xF]);
            ++i;
        }
        buffer.append('}');
        if (charCount > 0) {
            if (charCount == length) {
                buffer.setLength(saveLength);
            } else {
                buffer.append('=');
            }
            buffer.append('\"');
            String data = new String(bytes, index, length);
            int dataLength = data.length();
            int i2 = 0;
            while (i2 < dataLength) {
                char character = data.charAt(i2);
                if (character < '\u0010') {
                    if (character == '\r') {
                        buffer.append(CR);
                    } else if (character == '\n') {
                        buffer.append(LF);
                    } else if (character == '\t') {
                        buffer.append(TAB);
                    } else {
                        buffer.append('\\');
                        if (character > '\t') {
                            buffer.append('1');
                            buffer.append(HEX_CHAR_LOWER_TABLE[character % 10]);
                        } else {
                            buffer.append(HEX_CHAR_LOWER_TABLE[character]);
                        }
                    }
                } else {
                    buffer.append(character);
                }
                ++i2;
            }
            buffer.append('\"');
        }
    }

    public static String formatTimestamp(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        StringBuffer buffer = new StringBuffer(48);
        int year = calendar.get(1);
        buffer.append(year);
        buffer.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        int day = calendar.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        buffer.append(' ');
        int hour = calendar.get(11);
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        buffer.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        buffer.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buffer.append('0');
        }
        buffer.append(second);
        buffer.append('.');
        int millisecond = calendar.get(14);
        if (millisecond < 100) {
            buffer.append('0');
        }
        if (millisecond < 10) {
            buffer.append('0');
        }
        buffer.append(millisecond);
        return buffer.toString();
    }

    public static String formatTimestamp(Object timestampObject) {
        if (timestampObject instanceof Number) {
            return Nls.formatTimestamp(((Number)timestampObject).longValue());
        }
        return "null";
    }

    public static String getName(Class aclass, String name, String extension) {
        int length = name.length() + extension.length() + PROPERTY_EXTENSION_LENGTH;
        String[] myadditions = Nls.getNlsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            URL url = aclass.getResource(buffer.toString());
            if (url != null) {
                return String.valueOf(name) + myadditions[i];
            }
            ++i;
        }
        return name;
    }

    public static String[] getNlsAdditions() {
        return NLS_ADDITIONS;
    }

    public static Hashtable getProperties(Class aclass, String name) {
        Properties table = null;
        String[] myadditions = Nls.getNlsAdditions();
        int nlength = name.length();
        int length = nlength + PROPERTY_EXTENSION_LENGTH + 6;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(name);
        int i = 0;
        while (i < myadditions.length) {
            buffer.append(myadditions[i]);
            buffer.append(PROPERTY_EXTENSION);
            InputStream ris = aclass.getResourceAsStream(buffer.toString());
            if (ris != null) {
                BufferedInputStream is = new BufferedInputStream(ris);
                try {
                    table = new Properties();
                    table.load(is);
                    is.close();
                    return table;
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            buffer.setLength(nlength);
            ++i;
        }
        return table;
    }

    public static ResourceBundle getResourceBundle(String name) {
        return ResourceBundle.getBundle(name);
    }

    public static ResourceBundle getResourceBundle(Class resourceBaseClass) {
        String name = resourceBaseClass.getName();
        String[] myadditions = Nls.getNlsAdditions();
        int nlength = name.length();
        int length = nlength + 6;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(name);
        ClassLoader classLoader = resourceBaseClass.getClassLoader();
        if (classLoader != null) {
            int i = 0;
            while (i < myadditions.length) {
                buffer.append(myadditions[i]);
                try {
                    Class<?> resourceBundle = classLoader.loadClass(buffer.toString());
                    if (resourceBundle != null) {
                        return (ResourceBundle)resourceBundle.newInstance();
                    }
                }
                catch (Exception exception) {}
                buffer.setLength(nlength);
                ++i;
            }
        }
        return ResourceBundle.getBundle(name);
    }

    public static URL getUrl(Class aclass, String name, String extension) {
        int length = name.length() + extension.length() + PROPERTY_EXTENSION_LENGTH;
        URL url = null;
        String[] myadditions = Nls.getNlsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            url = aclass.getResource(buffer.toString());
            if (url != null) {
                return url;
            }
            ++i;
        }
        return url;
    }
}

