/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.soda.dk.core.EscObject;

public class Os {
    private static final String PROPERTY_EXTENSION = ".properties";
    private static final int PROPERTY_EXTENSION_LENGTH = ".properties".length();
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_LINUX = OS_NAME.startsWith("linux");
    private static final boolean IS_NEUTRINO = OS_NAME.startsWith("neutrino") || OS_NAME.startsWith("nto") || OS_NAME.startsWith("qnx");
    private static final boolean IS_WINDOWS_CE = OS_NAME.startsWith("win") && OS_NAME.endsWith("CE");
    private static final boolean IS_WINDOWS = OS_NAME.startsWith("win");
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String[] NLS_ADDITIONS = Os.computeOsAdditions();

    private static String[] computeOsAdditions() {
        Vector<String> list = new Vector<String>(3);
        list.addElement("");
        StringBuffer buffer = new StringBuffer();
        String[] possible = new String[]{"windows", OS_ARCH};
        if (Os.isNeutrino()) {
            possible[0] = "qnx";
        } else if (Os.isLinux()) {
            possible[0] = "linux";
        } else if (Os.isWindowsCe()) {
            possible[0] = "windowsce";
        }
        int i = 0;
        while (i < possible.length) {
            if (possible[i] != null && possible[i].length() > 0) {
                buffer.append('_');
                buffer.append(possible[i]);
                list.addElement(buffer.toString());
            }
            ++i;
        }
        String[] results = new String[list.size()];
        int max = results.length - 1;
        int i2 = 0;
        while (i2 < results.length) {
            results[i2] = String.valueOf(list.elementAt(max - i2));
            ++i2;
        }
        return results;
    }

    public static String getName(Class aclass, String name, String extension) {
        int length = name.length() + extension.length() + PROPERTY_EXTENSION_LENGTH;
        String[] myadditions = Os.getOsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            URL url = aclass.getResource(buffer.toString());
            if (url != null) {
                return String.valueOf(name) + myadditions[i];
            }
            ++i;
        }
        return name;
    }

    public static String[] getOsAdditions() {
        return NLS_ADDITIONS;
    }

    public static String getOsArch() {
        return OS_ARCH;
    }

    public static String getOsName() {
        return OS_NAME;
    }

    public static Hashtable getProperties(Class aclass, String name) {
        String[] myadditions = Os.getOsAdditions();
        int length = name.length() + PROPERTY_EXTENSION.length() + PROPERTY_EXTENSION_LENGTH;
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(PROPERTY_EXTENSION);
            InputStream ris = aclass.getResourceAsStream(buffer.toString());
            if (ris != null) {
                try {
                    BufferedInputStream is = new BufferedInputStream(ris);
                    Properties table = new Properties();
                    table.load(is);
                    is.close();
                    return table;
                }
                catch (Exception exception) {
                    EscObject.handleStaticException(exception);
                }
            }
            ++i;
        }
        return null;
    }

    public static URL getUrl(Class aclass, String name, String extension) {
        int length = name.length();
        length += extension.length();
        length += PROPERTY_EXTENSION_LENGTH;
        URL url = null;
        String[] myadditions = Os.getOsAdditions();
        int i = 0;
        while (i < myadditions.length) {
            StringBuffer buffer = new StringBuffer(length);
            buffer.append(name);
            buffer.append(myadditions[i]);
            buffer.append(extension);
            url = aclass.getResource(buffer.toString());
            if (url != null) {
                return url;
            }
            ++i;
        }
        return url;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isNeutrino() {
        return IS_NEUTRINO;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isWindowsCe() {
        return IS_WINDOWS_CE;
    }
}

