/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameter;
import org.eclipse.soda.dk.transform.service.TransformService;

public class OffsetParameter
extends Parameter {
    public static final int[] MASKS;
    private int offset;
    private int length;

    static {
        int[] nArray = new int[9];
        nArray[0] = 255;
        nArray[1] = 127;
        nArray[2] = 63;
        nArray[3] = 31;
        nArray[4] = 15;
        nArray[5] = 7;
        nArray[6] = 3;
        nArray[7] = 1;
        MASKS = nArray;
    }

    public OffsetParameter(String key, int offset, int length) {
        this(key, null, offset, length, OffsetParameter.getDefaultStyle());
    }

    public OffsetParameter(String key, int offset, int length, short style) {
        this(key, null, offset, length, style);
    }

    public OffsetParameter(String key, TransformService transform, int offset, int length, short style) {
        super(key, transform, style);
        this.setOffset(offset);
        this.setLength(length);
    }

    public Object decodeBytes(byte[] container) {
        int returnValue = 0;
        if (this.isLittleEndian()) {
            returnValue = container[this.getIndex() + this.getSize() - 1] & this.getMask();
            int i = this.getSize() - 2;
            while (i >= 0) {
                returnValue <<= 8;
                returnValue += container[this.getIndex() + i] & 0xFF;
                --i;
            }
        } else {
            return OffsetParameter.createNumber(OffsetParameter.getLong(container, this.getOffset(), this.getLength()));
        }
        return OffsetParameter.createNumber(returnValue);
    }

    protected Object decodeMessage(MessageService message) {
        return this.decodeBytes(message.getBytes());
    }

    public Object encodeBytes(byte[] container, Object data) {
        if (data instanceof Number) {
            int startOffset = this.getOffset() % 8;
            int endOffset = startOffset + this.length;
            int tempValue = ((Number)data).intValue();
            if (endOffset <= 8) {
                int temp = container[this.getIndex()];
                int shift = 8 - endOffset;
                tempValue &= MASKS[8 - this.length];
                if (shift > 0) {
                    tempValue <<= shift;
                }
                int mask = MASKS[8 - shift];
                container[this.getIndex()] = (byte)(tempValue |= (temp &= (mask |= ~MASKS[startOffset])));
            } else if (this.isLittleEndian()) {
                int i = 0;
                while (i < this.getSize()) {
                    container[this.getIndex() + i] = (byte)tempValue;
                    tempValue >>= 8;
                    ++i;
                }
            } else {
                OffsetParameter.setBits(container, this.getOffset(), this.getLength(), ((Number)data).longValue());
            }
        }
        return container;
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset) {
        byte[] bytes = (byte[])this.encodeBytes(message.getBytes(), value);
        message.setBytes(bytes);
        return message;
    }

    public byte[] getBytesValue(Object value, int length) {
        byte[] bytes;
        int size = length + 7 >> 3;
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String && (bytes = ((String)value).getBytes()).length == size) {
            return bytes;
        }
        bytes = new byte[size];
        if (value instanceof Number) {
            Number number = (Number)value;
            switch (size) {
                case 1: {
                    bytes[0] = number.byteValue();
                    break;
                }
                case 2: {
                    short numValue = number.shortValue();
                    bytes[0] = (byte)(numValue >> 8);
                    bytes[1] = (byte)(numValue & 0xFF);
                    break;
                }
            }
        }
        return bytes;
    }

    protected int getIndex() {
        return this.getOffset() >> 3;
    }

    protected int getLength() {
        return this.length;
    }

    protected int getMask() {
        if (this.isUnsigned()) {
            return 255;
        }
        return -1;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected int getSize() {
        return this.getLength() + 7 >> 3;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }
}

