/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.data.parameter.service.DataParameterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class Parameters
implements ParameterService,
DataParameterService {
    private String key;
    protected ParameterService[] parameters;

    public Parameters(String key, ParameterService[] parameters) {
        this.setKey(key);
        this.parameters = parameters;
    }

    public Object decode(Object container) {
        int length = this.parameters.length;
        Object[] result = new Object[length];
        int index = 0;
        while (index < length) {
            result[index] = this.parameters[index].decode(container);
            ++index;
        }
        return result;
    }

    public Object decodeValue(MessageService message) {
        int length = this.parameters.length;
        Object[] result = new Object[length];
        int index = 0;
        while (index < length) {
            result[index] = this.parameters[index].decodeValue(message);
            ++index;
        }
        return result;
    }

    public Object encode(Object container, Object data) {
        int length = this.parameters.length;
        Object result = container;
        if (data instanceof Object[]) {
            Object[] values = (Object[])data;
            int index = length - 1;
            while (index >= 0) {
                result = this.parameters[index].encode(result, values[index]);
                --index;
            }
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value) {
        int length = this.parameters.length;
        MessageService resultMessage = message;
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int index = length - 1;
            while (index >= 0) {
                resultMessage = this.parameters[index].encodeValue(resultMessage, values[index]);
                --index;
            }
        }
        return resultMessage;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getKey() {
        return this.key;
    }

    public ParameterService[] getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setKey(String key) {
        this.key = key;
    }
}

