/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.transform.service.TransformService;

public class SimpleIntegerParameter
extends SimpleParameter {
    public SimpleIntegerParameter(String key, TransformService transform, int index, int size, short style) {
        super(key, transform, index, size, style);
    }

    public SimpleIntegerParameter(String key, TransformService transform, int index, int size) {
        super(key, transform, index, size);
    }

    public Object decodeMessage(MessageService message) {
        if (this.getSize() <= 4) {
            int returnValue = 0;
            if (this.isLittleEndian()) {
                returnValue = message.getByte(this.getIndex() + this.getSize() - 1) & this.getMask();
                int i = this.getSize() - 2;
                while (i >= 0) {
                    returnValue <<= 8;
                    returnValue += message.getByte(this.getIndex() + i) & 0xFF;
                    --i;
                }
            } else {
                returnValue = message.getByte(this.getIndex()) & this.getMask();
                int i = 1;
                while (i < this.getSize()) {
                    returnValue <<= 8;
                    returnValue += message.getByte(this.getIndex() + i) & 0xFF;
                    ++i;
                }
            }
            return EscObject.createInteger(returnValue);
        }
        long returnValue = 0L;
        if (this.isLittleEndian()) {
            returnValue = message.getByte(this.getIndex() + this.getSize() - 1) & this.getMask();
            int i = this.getSize() - 2;
            while (i >= 0) {
                returnValue <<= 8;
                returnValue += (long)(message.getByte(this.getIndex() + i) & 0xFF);
                --i;
            }
        } else {
            returnValue = message.getByte(this.getIndex()) & this.getMask();
            int i = 1;
            while (i < this.getSize()) {
                returnValue <<= 8;
                returnValue += (long)(message.getByte(this.getIndex() + i) & 0xFF);
                ++i;
            }
        }
        return new Long(returnValue);
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset) {
        block4: {
            if (!(value instanceof Number)) break block4;
            long tempValue = ((Number)value).longValue();
            if (this.isLittleEndian()) {
                int i = 0;
                while (i < this.getSize()) {
                    message.setByte(this.getIndex() + i, (byte)tempValue);
                    tempValue >>= 8;
                    ++i;
                }
            } else {
                int i = this.getSize() - 1;
                while (i >= 0) {
                    message.setByte(this.getIndex() + i, (byte)tempValue);
                    tempValue >>= 8;
                    --i;
                }
            }
        }
        return message;
    }
}

