/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform;

import org.eclipse.soda.dk.data.Numeric;
import org.eclipse.soda.dk.transform.Transform;
import org.eclipse.soda.dk.transform.service.TransformService;

public class IntegerTranslateTransform
extends Transform
implements TransformService {
    private Number translate;

    public IntegerTranslateTransform(int translate) {
        this.translate = IntegerTranslateTransform.createInteger(translate);
    }

    public Object decode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).add(this.translate);
        }
        return this.translate(value, this.translate.intValue());
    }

    public Object encode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).subtract(this.translate);
        }
        return this.translate(value, -this.translate.intValue());
    }

    public Number translate(Object value, int value2) throws ClassCastException {
        if (value instanceof Integer) {
            return IntegerTranslateTransform.createInteger(((Number)value).intValue() + value2);
        }
        if (value instanceof Long) {
            return new Long(((Number)value).longValue() + (long)value2);
        }
        if (value instanceof Double) {
            return new Double((Double)value + (double)value2);
        }
        if (value instanceof Float) {
            return new Float(((Float)value).floatValue() + (float)value2);
        }
        return new Integer(((Number)value).intValue() + value2);
    }
}

