/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gps.nmea.device;

import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.gps.nmea.device.messages.GpsNmeaDeviceMessages;
import org.eclipse.soda.dk.gps.nmea.device.service.GpsNmeaDeviceService;
import org.eclipse.soda.dk.gps.nmea.transport.service.GpsNmeaTransportService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.SignalMeasurement;
import org.eclipse.soda.dk.message.Messages;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.FieldParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.ParameterSignal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class GpsNmeaDevice
extends TransportDevice
implements DeviceService,
GpsNmeaDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.device.GpsNmeaDevice";
    private final InterestService interest = new InterestMask(new byte[]{36, 71, 80, 66, 68, 64}, new byte[]{-1, -1, -1, -30, -28, -16});
    private final DataSignal gPGLL = new DataSignal("GPGLL", GpsNmeaDeviceMessages.getGPGLLMessage());
    private final DataSignal gPRMC = new DataSignal("GPRMC", GpsNmeaDeviceMessages.getGPRMCMessage());
    private final DataSignal gPGGA = new DataSignal("GPGGA", GpsNmeaDeviceMessages.getGPGGAMessage());
    private final DataSignal gPVTG = new DataSignal("GPVTG", GpsNmeaDeviceMessages.getGPVTGMessage());
    private final DataSignal gPZDA = new DataSignal("GPZDA", GpsNmeaDeviceMessages.getGPZDAMessage());
    private final ParameterSignal timeReport = new ParameterSignal("TimeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage()}), null, (ParameterService)new FieldParameter("Time", null, "Time", 96));
    private final SignalMeasurement time = new SignalMeasurement("Time", null, null, null, (SignalService)this.timeReport);
    private final ParameterSignal statusReport = new ParameterSignal("StatusReport", GpsNmeaDeviceMessages.getGPRMCMessage(), null, (ParameterService)new FieldParameter("Status", null, "Status", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement status = new SignalMeasurement("Status", null, null, null, (SignalService)this.statusReport);
    private final ParameterSignal latitudeReport = new ParameterSignal("LatitudeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Latitude", null, "Latitude", FieldParameter.getDefaultStyle()));
    private final ParameterSignal positionReport = new ParameterSignal("PositionReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Position", null, "Position", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement position = new SignalMeasurement("Position", null, null, null, (SignalService)this.positionReport);
    private final SignalMeasurement latitude = new SignalMeasurement("Latitude", null, null, null, (SignalService)this.latitudeReport);
    private final ParameterSignal longitudeReport = new ParameterSignal("LongitudeReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPGGAMessage(), GpsNmeaDeviceMessages.getGPGLLMessage()}), null, (ParameterService)new FieldParameter("Longitude", null, "Longitude", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement longitude = new SignalMeasurement("Longitude", null, null, null, (SignalService)this.longitudeReport);
    private final ParameterSignal speedKnotsReport = new ParameterSignal("SpeedKnotsReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPVTGMessage()}), null, (ParameterService)new FieldParameter("SpeedKnots", null, "SpeedKnots", 96));
    private final SignalMeasurement speedKnots = new SignalMeasurement("SpeedKnots", null, null, null, (SignalService)this.speedKnotsReport);
    private final ParameterSignal speedKPHReport = new ParameterSignal("SpeedKPHReport", GpsNmeaDeviceMessages.getGPVTGMessage(), null, (ParameterService)new FieldParameter("SpeedKPH", null, "SpeedKPH", 96));
    private final SignalMeasurement speedKPH = new SignalMeasurement("SpeedKPH", null, null, null, (SignalService)this.speedKPHReport);
    private final ParameterSignal trackReport = new ParameterSignal("TrackReport", (MessageService)new Messages(new MessageService[]{GpsNmeaDeviceMessages.getGPRMCMessage(), GpsNmeaDeviceMessages.getGPVTGMessage()}), null, (ParameterService)new FieldParameter("Track", null, "Track", 96));
    private final SignalMeasurement track = new SignalMeasurement("Track", null, null, null, (SignalService)this.trackReport);
    private final ParameterSignal trackMagneticReport = new ParameterSignal("TrackMagneticReport", GpsNmeaDeviceMessages.getGPVTGMessage(), null, (ParameterService)new FieldParameter("TrackMagnetic", null, "TrackMagnetic", 96));
    private final SignalMeasurement trackMagnetic = new SignalMeasurement("TrackMagnetic", null, null, null, (SignalService)this.trackMagneticReport);
    private final ParameterSignal altitudeReport = new ParameterSignal("AltitudeReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("Altitude", null, "Altitude", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement altitude = new SignalMeasurement("Altitude", null, null, null, (SignalService)this.altitudeReport);
    private final ParameterSignal qualityReport = new ParameterSignal("QualityReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("Quality", null, "Quality", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement quality = new SignalMeasurement("Quality", null, null, null, (SignalService)this.qualityReport);
    private final ParameterSignal numberSatellitesReport = new ParameterSignal("NumberSatellitesReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("NumberSatellites", null, "NumberSatellites", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement numberSatellites = new SignalMeasurement("NumberSatellites", null, null, null, (SignalService)this.numberSatellitesReport);
    private final ParameterSignal dateReport = new ParameterSignal("DateReport", GpsNmeaDeviceMessages.getGPRMCMessage(), null, (ParameterService)new FieldParameter("Date", null, "Date", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement date = new SignalMeasurement("Date", null, null, null, (SignalService)this.dateReport);
    private final ParameterSignal horizontalDilutionOfPrecisionReport = new ParameterSignal("HorizontalDilutionOfPrecisionReport", GpsNmeaDeviceMessages.getGPGGAMessage(), null, (ParameterService)new FieldParameter("HorizontalDilutionOfPrecision", null, "HorizontalDilutionOfPrecision", FieldParameter.getDefaultStyle()));
    private final SignalMeasurement horizontalDilutionOfPrecision = new SignalMeasurement("HorizontalDilutionOfPrecision", null, null, null, (SignalService)this.horizontalDilutionOfPrecisionReport);

    public GpsNmeaDevice() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public InterestService getInterest() {
        return this.interest;
    }

    public String getDefaultKey() {
        return "GpsNmeaDevice";
    }

    public TransportService getDefaultTransport() {
        return (GpsNmeaTransportService)GpsNmeaDevice.loadService((String)TransportService.SERVICE_NAME, (String)"org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport");
    }

    public int getControlCapacity() {
        return 47;
    }

    public int getMessageCapacity() {
        return 41;
    }

    public Object getMessageKey(MessageService message) {
        byte[] bytes = message.getBytes();
        if (bytes.length >= 6 && (bytes[5] & 0xF0) == 64 && (bytes[4] & 0xE4) == 68 && (bytes[3] & 0xE2) == 66 && bytes[2] == 80 && bytes[1] == 71 && bytes[0] == 36) {
            return new Integer(bytes[3] & 0x1D ^ (bytes[4] & 0x1B) << 5 ^ (bytes[5] & 0xF) << 10);
        }
        return null;
    }

    private void initialize() {
        this.put((ControlService)this.gPGLL);
        this.put((ControlService)this.gPRMC);
        this.put((ControlService)this.gPGGA);
        this.put((ControlService)this.gPVTG);
        this.put((ControlService)this.gPZDA);
        this.put((ControlService)this.timeReport);
        this.put((ControlService)this.time);
        this.put((ControlService)this.statusReport);
        this.put((ControlService)this.status);
        this.put((ControlService)this.latitudeReport);
        this.put((ControlService)this.positionReport);
        this.put((ControlService)this.position);
        this.put((ControlService)this.latitude);
        this.put((ControlService)this.longitudeReport);
        this.put((ControlService)this.longitude);
        this.put((ControlService)this.speedKnotsReport);
        this.put((ControlService)this.speedKnots);
        this.put((ControlService)this.speedKPHReport);
        this.put((ControlService)this.speedKPH);
        this.put((ControlService)this.trackReport);
        this.put((ControlService)this.track);
        this.put((ControlService)this.trackMagneticReport);
        this.put((ControlService)this.trackMagnetic);
        this.put((ControlService)this.altitudeReport);
        this.put((ControlService)this.altitude);
        this.put((ControlService)this.qualityReport);
        this.put((ControlService)this.quality);
        this.put((ControlService)this.numberSatellitesReport);
        this.put((ControlService)this.numberSatellites);
        this.put((ControlService)this.dateReport);
        this.put((ControlService)this.date);
        this.put((ControlService)this.horizontalDilutionOfPrecisionReport);
        this.put((ControlService)this.horizontalDilutionOfPrecision);
    }
}

