/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.transport.test.TransportTestResourceBundle;
import org.eclipse.soda.dk.transport.test.service.TransportTestService;

public class TransportTest
extends EscObject
implements Runnable,
TransportListener,
TransportTestService {
    public static final String CLASS_NAME;
    public static final int DEFAULT_PRIORITY = 3;
    public static final int DEFAULT_TEST_COUNT = 2;
    public static final long DEFAULT_TEST_DELAY = 0L;
    public static final long DEFAULT_TOTAL_TEST_TIME = 60000L;
    protected static final int TRANSPORT_TEST_DEAD_STATE_RESOURCE = 2500;
    protected static final int TRANSPORT_TEST_CREATED_STATE_RESOURCE = 2501;
    protected static final int TRANSPORT_TEST_ALIVE_STATE_RESOURCE = 2502;
    protected static final int TRANSPORT_TEST_CONNECTED_STATE_RESOURCE = 2503;
    protected static final int TRANSPORT_TEST_ACTIVE_STATE_RESOURCE = 2504;
    protected static final int TRANSPORT_TEST_STARTED_STATE_RESOURCE = 2505;
    protected static final int[] TRANSPORT_TEST_STATE_RESOURCE_TABLE;
    protected static final int TRANSPORT_TEST_ERROR_NOTIFICATION_RESOURCE = 2506;
    protected static final int TRANSPORT_TEST_MESSAGE_NOTIFICATION_RESOURCE = 2507;
    protected static final int TRANSPORT_TEST_START_RESOURCE = 2508;
    protected static final int TRANSPORT_TEST_STOP_RESOURCE = 2509;
    protected static final int TRANSPORT_TEST_WAITING_RESOURCE = 2510;
    protected static final int TRANSPORT_TEST_SEND_EXCEPTION_RESOURCE = 2511;
    protected static final int TRANSPORT_TEST_START_EXECUTION_RESOURCE = 2512;
    protected static final int TRANSPORT_TEST_STOP_EXECUTION_RESOURCE = 2513;
    protected static final int TRANSPORT_TEST_EXIT_EXECUTION_RESOURCE = 2514;
    protected static final int TRANSPORT_TEST_TRANSPORT_CONFIGURATION_MISCOMPARE_RESOURCE = 2515;
    private static ResourceBundle DefaultResourceBundle;
    private boolean started = false;
    private int testCount = TransportTest.getStaticInt((String)"transporttest.testcount", (int)1);
    private long testDelay = this.getLong("transporttest.testdelay", 0L);
    private long totalTestTime = this.getLong("transporttest.totaltesttime", 0L);
    private int priority = TransportTest.getStaticInt((String)"transporttest.priority", (int)3);
    private Thread thread = null;
    private TransportService transport = null;
    private NotificationService notificationService;
    private ConfigurationService configurationService = null;
    private Dictionary transportConfigurationInformation = null;
    private final long startTime = System.currentTimeMillis();
    private final Object stateChanged = new Object();
    protected boolean configurationSave = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transport.test.TransportTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        TRANSPORT_TEST_STATE_RESOURCE_TABLE = new int[]{2500, 2501, 2502, 2503, 2504, 2505};
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.soda.dk.transport.test.TransportTestResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz2);
    }

    public void endTests() {
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.report(null, 2506, data);
    }

    public void exit() {
        this.stop();
        this.setTransport(null);
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        if (this.configurationService == null) {
            return null;
        }
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public String getCopyright() {
        return "# (C) Copyright {0} Corp. {1} All Rights Reserved\r\n";
    }

    public TransportService getDefaultTransport() {
        return null;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 2506: 
            case 2511: 
            case 2515: {
                return 2;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public Object getLogDetails4() {
        TransportService transport = this.getTransport();
        ConnectionService connection = null;
        if (transport instanceof ConnectionTransportService) {
            connection = ((ConnectionTransportService)transport).getConnection();
        }
        return String.valueOf(connection);
    }

    public Object getLogDetails5() {
        return String.valueOf(this.getTransport());
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(TransportTestResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public long getTestDelay() {
        return this.testDelay;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getTotalTestTime() {
        return this.totalTestTime;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public Dictionary getTransportConfigurationInformation() {
        return this.transportConfigurationInformation;
    }

    public String getVendor() {
        return "IBM";
    }

    public boolean isConfigurationSave() {
        return this.configurationSave;
    }

    public boolean isStarted() {
        TransportService transport = this.getTransport();
        return this.started && transport != null && transport.getState() >= 5;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.report(null, 2507, message);
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long startTime = System.currentTimeMillis();
        long waitTime = 1000L;
        while (!this.isStarted() && this.getTransport() != null) {
            try {
                long currentTime = System.currentTimeMillis();
                Long time = new Long(currentTime - startTime);
                this.report(null, 2510, time);
                Object object = this.stateChanged;
                synchronized (object) {
                    this.stateChanged.wait(waitTime);
                    if ((waitTime <<= 1) > this.getTotalTestTime()) {
                        waitTime = this.getTotalTestTime();
                    }
                }
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
        int testCount = this.getTestCount();
        this.report(null, 2512, null);
        this.startTests();
        int i = 0;
        while (i < testCount) {
            this.runTests();
            ++i;
        }
        this.endTests();
        long end = System.currentTimeMillis();
        this.transportConfigurationCompare();
        this.report(null, 2513, new Long(end - this.startTime));
    }

    public void run(String[] args) {
        System.gc();
        System.gc();
        long timeStart = System.currentTimeMillis();
        long freeMemoryStart = Runtime.getRuntime().freeMemory();
        TransportService transport = this.getDefaultTransport();
        this.setTransport(transport);
        this.start();
        transport.start();
        this.sleep(this.getTotalTestTime());
        long timeEnd = System.currentTimeMillis();
        System.gc();
        System.gc();
        long freeMemoryEnd = Runtime.getRuntime().freeMemory();
        this.stop();
        transport.exit();
        this.transportConfigurationSave();
        this.report(null, 2514, new Long(timeEnd - timeStart), new Long(freeMemoryStart - freeMemoryEnd));
    }

    public void runTests() {
    }

    public void send(MessageService message) {
        try {
            this.getTransport().send(message);
        }
        catch (Exception exception) {
            this.report(exception, 2511, message);
        }
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        this.configurationService = new EscConfiguration(configurationInformation);
    }

    public void setConfigurationSave(boolean configurationSave) {
        this.configurationSave = configurationSave;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setTestCount(int testCount) {
        this.testCount = testCount;
    }

    public void setTestDelay(long testDelay) {
        this.testDelay = testDelay;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setTotalTestTime(long totalTestTime) {
        this.totalTestTime = totalTestTime;
    }

    public void setTransport(TransportService transport) {
        if (this.transport != null) {
            this.transport.removeTransportListener((TransportListener)this);
        }
        this.transport = transport;
        if (this.transport != null) {
            this.transport.addTransportListener((TransportListener)this);
        }
    }

    public void setTransportConfigurationInformation(Dictionary transportConfigurationInformation) {
        this.transportConfigurationInformation = transportConfigurationInformation;
    }

    public void setup() {
        this.setPriority(this.getInt("transporttest.priority", 3));
        this.setTestDelay(this.getLong("transporttest.testdelay", 0L));
        this.setTestCount(this.getInt("transporttest.testcount", 2));
        this.setTotalTestTime(this.getLong("transporttest.totaltesttime", 60000L));
    }

    public void start() {
        this.setup();
        this.setStarted(true);
        if (this.getTransport() != null) {
            this.report(null, 2508, null);
            this.test();
        }
    }

    public void startTests() {
    }

    public void stop() {
        this.setStarted(false);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(2000L);
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setThread(null);
        }
        this.report(null, 2509, null);
    }

    public void test() {
        if (this.getThread() == null) {
            this.setThread(new Thread((Runnable)this, String.valueOf(this.getOutputName())));
            this.getThread().setPriority(this.getPriority());
            this.getThread().start();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        Dictionary configuration = this.getConfigurationInformation();
        if (configuration != null) {
            buffer.append(configuration);
        } else {
            buffer.append('{');
            buffer.append("testcount=");
            buffer.append(this.getTestCount());
            buffer.append(",testdelay=");
            buffer.append(this.getTestDelay());
            buffer.append(",totaltesttime=");
            buffer.append(this.getTotalTestTime());
            buffer.append('}');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        this.report(null, TRANSPORT_TEST_STATE_RESOURCE_TABLE[newState], Transport.STATE_STRINGS[oldState]);
        if (newState >= 5) {
            this.test();
            Object object = this.stateChanged;
            synchronized (object) {
                this.stateChanged.notifyAll();
            }
        }
    }

    public void transportConfigurationCompare() {
        Dictionary dictionary;
        TransportService transport = this.getTransport();
        if (transport != null && (dictionary = transport.getConfigurationInformation()) != null) {
            this.setTransportConfigurationInformation(dictionary);
            String className = this.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index > 0) {
                String simpleName = className.substring(index + 1, className.length());
                InputStream cis = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
                if (cis != null) {
                    Properties properties = new Properties();
                    try {
                        BufferedInputStream is = new BufferedInputStream(cis);
                        properties.load(is);
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        String key = String.valueOf(enumeration.nextElement());
                        if (key.equals("state") || key.toLowerCase().startsWith("serial")) continue;
                        Object configurationValue = properties.get(key);
                        Object value = dictionary.get(key);
                        if (configurationValue == null || value.equals(configurationValue) || value.toString().equals(configurationValue.toString())) continue;
                        this.report(null, 2515, key, configurationValue, value);
                    }
                }
            }
        }
    }

    public void transportConfigurationSave() {
        String className;
        int index;
        Dictionary dictionary = this.getTransportConfigurationInformation();
        if (dictionary != null && (index = (className = this.getClass().getName()).lastIndexOf(46)) > 0) {
            String simpleName = className.substring(index + 1, className.length());
            int size = dictionary.size();
            InputStream is = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
            if (is == null || this.isConfigurationSave()) {
                Object[] keys = new String[size];
                int i = 0;
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    keys[i++] = String.valueOf(key);
                }
                Arrays.sort(keys);
                StringBuffer buffer = new StringBuffer(1024);
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                buffer.append(Nls.format((String)this.getCopyright(), (Object[])new Object[]{this.getVendor(), new Integer(year)}));
                buffer.append("# Date: ");
                buffer.append(calendar.getTime());
                buffer.append('\r');
                buffer.append('\n');
                int j = 0;
                while (j < size) {
                    Object key = keys[j];
                    if (!((String)key).equals("state")) {
                        buffer.append((String)key);
                        buffer.append('=');
                        buffer.append(dictionary.get(key));
                        buffer.append('\r');
                        buffer.append('\n');
                    }
                    ++j;
                }
                try {
                    StringBuffer cbuffer = new StringBuffer(1024);
                    cbuffer.append("src");
                    cbuffer.append('/');
                    cbuffer.append(className.replace('.', '/'));
                    cbuffer.append(".properties");
                    File file = new File(cbuffer.toString());
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(buffer.toString().getBytes());
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

