/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.service.log.LogService;

public abstract class TransportBundle
extends BaseBundleActivator {
    private TransportService transport = null;

    protected void activate() {
        TransportService transport = this.createService(this.getDefaultConnection());
        this.setTransport(transport);
        if (transport != null) {
            Hashtable properties = this.createProperties();
            String[] names = this.getExportedServiceNames();
            this.addExportedServices(names, transport, properties);
            NotificationService notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService");
            if (notificationService != null) {
                this.transport.setNotificationService(notificationService);
            }
            transport.start();
        }
        super.activate();
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("id", "#");
        return properties;
    }

    public abstract TransportService createService(ConnectionService var1);

    protected void deactivate() {
        TransportService transport = this.getTransport();
        if (transport != null) {
            transport.exit();
            this.setTransport(null);
        }
    }

    public ConnectionService getDefaultConnection() {
        return null;
    }

    public abstract String[] getExportedServiceNames();

    public String getServiceName() {
        return TransportService.SERVICE_NAME;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }
}

