/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.sat.plugin.activator.ActivatorWizardModelListener;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.internal.ActivatorGenerator;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.activator.util.ITypeModel;

public class ActivatorWizardModel
implements IActivatorWizardModel {
    private static final short ALL_IMPORTED_SERVICE = 0;
    private static final short REQUIRED_IMPORTED_SERVICE = 1;
    private static final short OPTIONAL_IMPORTED_SERVICE = 2;
    private static final short FILTERED_IMPORTED_SERVICE = 3;
    private static final String OSGI_BUNDLE = "org.eclipse.osgi";
    private static final String OSGI_SERVICES_BUNDLE = "org.eclipse.osgi.services";
    private static final String SAT_CORE_BUNDLE = "org.eclipse.soda.sat.core";
    private ITypeModel typeModel;
    private String packageName;
    private String className;
    private String bundleSymbolicName;
    private String propertiesFilename;
    private Map bundleDependenciesMap;
    private List listeners;
    private Map exportedServiceDetailsMap;
    private Map importedServiceDetailsMap;
    private boolean customStartAndStop;
    private boolean startAsynchronously;
    private int loadPropertiesPolicy;
    private int startAsynchronouslyNormalPriorityDelta;
    private int uninstallPolicy;

    public ActivatorWizardModel(ITypeModel typeModel) {
        this.setTypeModel(typeModel);
        this.setListeners(new ArrayList(5));
        this.setBundleDependenciesMap(new HashMap(37));
        this.setExportedServiceDetailsMap(new HashMap(17));
        this.setImportedServiceDetailsMap(new HashMap(17));
        this.setCustomStartAndStop(false);
        this.setStartAsynchronously(false);
        this.setLoadPropertiesPolicy(0);
        this.setStartAsynchronouslyNormalPriorityDelta(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivatorWizardModelListener(ActivatorWizardModelListener listener) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            boolean exists = listeners.contains(listener);
            if (exists) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleDependency(String fullyQualifiedName, String bundleSymbolicName) {
        Map map;
        Map map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            boolean exists = map.containsKey(fullyQualifiedName);
            if (exists) {
                return;
            }
            map.put(fullyQualifiedName, bundleSymbolicName);
        }
        this.notifyListenersOfBundleDependenciesChange();
    }

    public void addExportedServiceDetails(IExportedServiceDetails details) {
        Map map = this.getExportedServiceDetailsMap();
        boolean added = this.addServiceDetails(map, details);
        if (!added) {
            return;
        }
        this.notifyListenersOfExportedServiceDetailsChange();
    }

    public void addImportedServiceDetails(IImportedServiceDetails details) {
        Map map = this.getImportedServiceDetailsMap();
        boolean added = this.addServiceDetails(map, details);
        if (!added) {
            return;
        }
        this.notifyListenersOfImportedServiceDetailsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addServiceDetails(Map map, IServiceDetails details) {
        String key = details.getName();
        Map map2 = map;
        synchronized (map2) {
            block4: {
                boolean exists = map.containsKey(key);
                if (!exists) break block4;
                return false;
            }
            map.put(key, details);
        }
        return true;
    }

    public boolean containsExportedService(String name) {
        Map map = this.getExportedServiceDetailsMap();
        boolean exists = map.containsKey(name);
        return exists;
    }

    public boolean containsImportedService(String name) {
        Map map = this.getImportedServiceDetailsMap();
        boolean exists = map.containsKey(name);
        return exists;
    }

    public String generate() {
        ITypeModel typeModel = this.getTypeModel();
        ActivatorGenerator generator = new ActivatorGenerator(this, typeModel);
        String value = generator.generate();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBundleDependencies() {
        Map map;
        Map map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            Collection values = map.values();
            HashSet set = new HashSet(values);
            int size = set.size() + 3;
            ArrayList<String> list = new ArrayList<String>(size);
            list.add(OSGI_BUNDLE);
            list.add(OSGI_SERVICES_BUNDLE);
            list.add(SAT_CORE_BUNDLE);
            list.addAll(set);
            return list;
        }
    }

    private Map getBundleDependenciesMap() {
        return this.bundleDependenciesMap;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() {
        ActivatorWizardModel activatorWizardModel = this;
        synchronized (activatorWizardModel) {
            if (this.className == null) {
                IActivatorWizardPreferences preferences = this.getPreferences();
                String className = preferences.getClassName();
                this.setClassName(className);
            }
        }
        return this.className;
    }

    public boolean getCustomStartAndStop() {
        return this.customStartAndStop;
    }

    private String getDefaultPropertiesFilename() {
        StringBuffer buffer = new StringBuffer(50);
        String bundleSymbolicName = this.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            buffer.append(bundleSymbolicName);
            buffer.append(".properties");
        }
        String filename = buffer.toString();
        return filename;
    }

    private Map getExportedServiceDetailsMap() {
        return this.exportedServiceDetailsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExportedServicesDetails() {
        Map map;
        Map map2 = map = this.getExportedServiceDetailsMap();
        synchronized (map2) {
            Collection values = map.values();
            ArrayList list = new ArrayList(values);
            Collections.sort(list);
            return list;
        }
    }

    public List getFilteredImportedServices() {
        return this.getImportedServices((short)3);
    }

    private Map getImportedServiceDetailsMap() {
        return this.importedServiceDetailsMap;
    }

    private List getImportedServices(short type) {
        Map map = this.getImportedServiceDetailsMap();
        Collection values = map.values();
        int size = values.size();
        ArrayList<String> list = new ArrayList<String>(size);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            IImportedServiceDetails details = (IImportedServiceDetails)iterator.next();
            boolean match = false;
            if (type == 0) {
                match = true;
            } else if (type == 1 && !details.isOptional()) {
                match = true;
            } else if (type == 2 && details.isOptional()) {
                match = true;
            } else if (type == 3 && details.isFiltered()) {
                match = true;
            }
            if (!match) continue;
            String name = details.getName();
            list.add(name);
        }
        list.trimToSize();
        Collections.sort(list);
        return list;
    }

    public List getImportedServicesDetails() {
        Map map = this.getImportedServiceDetailsMap();
        Collection values = map.values();
        ArrayList list = new ArrayList(values);
        Collections.sort(list);
        return list;
    }

    private List getListeners() {
        return this.listeners;
    }

    private Iterator getListenersIterator() {
        List listeners = this.getListeners();
        Iterator iterator = listeners.iterator();
        return iterator;
    }

    public int getLoadPropertiesPolicy() {
        return this.loadPropertiesPolicy;
    }

    public List getOptionalImportedServices() {
        return this.getImportedServices((short)2);
    }

    public String getPackageName() {
        return this.packageName;
    }

    private IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPropertiesFilename() {
        ActivatorWizardModel activatorWizardModel = this;
        synchronized (activatorWizardModel) {
            if (this.propertiesFilename == null) {
                String filename = this.getDefaultPropertiesFilename();
                this.setPropertiesFilename(filename);
            }
        }
        return this.propertiesFilename;
    }

    public List getRequiredImportedServices() {
        return this.getImportedServices((short)1);
    }

    public boolean getStartAsynchronously() {
        return this.startAsynchronously;
    }

    public int getStartAsynchronouslyNormalPriorityDelta() {
        return this.startAsynchronouslyNormalPriorityDelta;
    }

    private ITypeModel getTypeModel() {
        return this.typeModel;
    }

    public int getUninstallPolicy() {
        return this.uninstallPolicy;
    }

    public boolean hasExportedServices() {
        Map map = this.getExportedServiceDetailsMap();
        boolean result = !map.isEmpty();
        return result;
    }

    public boolean hasImportedServices() {
        Map map = this.getImportedServiceDetailsMap();
        boolean result = !map.isEmpty();
        return result;
    }

    public boolean isUsingDefaultPropertiesFilename() {
        String defaultPropertiesFilename = this.getDefaultPropertiesFilename();
        String propertiesFilename = this.getPropertiesFilename();
        boolean usingDefault = defaultPropertiesFilename.equals(propertiesFilename);
        return usingDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfBundleDependenciesChange() {
        List listeners = this.getListeners();
        List bundleDependencies = this.getBundleDependencies();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleBundleDependenciesChanged(bundleDependencies);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfBundleSymbolicNameChange() {
        List listeners = this.getListeners();
        String value = this.getBundleSymbolicName();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleBundleSymbolicNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfClassNameChange() {
        List listeners = this.getListeners();
        String value = this.getClassName();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleClassNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfCustomStartAndStopChange() {
        List listeners = this.getListeners();
        boolean state = this.getCustomStartAndStop();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleCustomStartAndStopChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExportedServiceDetailsChange() {
        List listeners = this.getListeners();
        boolean empty = listeners.isEmpty();
        if (empty) {
            return;
        }
        List details = this.getExportedServicesDetails();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleExportedServicesChanged(details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfImportedServiceDetailsChange() {
        List listeners = this.getListeners();
        boolean empty = listeners.isEmpty();
        if (empty) {
            return;
        }
        List details = this.getImportedServicesDetails();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleImportedServicesChanged(details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfLoadPropertiesPolicyChange() {
        List listeners = this.getListeners();
        int value = this.getLoadPropertiesPolicy();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleLoadPropertiesPolicyChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfPackageNameChange() {
        List listeners = this.getListeners();
        String value = this.getPackageName();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handlePackageNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfPropertiesFilenameChange() {
        List listeners = this.getListeners();
        String value = this.getPropertiesFilename();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handlePropertiesFilenameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfStartAsynchronouslyChange() {
        List listeners = this.getListeners();
        boolean state = this.getStartAsynchronously();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleStartAsynchronouslyChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfStartAsynchronouslyNormalPriorityDeltaChanged() {
        List listeners = this.getListeners();
        int value = this.getStartAsynchronouslyNormalPriorityDelta();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleStartAsynchronouslyNormalPriorityDeltaChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfUninstallPolicyChanged() {
        List listeners = this.getListeners();
        int value = this.getUninstallPolicy();
        List list = listeners;
        synchronized (list) {
            Iterator iterator = this.getListenersIterator();
            while (iterator.hasNext()) {
                ActivatorWizardModelListener listener = (ActivatorWizardModelListener)iterator.next();
                listener.handleUninstallPolicyChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivatorWizardModelListener(ActivatorWizardModelListener listener) {
        List listeners;
        List list = listeners = this.getListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleDependency(String fullyQualifiedName) {
        Map map;
        Map map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            boolean removed;
            Object value = map.remove(fullyQualifiedName);
            boolean bl = removed = value != null;
            if (!removed) {
                return;
            }
        }
        this.notifyListenersOfBundleDependenciesChange();
    }

    public void removeExportedServiceDetails(IExportedServiceDetails details) {
        Map map = this.getExportedServiceDetailsMap();
        this.removeServiceDetails(map, details);
        this.notifyListenersOfExportedServiceDetailsChange();
    }

    public void removeImportedServiceDetails(IImportedServiceDetails details) {
        Map map = this.getImportedServiceDetailsMap();
        this.removeServiceDetails(map, details);
        this.notifyListenersOfImportedServiceDetailsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServiceDetails(Map map, IServiceDetails details) {
        String key = details.getName();
        Map map2 = map;
        synchronized (map2) {
            map.remove(key);
        }
    }

    private void setBundleDependenciesMap(Map bundleDependenciesMap) {
        this.bundleDependenciesMap = bundleDependenciesMap;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        if (this.bundleSymbolicName != null && this.bundleSymbolicName.equals(bundleSymbolicName)) {
            return;
        }
        this.bundleSymbolicName = bundleSymbolicName;
        this.notifyListenersOfBundleSymbolicNameChange();
    }

    public void setClassName(String className) {
        if (this.className != null && this.className.equals(className)) {
            return;
        }
        this.className = className;
        this.notifyListenersOfClassNameChange();
    }

    public void setCustomStartAndStop(boolean customStartAndStop) {
        if (this.customStartAndStop == customStartAndStop) {
            return;
        }
        this.customStartAndStop = customStartAndStop;
        this.notifyListenersOfCustomStartAndStopChange();
    }

    private void setExportedServiceDetailsMap(Map exportedServiceDetailsMap) {
        this.exportedServiceDetailsMap = exportedServiceDetailsMap;
    }

    private void setImportedServiceDetailsMap(Map importedServiceDetailsMap) {
        this.importedServiceDetailsMap = importedServiceDetailsMap;
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void setLoadPropertiesPolicy(int loadPropertiesPolicy) {
        if (this.loadPropertiesPolicy == loadPropertiesPolicy) {
            return;
        }
        this.loadPropertiesPolicy = loadPropertiesPolicy;
        this.notifyListenersOfLoadPropertiesPolicyChange();
    }

    public void setPackageName(String packageName) {
        if (this.packageName != null && this.packageName.equals(packageName)) {
            return;
        }
        this.packageName = packageName;
        this.notifyListenersOfPackageNameChange();
    }

    public void setPropertiesFilename(String propertiesFilename) {
        if (this.propertiesFilename != null && this.propertiesFilename.equals(propertiesFilename)) {
            return;
        }
        this.propertiesFilename = propertiesFilename;
        this.notifyListenersOfPropertiesFilenameChange();
    }

    public void setStartAsynchronously(boolean startAsynchronously) {
        if (this.startAsynchronously == startAsynchronously) {
            return;
        }
        this.startAsynchronously = startAsynchronously;
        this.notifyListenersOfStartAsynchronouslyChange();
    }

    public void setStartAsynchronouslyNormalPriorityDelta(int startAsynchronouslyNormalPriorityDelta) {
        if (this.startAsynchronouslyNormalPriorityDelta == startAsynchronouslyNormalPriorityDelta) {
            return;
        }
        this.startAsynchronouslyNormalPriorityDelta = startAsynchronouslyNormalPriorityDelta;
        this.notifyListenersOfStartAsynchronouslyNormalPriorityDeltaChanged();
    }

    private void setTypeModel(ITypeModel typeModel) {
        this.typeModel = typeModel;
    }

    public void setUninstallPolicy(int uninstallPolicy) {
        if (this.uninstallPolicy == uninstallPolicy) {
            return;
        }
        this.uninstallPolicy = uninstallPolicy;
        this.notifyListenersOfUninstallPolicyChanged();
    }
}

