/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileInputTestCase
extends GpioProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public GpioProfileInputTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileInputTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
    }

    public void test000_SwitchAllOn() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= inputCount) {
            Boolean v = new Boolean(true);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7502))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test010_SwitchAllOff() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= inputCount) {
            Boolean v = new Boolean(false);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7503))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test020_SwitchFirstOn() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        expectedValue.put(new String("i1"), new Boolean(true));
        int i = 2;
        while ((long)i <= inputCount) {
            Boolean v = new Boolean(false);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7504))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test030_SwitchFirstOff() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        expectedValue.put(new String("i1"), new Boolean(false));
        int i = 2;
        while ((long)i <= inputCount) {
            Boolean v = new Boolean(true);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7505))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test040_SwitchLastOn() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < inputCount) {
            Boolean v = new Boolean(false);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        expectedValue.put(new String("i" + inputCount), new Boolean(true));
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7506))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test050_SwitchLastOff() throws InterruptedException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < inputCount) {
            Boolean v = new Boolean(true);
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        expectedValue.put(new String("i" + inputCount), new Boolean(false));
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7507))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }
}

