/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.util.Hashtable;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileOutputExpressionTestCase
extends GpioProfileAbstractTestCase {
    private long outputCount;
    static /* synthetic */ Class class$0;

    public GpioProfileOutputExpressionTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileOutputExpressionTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
        this.outputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceOutputCountExternalKey).toString());
    }

    public void test010_ClearOutputExpressions() throws InterruptedException {
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        long counter = 1L;
        while (counter <= this.outputCount) {
            String topic = this.prependPrefix("Gpio/Output" + counter + "Expression");
            String filter = "";
            Boolean v = new Boolean(this.getString("keyGpioOutputExpressionValue" + counter, "false"));
            if (!v.booleanValue()) {
                v = Boolean.FALSE;
            }
            expectedValue.put(new String("o" + counter), v);
            this.writeMeasurement(topic, filter);
            ++counter;
        }
    }

    public void test020_SetOutputExpressions() throws InterruptedException {
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        long counter = 1L;
        while (counter <= this.outputCount) {
            String topic = this.prependPrefix("Gpio/Output" + counter + "Expression");
            String filter = "(i" + counter + "=true)";
            Boolean v = new Boolean(true);
            expectedValue.put(new String("o" + counter), v);
            this.writeMeasurement(topic, filter);
            ++counter;
        }
        GpioProfileOutputExpressionTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7502))));
        Hashtable realValue = (Hashtable)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputExpressionTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputExpressionTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7508))));
    }
}

