/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.IOException;
import java.io.OutputStream;
import javax.comm.CommPort;
import org.eclipse.soda.dk.comm.NSParallelPort;
import org.eclipse.soda.dk.comm.NSSerialPort;

public class NSDeviceOutputStream
extends OutputStream {
    int fd = -1;
    private int pt;
    private int bufsize;
    private NSSerialPort sp = null;
    private NSParallelPort pp = null;
    private byte[] buffer = null;

    NSDeviceOutputStream(CommPort port, int portType) {
        if (portType == 2) {
            this.pt = 1;
            this.pp = (NSParallelPort)port;
            this.bufsize = this.pp.outsBufferSize;
        } else {
            this.pt = 2;
            this.sp = (NSSerialPort)port;
            this.bufsize = this.sp.outsBufferSize;
        }
        this.buffer = new byte[this.bufsize];
    }

    public int getPt() {
        return this.pt;
    }

    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i & 0xFF)};
        this.write(b, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        block36: {
            toff = off;
            tlen = len;
            excflag = false;
            obc = 0;
            oldbufsize = this.bufsize;
            notify = false;
            this.bufsize = 0;
            if (this.pp != null) {
                this.bufsize = this.pp.outsBufferSize;
                obc = this.pp.outsBufferCount;
            } else if (this.sp != null) {
                this.bufsize = this.sp.outsBufferSize;
                obc = this.sp.outsBufferCount;
            }
            if (this.bufsize != oldbufsize) {
                if (obc != 0) {
                    rc = this.writeDeviceNC(this.buffer, 0, obc);
                    if (this.pp != null) {
                        this.pp.outsBufferCount = 0;
                    } else if (this.sp != null) {
                        this.sp.outsBufferCount = 0;
                    }
                    if (rc != obc) {
                        excflag = true;
                    }
                }
                this.buffer = null;
                this.buffer = new byte[this.bufsize];
            }
            if (this.bufsize != 0) ** GOTO lbl64
            if (this.pp != null) {
                this.pp.outsBufferCount = 0;
            } else if (this.sp != null) {
                this.sp.outsBufferCount = 0;
            }
            rc = this.writeDeviceNC(b, toff, tlen);
            if (rc == tlen) break block36;
            excflag = true;
            break block36;
lbl-1000:
            // 1 sources

            {
                if (this.pp != null) {
                    obc = this.pp.outsBufferCount;
                } else if (this.sp != null) {
                    obc = this.sp.outsBufferCount;
                }
                if (obc + tlen >= this.bufsize) {
                    wc = this.bufsize - obc;
                    System.arraycopy(b, toff, this.buffer, obc, wc);
                    rc = this.writeDeviceNC(this.buffer, 0, this.bufsize);
                    if (this.pp != null) {
                        this.pp.outsBufferCount = 0;
                    } else if (this.sp != null) {
                        this.sp.outsBufferCount = 0;
                    }
                    if (rc != this.bufsize) {
                        excflag = true;
                        break;
                    }
                } else {
                    wc = tlen;
                    System.arraycopy(b, toff, this.buffer, obc, wc);
                    if (this.pp != null) {
                        this.pp.outsBufferCount += wc;
                    } else if (this.sp != null) {
                        this.sp.outsBufferCount += wc;
                    }
                }
                toff += wc;
                tlen -= wc;
lbl64:
                // 2 sources

                ** while (tlen != 0)
            }
        }
        if (excflag) {
            e = new IOException();
            throw e;
        }
        if (this.pp != null) {
            obc = this.pp.outsBufferCount;
            notify = this.pp.notifyOnBufferFlag;
        } else if (this.sp != null) {
            obc = this.sp.outsBufferCount;
            notify = this.sp.notifyOnBufferFlag;
        }
        if (notify && obc == 0) {
            if (this.pp != null) {
                this.pp.reportParallelEvent(2, false, true);
            } else if (this.sp != null) {
                this.sp.reportSerialEvent(2, false, true);
            }
        }
    }

    public void flush() throws IOException {
        int obc = 0;
        if (this.pp != null) {
            obc = this.pp.outsBufferCount;
        } else if (this.sp != null) {
            obc = this.sp.outsBufferCount;
        }
        int rc = this.writeDeviceNC(this.buffer, 0, obc);
        if (rc != obc) {
            IOException e = new IOException();
            throw e;
        }
    }

    private native int writeDeviceNC(byte[] var1, int var2, int var3);
}

