/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.util.Vector;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.service.log.LogService;

public class Controller
extends Vector
implements ControllerService,
Runnable {
    private static final long serialVersionUID = -8946351256395220870L;
    public static final Integer TRANSPORT_STARTED_VALUE = new Integer(5);
    public static final Integer TRANSPORT_STARTED_NO_OUTPUT = new Integer(-5);
    private Thread thread;
    private boolean running = false;
    private Transport transport;
    private final Object queueLock = new Object();
    private final Object messageReceived = new Object();
    private int queueSizeProblem = 2048;

    public Controller(Transport transport, int priority) {
        this.transport = transport;
        this.thread = new Thread((Runnable)this, transport.getOutputName());
        this.thread.setPriority(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object) {
        this.addElement(object);
        Object object2 = this.queueLock;
        synchronized (object2) {
            this.queueLock.notifyAll();
        }
        int size = this.size();
        if (size > this.getQueueSizeProblem()) {
            this.setQueueSizeProblem(this.getQueueSizeProblem() << 1);
            this.transport.handleError(null, 2034, new Integer(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFirst(Object object) {
        this.add(0, object);
        Object object2 = this.queueLock;
        synchronized (object2) {
            this.queueLock.notifyAll();
        }
    }

    protected void enqueueRestartTransport() {
        this.enqueue(TRANSPORT_STARTED_VALUE);
    }

    protected void enqueueRestartTransportNoOutput() {
        this.enqueue(TRANSPORT_STARTED_NO_OUTPUT);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.enqueue(new Object[]{source, timestamp, data});
    }

    public void errorOccurredSend(Object source, Object timestamp, Object data) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.errorOccurred((Object)this, timestamp, data);
            }
            catch (Exception exception) {
                this.transport.handleError(exception, 2022);
            }
        }
    }

    public int getQueueSizeProblem() {
        return this.queueSizeProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        block12: {
            try {
                Object object = this.messageReceived;
                synchronized (object) {
                    this.messageReceived.notify();
                }
                if (this.transport.getState() < 5) {
                    this.transport.startupMessageReceived(this.transport, timestamp, message);
                    if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2025, message);
                    }
                } else if (this.transport.getTransportListener() != null) {
                    if (this.transport.getInterestMask().isInterested(message)) {
                        this.enqueue(new Object[]{timestamp, message});
                    } else if (EscObject.getTraceLevel() >= 5) {
                        this.transport.report(null, 2026, message);
                    }
                }
            }
            catch (Exception exception) {
                if (!EscObject.shouldLog((int)1)) break block12;
                this.transport.handleError(exception, 2019);
            }
        }
    }

    public void restartTransport() {
        int count = this.size();
        if (count > 0) {
            int index = 0;
            while (index < count) {
                Object object = this.get(0);
                if (object instanceof Boolean || object instanceof Integer) {
                    return;
                }
                ++index;
            }
        }
        this.enqueueRestartTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int messageStatus = 0;
        while (this.running) {
            block40: {
                block41: {
                    int count = this.size();
                    if (count != 0) break block40;
                    int inputMessageCount = this.transport.getInputMessageCount();
                    try {
                        Object object = this.queueLock;
                        synchronized (object) {
                            this.queueLock.wait(this.transport.getNoActivityTimeout());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (!this.running) {
                        return;
                    }
                    count = this.size();
                    if (count != 0 || !this.running) break block40;
                    int inputMessageCountNew = this.transport.getInputMessageCount();
                    if (inputMessageCountNew != inputMessageCount) break block41;
                    int status = this.transport.noActivityProcessing();
                    switch (status) {
                        case 0: {
                            if (messageStatus != 2) {
                                this.transport.report(null, 2037, Long.toString(this.transport.getNoActivityTimeout()));
                                messageStatus = 2;
                                if (this.transport.getState() == 5) {
                                    this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                    break;
                                }
                            }
                            break block40;
                        }
                        case 1: {
                            if (inputMessageCountNew == inputMessageCount) {
                                Object object = this.messageReceived;
                                synchronized (object) {
                                    try {
                                        this.messageReceived.wait(this.transport.getRetryTime());
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            messageStatus = 2;
                            inputMessageCountNew = this.transport.getInputMessageCount();
                            if (inputMessageCountNew == inputMessageCount) {
                                this.restartTransport();
                                break;
                            }
                            if (this.transport.getState() == 5) {
                                this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                break;
                            }
                            break block40;
                        }
                        case 2: {
                            messageStatus = 2;
                            this.restartTransport();
                        }
                    }
                    break block40;
                }
                messageStatus = 1;
            }
            int index = 0;
            while (index < this.size()) {
                boolean output;
                Object object = this.get(0);
                if (object instanceof Object[]) {
                    TransportListener listener = this.transport.getTransportListener();
                    if (listener != null) {
                        Object[] objects = (Object[])object;
                        int length = objects.length;
                        if (length == 2) {
                            messageStatus = 1;
                            MessageService message = (MessageService)objects[1];
                            listener.messageReceived((TransportService)this.transport, objects[0], message);
                            if (EscObject.getTraceLevel() >= 5) {
                                this.transport.report(null, 2023, message);
                            }
                        } else {
                            this.errorOccurredSend(objects[0], objects[2], objects[2]);
                        }
                    }
                } else if (object instanceof MessageService) {
                    this.transport.send((MessageService)object);
                } else if (object instanceof String) {
                    LogService logService = this.transport.getLogService();
                    logService.log(4, object.toString());
                } else if (object instanceof Boolean) {
                    output = (Boolean)object;
                    this.startProcessing(output);
                } else if (object instanceof long[]) {
                    long[] longs = (long[])object;
                    this.transportChangedSend(this.transport, new Long(longs[0]), (int)longs[1], (int)longs[2]);
                } else if (object instanceof Integer) {
                    output = (Integer)object >= 0;
                    this.remove(object);
                    object = null;
                    this.transport.restartProcessing(output);
                }
                if (object != null) {
                    this.remove(object);
                }
                ++index;
            }
        }
    }

    public void setQueueSizeProblem(int queueSizeProblem) {
        this.queueSizeProblem = queueSizeProblem;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public void start(boolean output) {
        if (output) {
            this.enqueue(Boolean.TRUE);
        } else {
            this.enqueue(Boolean.FALSE);
        }
    }

    public void startProcessing(boolean output) {
        boolean toutput = output;
        int errorCount = 0;
        while (this.running && this.transport.getState() >= 2) {
            block11: {
                try {
                    while (this.transport.getState() < 3 && this.transport.getState() > 0) {
                        this.transport.configure();
                        this.transport.connect();
                        if (this.transport.getState() >= 3 || this.transport.getState() <= 0) continue;
                        this.transport.waitStateChange();
                    }
                    if (this.transport.getState() == 5 || this.transport.getState() == 0 || this.transport.getState() < 2) {
                        return;
                    }
                    this.transport.setState(4);
                    this.transport.sleep(10L);
                    int newState = this.transport.startup(toutput);
                    int transportState = this.transport.getState();
                    if (newState > transportState) {
                        this.transport.setState(newState);
                    } else {
                        newState = transportState;
                    }
                    if (this.transport.getState() == 5) {
                        return;
                    }
                    int count = 0;
                    while (this.transport.getState() < 5) {
                        this.transport.waitStateChange(this.transport.getRetryTime() * 3L);
                        if (this.transport.getState() == 5) {
                            return;
                        }
                        if (++count < 2) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!toutput && !EscObject.isTrace()) break block11;
                    this.transport.handleError(exception, 2009);
                    toutput = false;
                }
            }
            if (++errorCount < 2 || this.transport.getState() < 2) continue;
            errorCount = 0;
            this.transport.sleep(this.transport.getRetryTime());
            this.enqueueRestartTransport();
            return;
        }
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (Exception exception) {}
            this.thread = null;
        }
    }

    public void stop(boolean output) {
    }

    public void trace(String debugMessage) {
        this.enqueue(debugMessage);
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        if (Thread.currentThread() == this.thread) {
            this.transportChangedSend(transportService, timestamp, newState, oldState);
        } else {
            this.enqueue(new long[]{((Number)timestamp).longValue(), newState, oldState});
        }
    }

    public void transportChangedSend(TransportService source, Object timestamp, int newState, int oldState) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.transportChanged(source, timestamp, newState, oldState);
            }
            catch (Exception exception) {
                this.transport.handleError(exception, 2018);
            }
        }
        if (newState == 0) {
            this.stop();
        }
        if (newState != oldState) {
            this.transport.report(null, Transport.TRANSPORT_STATE_RESOURCE_TABLE[newState], Transport.STATE_STRINGS[oldState], this.transport.getConfigurationInformation());
        }
    }
}

