/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.ConnectionTransport;

public abstract class ResponseTransport
extends ConnectionTransport {
    private long responseMessageCount = 0L;
    private long responseTimeout = 0L;
    protected final Object writeBlock = new Object();
    protected final Object readBlock = new Object();
    private byte[] lastWriteBytes = null;
    protected MessageService sentMessage = null;
    private long currentCount = -1L;

    protected ResponseTransport() {
    }

    public void fireMessageReceived(Object timestamp, MessageService message) {
        this.responseReceived();
        super.fireMessageReceived(timestamp, message);
    }

    public void fireMessageReceivedNoResponse(Object timestamp, MessageService message) {
        super.fireMessageReceived(timestamp, message);
    }

    public long getDefaultResponseTimeout() {
        return 1000L;
    }

    protected byte[] getLastWriteBytes() {
        return this.lastWriteBytes;
    }

    public long getResponseMessageCount() {
        return this.responseMessageCount;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public MessageService getSentMessage() {
        return this.sentMessage;
    }

    public long getShutdownTimeout() {
        return this.getResponseTimeout() << 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived() {
        this.updateInputMessageCount();
        this.updateResponseMessageCount();
        if (this.getResponseTimeout() != 0L) {
            Object object = this.readBlock;
            synchronized (object) {
                this.readBlock.notifyAll();
            }
        }
    }

    protected void setLastWriteBytes(byte[] lastWriteBytes) {
        this.lastWriteBytes = lastWriteBytes;
    }

    public void setResponseMessageCount(long responseMessageCount) {
        this.responseMessageCount = responseMessageCount;
    }

    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setSentMessage(MessageService sentMessage) {
        this.sentMessage = sentMessage;
    }

    public void setup() {
        super.setup();
        if (this.getResponseTimeout() == 0L) {
            this.setResponseTimeout(this.getDefaultResponseTimeout());
        }
    }

    public long updateResponseMessageCount() {
        return this.responseMessageCount++;
    }

    public void write(byte[] sendBytes) throws Exception {
        this.write(sendBytes, this.getResponseTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(MessageService message) throws Exception {
        long responseTimeout = this.getResponseTimeout();
        if (!Thread.currentThread().isInterrupted()) {
            if (responseTimeout > 0L) {
                Object object = this.writeBlock;
                synchronized (object) {
                    this.setSentMessage(message);
                    this.write(message.getBytes(), responseTimeout);
                }
            } else {
                this.setSentMessage(message);
                this.write(message.getBytes(), responseTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] bytes, long responseTimeout) throws Exception {
        if (responseTimeout > 0L) {
            if (!Thread.currentThread().isInterrupted()) {
                Object object = this.writeBlock;
                synchronized (object) {
                    this.setLastWriteBytes(bytes);
                    try {
                        Object object2 = this.readBlock;
                        synchronized (object2) {
                            if (this.currentCount == this.getResponseMessageCount()) {
                                this.readBlock.wait(responseTimeout);
                            }
                            this.currentCount = this.getResponseMessageCount();
                            super.write(bytes);
                            this.readBlock.wait(responseTimeout);
                        }
                        if (this.currentCount == this.getResponseMessageCount()) {
                            throw this.createException(2039, new Object[]{new Message(bytes), String.valueOf(this.currentCount), String.valueOf(this.responseTimeout)});
                        }
                        --this.currentCount;
                    }
                    catch (InterruptedException interruptedException) {
                        this.report(null, 2031, new Object[]{new Message(bytes)});
                    }
                }
            }
        } else {
            super.write(bytes);
        }
    }
}

