/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.InterruptedIOException;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.transport.Transport;

public class ThreadTransport
extends Transport
implements Runnable {
    private transient Thread thread;
    private boolean running;

    public int getBufferSize() {
        return 1024;
    }

    public long getShutdownTimeout() {
        return 10000L;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void handleNoData() {
        this.setReceivingInput(false);
    }

    public void handleNoInput() {
        this.setReceivingInput(false);
    }

    public boolean isRunning() {
        return this.running && this.getState() > 0;
    }

    protected void processInput() throws Exception {
        int maxlength = this.getBufferSize();
        byte[] buffer = new byte[maxlength];
        int offset = 0;
        int bytesRead = 0;
        int inputProcessed = 0;
        while (this.isRunning() && this.getState() >= 3) {
            try {
                bytesRead = this.read(buffer, offset, maxlength - offset);
                if (bytesRead > 0) {
                    this.setReceivingInput();
                    inputProcessed = this.processInput(buffer, offset += bytesRead);
                    if (inputProcessed > 0 && (offset -= inputProcessed) > 0) {
                        System.arraycopy(buffer, inputProcessed, buffer, 0, offset);
                    }
                    if (offset < maxlength) continue;
                    byte[] newBuffer = new byte[maxlength <<= 1];
                    System.arraycopy(buffer, 0, newBuffer, 0, offset);
                    buffer = newBuffer;
                    continue;
                }
                if (bytesRead == -1) {
                    return;
                }
                this.handleNoInput();
            }
            catch (InterruptedIOException interruptedIOException) {
                bytesRead = 0;
            }
        }
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        int i = 0;
        while (i < length) {
            this.processInput(bytes[i] & 0xFF);
            ++i;
        }
        return length;
    }

    protected void processInput(int value) throws Exception {
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.start(true);
        ** GOTO lbl24
        {
            this.waitStateChange();
            do {
                if (this.isRunning() && this.getState() < 3) continue block2;
                try {
                    if (this.isRunning()) {
                        this.processInput();
                    }
                }
                catch (Exception exception) {
                    this.handleError(exception, 2013);
                }
                if (!this.isRunning()) continue;
                retryTime = this.getRetryTime();
                if (retryTime > 0L) {
                    this.waitStateChange(retryTime);
                    if (this.isRunning()) {
                        this.restart();
                    }
                    this.waitStateChange(retryTime);
                    continue;
                }
                this.setRunning(false);
lbl24:
                // 4 sources

            } while (this.isRunning());
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void shutdown(boolean output) {
        this.setRunning(false);
        try {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.interrupt();
                thread.join(this.getShutdownTimeout());
            }
        }
        catch (InterruptedException exception) {
            this.handleError(exception, 2011);
        }
        this.setThread(null);
        this.setState(3);
        super.shutdown(output);
    }

    public synchronized void start() {
        if (this.getThread() == null) {
            this.setup();
            StringBuffer buffer = new StringBuffer(256);
            buffer.append("I_");
            buffer.append(this.getOutputName());
            Thread thread = new Thread((Runnable)this, buffer.toString());
            this.setThread(thread);
            thread.setPriority(this.getPriority());
            this.setRunning(true);
            thread.start();
            this.sleep(10L);
        }
    }

    public void stop() {
        try {
            super.stop();
            this.setRunning(false);
            Thread thread = this.getThread();
            if (thread != null) {
                thread.interrupt();
                thread.join(this.getShutdownTimeout());
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        this.setThread(null);
    }
}

