/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class TransportListeners
extends EscObject
implements TransportListener {
    private TransportListener[] objects;

    public TransportListeners(TransportListener[] objects) {
        this.setObjects(objects);
    }

    public TransportListeners(TransportListener currentObject, TransportListener newObject) {
        if (currentObject instanceof TransportListeners) {
            TransportListeners currentMulticaster = (TransportListeners)currentObject;
            TransportListener[] oldList = currentMulticaster.getObjects();
            this.objects = new TransportListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new TransportListener[2];
            this.objects[0] = currentObject;
            this.objects[1] = newObject;
        }
    }

    public static TransportListener add(TransportListener currentObject, TransportListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new TransportListeners(currentObject, newObject);
    }

    public static TransportListener remove(TransportListener currentObject, TransportListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof TransportListeners) {
            return ((TransportListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public TransportListener[] getObjects() {
        return this.objects;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].messageReceived(transportService, timestamp, message);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    protected TransportListener remove(TransportListener removeHandler) {
        TransportListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        TransportListener[] newList = new TransportListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new TransportListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(TransportListener[] objects) {
        this.objects = objects;
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].transportChanged(transportService, timestamp, newState, oldState);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }
}

