/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.concrete.signal;

import org.eclipse.soda.dk.device.service.DeviceControl;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.ParameterSignal;
import org.eclipse.soda.dk.transform.service.TransformService;

public class ConcreteSignal
extends ParameterSignal
implements DeviceControl {
    private DeviceService device;

    public ConcreteSignal(String key) {
        this(key, null, null, null);
    }

    public ConcreteSignal(String key, MessageService message, TransformService transform, ParameterService parameter) {
        super(key, message, transform, parameter);
    }

    public ConcreteSignal(String key, MessageService message, TransformService transform) {
        this(key, message, transform, null);
    }

    public Object encode(Object data) {
        TransformService transformService = this.getTransform();
        if (transformService == null) {
            return data;
        }
        return transformService.encode(data);
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }

    public void trigger() {
        this.device.send(this.getMessage());
    }

    public void trigger(Object data) {
        if (data == null) {
            this.trigger();
        } else {
            MessageService message = this.getMessage();
            try {
                Object writeData = this.encode(data);
                MessageService newMessage = (MessageService)message.clone();
                this.getDevice().send(newMessage.encodeMessage(newMessage, this.getParameter(), writeData));
            }
            catch (CloneNotSupportedException exception) {
                this.handleError(exception, 3, message);
            }
        }
    }
}

