/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.agent.factory;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.agent.service.AgentService;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ManagedServiceFactoryBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public class AgentFactory
extends ManagedServiceFactoryBundleActivator
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String ID_KEY = "id";
    public static final String ID_KEY_FILTER = "(id=";
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    public static final String METATYPE_SERVICE;
    public static final String[] OPTIONAL_SERVICE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.metatype.MetaTypeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        METATYPE_SERVICE = clazz.getName();
        OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};
    }

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        DeviceService device = (DeviceService)manager.getImportedService(this.getInterestServiceName());
        AgentService agent = this.createService(device);
        if (agent != null) {
            agent.setConfigurationInformation(properties);
            try {
                agent.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getServiceNames(), (Object)agent, (Dictionary)serviceProperties);
        }
        return agent;
    }

    protected IManagedServiceFactoryAdvisor createAdvisor() {
        return this;
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        Object idFilter = properties.get("idimportfilter");
        String idFilterString = String.valueOf(idFilter);
        if (idFilter != null && idFilterString.length() > 0) {
            manager.addImportedServiceFilter(this.getInterestServiceName(), idFilterString);
        } else {
            String id = String.valueOf(properties.get(ID_KEY));
            String idString = String.valueOf(id);
            if (id != null && idString.length() > 0) {
                StringBuffer buffer = new StringBuffer(ID_KEY_FILTER);
                buffer.append(idString);
                buffer.append(')');
                String filter = buffer.toString();
                manager.addImportedServiceFilter(this.getInterestServiceName(), filter);
            }
        }
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("service.vendor", "IBM");
        return properties;
    }

    public AgentService createService(DeviceService device) {
        return null;
    }

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            AgentService agent = (AgentService)object;
            agent.exit();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String[] getImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return OPTIONAL_SERVICES;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICE;
    }

    public String getServiceName() {
        return DeviceService.SERVICE_NAME;
    }

    public String[] getServiceNames() {
        return new String[]{this.getServiceName()};
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof AgentService) {
            AgentService agent = (AgentService)object;
            if (importedService instanceof NotificationService) {
                agent.setNotificationService((NotificationService)importedService);
            }
        }
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof AgentService) {
            AgentService device = (AgentService)object;
            if (importedService instanceof NotificationService) {
                device.setNotificationService(null);
            }
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
    }

    public Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        AgentService agent = (AgentService)object;
        try {
            agent.stop();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        agent.setConfigurationInformation(properties);
        try {
            agent.start();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        Hashtable serviceProperties = this.createProperties();
        this.updateProperties(serviceProperties, properties);
        manager.setExportedServiceProperties(AgentService.SERVICE_NAME, (Dictionary)serviceProperties);
        return agent;
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        Enumeration enumeration = from.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = from.get(key);
            table.put(key, value);
        }
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        Object service;
        String idFilter;
        Object idFilterObject = properties.get("idimportfilter");
        if (idFilterObject != null && (idFilter = idFilterObject.toString()).length() > 0) {
            try {
                BundleContext bundleContext = this.getBundleContext();
                bundleContext.createFilter(idFilter);
            }
            catch (Exception exception) {
                this.handleException((Exception)new ConfigurationException("idimportfilter", idFilter, (Throwable)exception));
            }
        }
        if ((service = this.getOptionalImportedService(METATYPE_SERVICE)) instanceof MetaTypeService) {
            MetaTypeService metatypeService = (MetaTypeService)service;
            MetaTypeInformation info = metatypeService.getMetaTypeInformation(this.getBundle());
            ConfigurableObject.validateConfiguration((String)pid, (Dictionary)properties, (MetaTypeInformation)info);
        }
    }
}

