/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.test;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class ImportServiceRecordTestCase
extends AbstractServiceTestCase {
    private static final String AUTHOR_KEY = "author";
    private static final String COMPANY_KEY = "company";
    private static final String TYPE_KEY = "type";
    private static final String FRED = "Fred";
    private static final String JOHN = "John";
    private static final String AUTOMATIC_TYPE = "automatic";
    private static final String MANUAL_TYPE = "manual";
    private static final String IBM_ORG = "IBM";
    private static final String ECLIPSE_ORG = "Eclipse";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ImportServiceRecordTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ImportServiceRecordTestCase(String name) {
        super(name);
    }

    private IImportServiceRecordOwner getNoOpOwner() {
        return new IImportServiceRecordOwner(){

            public void serviceAcquired(IImportServiceRecord record) {
            }

            public void serviceReleased(IImportServiceRecord record) {
            }
        };
    }

    public void test_acquire() {
        TestServiceImplementation service1 = new TestServiceImplementation();
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration1 = null;
        ServiceRegistration registration2 = null;
        final ValueHolder acquiredHolder = ValueHolder.nullValue();
        final ValueHolder releasedHolder = ValueHolder.nullValue();
        IImportServiceRecordOwner owner = new IImportServiceRecordOwner(){

            public void serviceAcquired(IImportServiceRecord record) {
                Object service = record.getService();
                acquiredHolder.setValue(service);
            }

            public void serviceReleased(IImportServiceRecord record) {
                Object service = record.getService();
                releasedHolder.setValue(service);
            }
        };
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        record.acquire(owner);
        Assert.assertNull((Object)acquiredHolder.getValue());
        Assert.assertNull((Object)releasedHolder.getValue());
        registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        TestServiceImplementation expected = service1;
        Object actual = acquiredHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        acquiredHolder.setNull();
        registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, null);
        Assert.assertNull((Object)acquiredHolder.getValue());
        Assert.assertNull((Object)releasedHolder.getValue());
        registration1.unregister();
        expected = service1;
        actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        expected = service2;
        actual = acquiredHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        acquiredHolder.setNull();
        releasedHolder.setNull();
        registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        Assert.assertNull((Object)acquiredHolder.getValue());
        Assert.assertNull((Object)releasedHolder.getValue());
        registration1.unregister();
        Assert.assertNull((Object)acquiredHolder.getValue());
        Assert.assertNull((Object)releasedHolder.getValue());
        registration2.unregister();
        Assert.assertNull((Object)acquiredHolder.getValue());
        expected = service2;
        actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        releasedHolder.setNull();
        record.release();
        Assert.assertNull((Object)acquiredHolder.getValue());
        Assert.assertNull((Object)releasedHolder.getValue());
    }

    public void test_getFilter() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        String filterString = "(author=Fred)";
        Filter filter = context.createFilter(filterString);
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, filter);
        Filter expected = filter;
        Filter actual = record.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getName() {
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        String expected = TestService1.SERVICE_NAME;
        String actual = record.getName();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_isAcquired() {
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = null;
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        boolean acquired = record.isAcquired();
        Assert.assertFalse((boolean)acquired);
        IImportServiceRecordOwner owner = this.getNoOpOwner();
        record.acquire(owner);
        acquired = record.isAcquired();
        Assert.assertFalse((boolean)acquired);
        registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        acquired = record.isAcquired();
        Assert.assertTrue((boolean)acquired);
        registration.unregister();
        acquired = record.isAcquired();
        Assert.assertFalse((boolean)acquired);
        registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        acquired = record.isAcquired();
        Assert.assertTrue((boolean)acquired);
        record.release();
        acquired = record.isAcquired();
        Assert.assertFalse((boolean)acquired);
        registration.unregister();
    }

    public void test_release() {
        TestServiceImplementation service = new TestServiceImplementation();
        BundleContext context = this.getBundleContext();
        ServiceRegistration registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        final ValueHolder acquiredHolder = ValueHolder.nullValue();
        final ValueHolder releasedHolder = ValueHolder.nullValue();
        IImportServiceRecordOwner owner = new IImportServiceRecordOwner(){

            public void serviceAcquired(IImportServiceRecord record) {
                Object service = record.getService();
                acquiredHolder.setValue(service);
            }

            public void serviceReleased(IImportServiceRecord record) {
                Object service = record.getService();
                releasedHolder.setValue(service);
            }
        };
        record.acquire(owner);
        record.release();
        TestServiceImplementation expected = service;
        Object actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        releasedHolder.setNull();
        record.acquire(owner);
        registration.unregister();
        expected = service;
        actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        releasedHolder.setNull();
        record.release();
        Assert.assertNull((Object)releasedHolder.getValue());
    }

    public void test_setFilter() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        Hashtable<String, String> properties1 = new Hashtable<String, String>(11);
        ((Dictionary)properties1).put(AUTHOR_KEY, JOHN);
        ((Dictionary)properties1).put(COMPANY_KEY, IBM_ORG);
        ((Dictionary)properties1).put(TYPE_KEY, AUTOMATIC_TYPE);
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, properties1);
        TestServiceImplementation service2 = new TestServiceImplementation();
        Hashtable<String, String> properties2 = new Hashtable<String, String>(11);
        ((Dictionary)properties2).put(AUTHOR_KEY, FRED);
        ((Dictionary)properties2).put(COMPANY_KEY, IBM_ORG);
        ((Dictionary)properties2).put(TYPE_KEY, MANUAL_TYPE);
        ServiceRegistration registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, properties2);
        TestServiceImplementation service3 = new TestServiceImplementation();
        Hashtable<String, String> properties3 = new Hashtable<String, String>(11);
        ((Dictionary)properties3).put(AUTHOR_KEY, JOHN);
        ((Dictionary)properties3).put(COMPANY_KEY, ECLIPSE_ORG);
        ((Dictionary)properties3).put(TYPE_KEY, AUTOMATIC_TYPE);
        ServiceRegistration registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)service3, properties3);
        IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        Object actual = record.getFilter();
        Assert.assertNull((Object)actual);
        String filterString = "(author=Fred)";
        Filter filter = context.createFilter(filterString);
        record.setFilter(filter);
        Object expected = filter;
        actual = record.getFilter();
        Assert.assertEquals((Object)expected, (Object)actual);
        final ValueHolder acquiredHolder = ValueHolder.nullValue();
        final ValueHolder releasedHolder = ValueHolder.nullValue();
        IImportServiceRecordOwner owner = new IImportServiceRecordOwner(){

            public void serviceAcquired(IImportServiceRecord record) {
                Object service = record.getService();
                acquiredHolder.setValue(service);
            }

            public void serviceReleased(IImportServiceRecord record) {
                Object service = record.getService();
                releasedHolder.setValue(service);
            }
        };
        record.acquire(owner);
        expected = service2;
        actual = acquiredHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        acquiredHolder.setNull();
        releasedHolder.setNull();
        filterString = "(&(author=John)(company=IBM))";
        filter = context.createFilter(filterString);
        record.setFilter(filter);
        expected = service2;
        actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        expected = service1;
        actual = acquiredHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        acquiredHolder.setNull();
        acquiredHolder.setNull();
        releasedHolder.setNull();
        filterString = "(&(author=Fred)(company=Eclipse))";
        filter = context.createFilter(filterString);
        record.setFilter(filter);
        expected = service1;
        actual = releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        Assert.assertNull((Object)acquiredHolder.getValue());
        acquiredHolder.setNull();
        releasedHolder.setNull();
        record.setFilter(null);
        Assert.assertNotNull((Object)acquiredHolder.getValue());
        registration3.unregister();
        registration2.unregister();
        registration1.unregister();
        record.release();
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ImportServiceRecordTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ImportServiceRecordTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

