/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class TokenizerTestCase
extends AbstractSatTestCase {
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.TokenizerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TokenizerTestCase(String name) {
        super(name);
    }

    private void _testNextToken(String value, char delimiter) {
        ITokenizer tokenizer = this.createTokenizer(value, delimiter);
        ArrayList<String> tokens = new ArrayList<String>(5);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokens.add(token);
        }
        String expected = "one";
        Object actual = tokens.get(0);
        Assert.assertEquals((Object)expected, actual);
        expected = "two";
        actual = tokens.get(1);
        Assert.assertEquals((Object)expected, actual);
        expected = "three";
        actual = tokens.get(2);
        Assert.assertEquals((Object)expected, actual);
        expected = null;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, actual);
    }

    private ITokenizer createTokenizer(String value) {
        ITokenizer tokenizer = AbstractSatTestCase.FACTORY.createTokenizer(value);
        return tokenizer;
    }

    private ITokenizer createTokenizer(String value, char delimiter) {
        ITokenizer tokenizer = AbstractSatTestCase.FACTORY.createTokenizer(value, delimiter);
        return tokenizer;
    }

    private ITokenizer createTokenizer(String value, int offset) {
        ITokenizer tokenizer = AbstractSatTestCase.FACTORY.createTokenizer(value, offset);
        return tokenizer;
    }

    public void testConstructorsWithIllegalArguments() {
        String value = null;
        try {
            this.createTokenizer(value);
            Assert.fail((String)"The value parameter must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        value = "one,two";
        try {
            int offset = -1;
            this.createTokenizer(value, offset);
            Assert.fail((String)"The index parameter must be a positive interger");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void testConstructorWithOffset() {
        String value = "one,two";
        ITokenizer tokenizer = this.createTokenizer(value, 0);
        String expected = "one";
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 1);
        expected = "ne";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 3);
        expected = new String();
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 4);
        expected = "two";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 6);
        expected = "o";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 7);
        actual = tokenizer.nextToken();
        Assert.assertNull((Object)actual);
    }

    public void testHasMoreTokens() {
        ITokenizer tokenizer = this.createTokenizer("one,two,three");
        boolean expected = true;
        boolean actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        expected = false;
        actual = tokenizer.hasMoreTokens();
        Assert.assertEquals((boolean)expected, (boolean)actual);
    }

    public void testNextToken() {
        this._testNextToken("one,two,three", ',');
        this._testNextToken("one two three", ' ');
    }

    public void testNextTokenWithDuplicateDelimiter() {
        String value = "one,,three";
        ITokenizer tokenizer = this.createTokenizer(value);
        String expected = "one";
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new String();
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = "three";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void testNextTokenWithEmptyString() {
        String value = new String();
        ITokenizer tokenizer = this.createTokenizer(value);
        Object expected = null;
        String actual = tokenizer.nextToken();
        Assert.assertEquals(expected, (Object)actual);
    }

    public void testNextTokenWithLeadingDelimiter() {
        ITokenizer tokenizer = this.createTokenizer(",one");
        String expected = new String();
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = "one";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = null;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void testNextTokenWithTrailingDelimiter() {
        String value = "one";
        ITokenizer tokenizer = this.createTokenizer(value);
        String expected = "one";
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = null;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

