/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal.old;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.old.OldTestCase;
import org.eclipse.soda.sat.core.junit.internal.old.service.Dummy;
import org.eclipse.soda.sat.core.junit.internal.old.service.DummyService;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;

public class BaseBundleActivatorTestCase
extends OldTestCase {
    private ValueHolder activatedHolder = ValueHolder.nullValue();
    private ValueHolder deactivatedHolder = ValueHolder.nullValue();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.junit.internal.old.BaseBundleActivatorTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BaseBundleActivatorTestCase(String name) {
        super(name);
    }

    private BaseBundleActivator createBaseBundleActivator() {
        return new BaseBundleActivator(){

            protected void activate() {
                BaseBundleActivatorTestCase.this.activatedHolder.setTrue();
            }

            protected void deactivate() {
                BaseBundleActivatorTestCase.this.deactivatedHolder.setTrue();
            }

            protected String[] getImportedServiceNames() {
                String[] names = new String[]{DummyService.SERVICE_NAME};
                return names;
            }
        };
    }

    private void runBaseBundleActivatorTest(BaseBundleActivator activator) {
        this.runBaseBundleActivatorTest(activator, null);
    }

    private void runBaseBundleActivatorTest(BaseBundleActivator activator, Runnable action) {
        BundleContext bundleContext = this.getBundleContext();
        try {
            activator.start(bundleContext);
            Assert.assertTrue((String)"BaseBundleActivator was not activated", (boolean)this.activatedHolder.isTrue());
            if (action != null) {
                action.run();
            }
            activator.stop(bundleContext);
            Assert.assertTrue((String)"BaseBundleActivator was not deactivated", (boolean)this.deactivatedHolder.isTrue());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.activatedHolder.setFalse();
        this.deactivatedHolder.setFalse();
    }

    public void testActivateDeactivate() {
        BaseBundleActivator activator = new BaseBundleActivator(){

            protected void activate() {
                super.activate();
                BaseBundleActivatorTestCase.this.activatedHolder.setTrue();
            }

            protected void deactivate() {
                BaseBundleActivatorTestCase.this.deactivatedHolder.setTrue();
                super.deactivate();
            }

            protected String[] getImportedServiceNames() {
                return BaseBundleActivator.NO_SERVICES;
            }
        };
        this.runBaseBundleActivatorTest(activator);
    }

    public void testExportedServices() {
        BaseBundleActivator activator = new BaseBundleActivator(){

            protected void activate() {
                Dummy dummy = new Dummy();
                this.addExportedService(DummyService.SERVICE_NAME, dummy, null);
                BaseBundleActivatorTestCase.this.activatedHolder.setTrue();
            }

            protected void deactivate() {
                BaseBundleActivatorTestCase.this.deactivatedHolder.setTrue();
            }

            public String[] getImportedServiceNames() {
                return BaseBundleActivator.NO_SERVICES;
            }
        };
        BundleContext bundleContext = this.getBundleContext();
        final IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(bundleContext, DummyService.SERVICE_NAME, null);
        Runnable acquireAction = new Runnable(){

            public void run() {
                record.acquire((IImportServiceRecordOwner)BaseBundleActivatorTestCase.this);
                Assert.assertTrue((String)"ImportServiceRecord was not acquired", (boolean)record.isAcquired());
                record.release();
            }
        };
        this.runBaseBundleActivatorTest(activator, acquireAction);
        record.acquire((IImportServiceRecordOwner)this);
        Assert.assertTrue((String)"ImportServiceRecord was acquired", (!record.isAcquired() ? 1 : 0) != 0);
        record.release();
    }

    public void testImportedServices() {
        BaseBundleActivator activator = this.createBaseBundleActivator();
        this.registerDummyService();
        this.runBaseBundleActivatorTest(activator);
        this.unregisterDummyService();
    }

    public void testServiceEvents() throws Exception {
        BaseBundleActivator activator = this.createBaseBundleActivator();
        BundleContext bundleContext = this.getBundleContext();
        activator.start(bundleContext);
        Assert.assertTrue((String)"BaseBundleActivator was activated", (boolean)this.activatedHolder.isFalse());
        this.registerDummyService();
        Assert.assertTrue((String)"BaseBundleActivator was not activated", (boolean)this.activatedHolder.isTrue());
        this.unregisterDummyService();
        Assert.assertTrue((String)"BaseBundleActivator was activated", (boolean)this.deactivatedHolder.isTrue());
    }
}

