/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BundleUtilityTestCase
extends AbstractServiceTestCase {
    private ServiceRegistration registration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.util.test.BundleUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BundleUtilityTestCase(String name) {
        super(name);
    }

    private void registerTestService() {
        TestServiceImplementation service = new TestServiceImplementation();
        BundleContext context = this.getBundleContext();
        this.registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
    }

    public void test_getServiceInstanceOf() {
        BundleUtility utility = BundleUtility.getInstance();
        Bundle bundle = this.getBundle();
        this.registerTestService();
        ServiceReference reference = utility.getServiceInstanceOf(bundle, TestService1.SERVICE_NAME);
        Object[] objectClasses = (Object[])reference.getProperty("objectClass");
        int size = objectClasses.length;
        Assert.assertEquals((int)1, (int)size);
        Object serviceName = objectClasses[0];
        Assert.assertEquals((Object)TestService1.SERVICE_NAME, (Object)serviceName);
        this.unregisterTestService();
        reference = utility.getServiceInstanceOf(bundle, TestService1.SERVICE_NAME);
        Assert.assertNull((Object)reference);
    }

    public void test_isBundleState() {
        BundleUtility utility = BundleUtility.getInstance();
        Bundle bundle = this.getBundle();
        boolean value = utility.isBundleState(bundle, 32);
        Assert.assertTrue((boolean)value);
    }

    public void test_isRegisteredService() {
        BundleContext context = this.getBundleContext();
        BundleUtility utility = BundleUtility.getInstance();
        Bundle bundle = this.getBundle();
        this.registerTestService();
        ServiceReference reference = context.getServiceReference(TestService1.SERVICE_NAME);
        Assert.assertNotNull((Object)reference);
        boolean registered = utility.isRegisteredService(bundle, reference);
        Assert.assertTrue((boolean)registered);
        Assert.assertNotNull((Object)reference);
        registered = utility.isRegisteredService(bundle, TestService1.SERVICE_NAME);
        Assert.assertTrue((boolean)registered);
        this.unregisterTestService();
    }

    public void test_isServiceInUse() {
        this.registerTestService();
        BundleContext context = this.getBundleContext();
        ServiceReference reference = context.getServiceReference(TestService1.SERVICE_NAME);
        Assert.assertNotNull((Object)reference);
        Object service = context.getService(reference);
        Assert.assertNotNull((Object)service);
        BundleUtility utility = BundleUtility.getInstance();
        Bundle bundle = this.getBundle();
        boolean inUse = utility.isServiceInUse(bundle, reference);
        Assert.assertTrue((boolean)inUse);
        context.ungetService(reference);
        Assert.assertNotNull((Object)reference);
        inUse = utility.isServiceInUse(bundle, reference);
        Assert.assertFalse((boolean)inUse);
        context.ungetService(reference);
        this.unregisterTestService();
    }

    public void test_toBundleStateString() {
        BundleUtility utility = BundleUtility.getInstance();
        Bundle bundle = this.getBundle();
        String expected = "ACTIVE";
        String actual = utility.toBundleStateString(bundle);
        Assert.assertEquals((String)expected, (String)actual);
    }

    private void unregisterTestService() {
        if (this.registration == null) {
            return;
        }
        this.registration.unregister();
        this.registration = null;
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.BundleUtilityTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.util.test.BundleUtilityTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

