/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceReferenceUtilityTestCase
extends AbstractServiceTestCase {
    private static final ServiceReference[] NO_SERVICE_REFERENCES = new ServiceReference[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static Test suite() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.soda.sat.core.util.test.ServiceReferenceUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ServiceReferenceUtilityTestCase(String name) {
        super(name);
    }

    public void test_getServiceNames() {
        BundleContext context = this.getBundleContext();
        String[] services = new String[]{TestService1.SERVICE_NAME, TestService2.SERVICE_NAME};
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = context.registerService(services, (Object)service, null);
        ServiceReference reference = registration.getReference();
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        List serviceNames = utility.getServiceNames(reference);
        int expectedLength = 2;
        int actualLength = serviceNames.size();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        Object serviceName = serviceNames.get(0);
        boolean valid = serviceName.equals(TestService1.SERVICE_NAME) || serviceName.equals(TestService2.SERVICE_NAME);
        Assert.assertTrue((boolean)valid);
        serviceName = serviceNames.get(1);
        valid = serviceName.equals(TestService1.SERVICE_NAME) || serviceName.equals(TestService2.SERVICE_NAME);
        Assert.assertTrue((boolean)valid);
        registration.unregister();
    }

    public void test_isServiceInstanceOf() {
        BundleContext context = this.getBundleContext();
        String[] services = new String[]{TestService1.SERVICE_NAME, TestService2.SERVICE_NAME};
        TestServiceImplementation test1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(services, (Object)test1, null);
        ServiceReference reference1 = registration1.getReference();
        TestService3 test3 = new TestService3(){};
        ServiceRegistration registration3 = context.registerService(TestService3.SERVICE_NAME, (Object)test3, null);
        ServiceReference reference3 = registration3.getReference();
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        boolean result = utility.isServiceInstanceOf(reference1, TestService1.SERVICE_NAME);
        Assert.assertTrue((boolean)result);
        result = utility.isServiceInstanceOf(reference1, TestService2.SERVICE_NAME);
        Assert.assertTrue((boolean)result);
        result = utility.isServiceInstanceOf(reference3, TestService3.SERVICE_NAME);
        Assert.assertTrue((boolean)result);
        result = utility.isServiceInstanceOf(reference1, TestService3.SERVICE_NAME);
        Assert.assertFalse((boolean)result);
        result = utility.isServiceInstanceOf(reference3, TestService1.SERVICE_NAME);
        Assert.assertFalse((boolean)result);
        result = utility.isServiceInstanceOf(reference3, TestService2.SERVICE_NAME);
        Assert.assertFalse((boolean)result);
        registration3.unregister();
        registration1.unregister();
    }

    public void test_select() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation test1 = new TestServiceImplementation();
        Hashtable<String, Integer> properties1 = new Hashtable<String, Integer>(11);
        ((Dictionary)properties1).put("service.ranking", new Integer(1));
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)test1, properties1);
        ServiceReference reference1 = registration1.getReference();
        TestServiceImplementation test2 = new TestServiceImplementation();
        Hashtable<String, Integer> properties2 = new Hashtable<String, Integer>(11);
        ((Dictionary)properties2).put("service.ranking", new Integer(2));
        ServiceRegistration registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)test2, properties2);
        ServiceReference reference2 = registration2.getReference();
        TestServiceImplementation test3 = new TestServiceImplementation();
        Hashtable<String, Integer> properties3 = new Hashtable<String, Integer>(11);
        ((Dictionary)properties3).put("service.ranking", new Integer(2));
        ServiceRegistration registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)test3, properties3);
        ServiceReference reference3 = registration3.getReference();
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        ServiceReference expected = reference2;
        ServiceReference[] references = new ServiceReference[]{reference1, reference2, reference3};
        ServiceReference actual = utility.select(references);
        Assert.assertEquals((Object)expected, (Object)actual);
        references[0] = reference2;
        references[1] = reference3;
        references[2] = reference1;
        actual = utility.select(references);
        Assert.assertEquals((Object)expected, (Object)actual);
        references[0] = reference3;
        references[1] = reference1;
        references[2] = reference2;
        actual = utility.select(references);
        Assert.assertEquals((Object)expected, (Object)actual);
        registration3.unregister();
        registration2.unregister();
        registration1.unregister();
    }

    public void test_selectWithEmptyServiceReferenceArray() {
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        ServiceReference[] references = NO_SERVICE_REFERENCES;
        ServiceReference reference = utility.select(references);
        Assert.assertNull((Object)reference);
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.ServiceReferenceUtilityTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.util.test.ServiceReferenceUtilityTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    static interface TestService3 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.util.test.ServiceReferenceUtilityTestCase$TestService3");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

