/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection.factory;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ManagedServiceFactoryBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public abstract class ConnectionFactory
extends ManagedServiceFactoryBundleActivator
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String METATYPE_SERVICE;
    public static final String[] OPTIONAL_SERVICE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.metatype.MetaTypeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        METATYPE_SERVICE = clazz.getName();
        OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};
    }

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        ConnectionService connection = this.createService(properties);
        if (connection != null) {
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, new Hashtable(), properties, manager), (Object)connection, (Dictionary)serviceProperties);
        }
        return connection;
    }

    protected IManagedServiceFactoryAdvisor createAdvisor() {
        return this;
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("service.vendor", "IBM");
        return properties;
    }

    public abstract ConnectionService createService(Dictionary var1);

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            Connection connection = (Connection)object;
            connection.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
    }

    public abstract String[] getExportedServiceNames(String var1, Dictionary var2, Dictionary var3, IBundleActivationManager var4);

    public String[] getImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return BaseBundleActivator.NO_SERVICES;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICE;
    }

    public String getServiceName() {
        return "org.eclipse.soda.dk.connection.service.ConnectionService";
    }

    public void handleAcquiredOptionalImportedService(String arg0, Object arg1, String arg2, Object arg3, IBundleActivationManager arg4) {
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
    }

    public void handleReleasedOptionalImportedService(String arg0, Object arg1, String arg2, Object arg3, IBundleActivationManager arg4) {
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        ConnectionService connection = (ConnectionService)object;
        manager.removeExportedService(this.getServiceName(), object);
        Thread.yield();
        try {
            connection.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
        return this.create(pid, properties, manager);
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            Enumeration enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = from.get(key);
                table.put(key, value);
            }
        }
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        Object service;
        String idFilter;
        Object idFilterObject = properties.get("idimportfilter");
        if (idFilterObject != null && (idFilter = idFilterObject.toString()).length() > 0) {
            try {
                BundleContext bundleContext = this.getBundleContext();
                bundleContext.createFilter(idFilter);
            }
            catch (Exception exception) {
                this.handleException((Exception)new ConfigurationException("idimportfilter", idFilter, (Throwable)exception));
            }
        }
        if ((service = this.getOptionalImportedService(METATYPE_SERVICE)) instanceof MetaTypeService) {
            MetaTypeService metatypeService = (MetaTypeService)service;
            MetaTypeInformation info = metatypeService.getMetaTypeInformation(this.getBundle());
            ConfigurableObject.validateConfiguration((String)pid, (Dictionary)properties, (MetaTypeInformation)info);
        }
    }
}

