/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.dependency.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.dependency.internal.model.interfaces.IBundleDependencyModel;
import org.eclipse.soda.sat.dependency.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.dependency.internal.nls.Messages;
import org.eclipse.soda.sat.dependency.internal.servlet.html.WebPageGenerator;

public class BundleDependencyHttpProcessor {
    private static final String UNKNOWN_ACTION_ERROR_KEY = "BundleDependencyHttpProcessor.UnknownActionError";
    public static final String ACTION_PARAMETER = "action";
    public static final String BUNDLE_PARAMETER = "bundle";
    public static final String BROWSE_ACTION = "browse";
    public static final String PING_ACTION = "ping";
    public static final String SHOW_ALL_BUNDLES_ACTION = "showAllBundles";
    public static final String SHOW_IMMEDIATE_BUNDLES_ACTION = "showImmediateBundles";
    public static final String GET_ALL_DEPENDENTS_OF_ACTION = "getAllDependentsOf";
    public static final String GET_ALL_PREREQUISITES_OF_ACTION = "getAllPrerequisitesOf";
    public static final String GET_BUNDLES_ACTION = "getBundles";
    public static final String GET_DEPENDENTS_OF_ACTION = "getDependentsOf";
    public static final String GET_PREREQUISITES_OF_ACTION = "getPrerequisitesOf";
    public static final String GET_SERVICES_NAMES_EXPORTED_BY_ACTION = "getServiceNamesExportedBy";
    public static final String GET_SERVICES_NAMES_IMPORTED_BY_ACTION = "getServiceNamesImportedBy";
    public static final String IS_ACTIVE_ACTION = "isActive";
    public static final String IS_BUNDLE_ACTION = "isBundle";
    public static final String IS_EXPORTING_SERVICES_ACTION = "isExportingServices";
    public static final String IS_IMPORTING_SERVICES_ACTION = "isImportingServices";
    public static final String TO_XML_ACTION = "toXml";
    private static final String CONTENT_TYPE = "text/html";
    private String bundle;
    private WebPageGenerator generator;
    private IBundleDependencyModel model;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private boolean showAllBundles;

    public void bind(IBundleDependencyModel model) {
        this.setModel(model);
    }

    private String getBundle() {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebPageGenerator getGenerator() {
        BundleDependencyHttpProcessor bundleDependencyHttpProcessor = this;
        synchronized (bundleDependencyHttpProcessor) {
            if (this.generator == null) {
                IBundleDependencyModel model = this.getModel();
                WebPageGenerator generator = new WebPageGenerator(model);
                this.setGenerator(generator);
            }
        }
        return this.generator;
    }

    private IBundleDependencyModel getModel() {
        return this.model;
    }

    private HttpServletRequest getRequest() {
        return this.request;
    }

    private HttpServletResponse getResponse() {
        return this.response;
    }

    private boolean getShowAllBundles() {
        return this.showAllBundles;
    }

    private void handleBrowseRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        if (bundle == null) {
            bundle = this.getBundle();
        } else {
            this.setBundle(bundle);
        }
        boolean showAllBundles = this.getShowAllBundles();
        WebPageGenerator generator = this.getGenerator();
        HttpServletResponse response = this.getResponse();
        generator.generate(bundle, showAllBundles, response);
    }

    private void handleDefaultRequest() throws IOException {
        HttpServletResponse response = this.getResponse();
        PrintWriter writer = response.getWriter();
        long time = System.currentTimeMillis();
        writer.print(time);
    }

    private void handleException(Throwable exception) throws IOException {
        if (exception == null) {
            return;
        }
        exception.printStackTrace();
        WebPageGenerator generator = this.getGenerator();
        HttpServletResponse response = this.getResponse();
        generator.generate(response, exception);
    }

    private void handleGetAllDependentsOfRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getAllDependentsOf(bundle);
        this.send(list);
    }

    private void handleGetAllPrerequisitesOfRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getAllPrerequisitesOf(bundle);
        this.send(list);
    }

    private void handleGetBundlesRequest() throws IOException {
        IBundleDependencyModel model = this.getModel();
        List list = model.getBundles();
        this.send(list);
    }

    private void handleGetDependentsOfRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getDependentsOf(bundle);
        this.send(list);
    }

    private void handleGetPrerequisitesOfRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getPrerequisitesOf(bundle);
        this.send(list);
    }

    private void handleGetServiceNamesExportedByRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getServiceNamesExportedBy(bundle);
        this.send(list);
    }

    private void handleGetServiceNamesImportedByRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        List list = model.getServiceNamesImportedBy(bundle);
        this.send(list);
    }

    private void handleIsActiveRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        boolean active = model.isActive(bundle);
        this.send(active);
    }

    private void handleIsBundleRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        boolean isBundle = model.isBundle(bundle);
        this.send(isBundle);
    }

    private void handleIsExportingServicesRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        boolean exportedServices = model.isExportingServices(bundle);
        this.send(exportedServices);
    }

    private void handleIsImportingServicesRequest() throws IOException {
        HttpServletRequest request = this.getRequest();
        String bundle = request.getParameter(BUNDLE_PARAMETER);
        IBundleDependencyModel model = this.getModel();
        boolean importedServices = model.isImportingServices(bundle);
        this.send(importedServices);
    }

    private void handlePingRequest() throws IOException {
        this.send(true);
    }

    private void handleShowAllBundlesRequest() throws IOException {
        this.setShowAllBundles(true);
        this.handleBrowseRequest();
    }

    private void handleShowImmediateBundlesRequest() throws IOException {
        this.setShowAllBundles(false);
        this.handleBrowseRequest();
    }

    private void handleToXmlRequest() throws IOException {
        IBundleDependencyModel model = this.getModel();
        String xml = model.toXml();
        this.send(xml);
    }

    private void handleUnknownAction(String action) throws IOException {
        HttpServletRequest request = this.getRequest();
        String remoteAddress = request.getRemoteAddr();
        HttpServletResponse response = this.getResponse();
        int error = 400;
        Object[] values = new Object[]{new Integer(error), action, remoteAddress};
        String pattern = Messages.getString(UNKNOWN_ACTION_ERROR_KEY);
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logError((Object)this, (String)message);
        response.sendError(error, message);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setRequest(request);
        this.setResponse(response);
        this.processAction();
    }

    private void processAction() throws IOException {
        HttpServletRequest request = this.getRequest();
        String action = request.getParameter(ACTION_PARAMETER);
        try {
            if (BROWSE_ACTION.equalsIgnoreCase(action)) {
                this.handleBrowseRequest();
            } else if (PING_ACTION.equalsIgnoreCase(action)) {
                this.handlePingRequest();
            } else if (SHOW_ALL_BUNDLES_ACTION.equalsIgnoreCase(action)) {
                this.handleShowAllBundlesRequest();
            } else if (SHOW_IMMEDIATE_BUNDLES_ACTION.equalsIgnoreCase(action)) {
                this.handleShowImmediateBundlesRequest();
            } else if (GET_ALL_DEPENDENTS_OF_ACTION.equalsIgnoreCase(action)) {
                this.handleGetAllDependentsOfRequest();
            } else if (GET_ALL_PREREQUISITES_OF_ACTION.equalsIgnoreCase(action)) {
                this.handleGetAllPrerequisitesOfRequest();
            } else if (GET_BUNDLES_ACTION.equalsIgnoreCase(action)) {
                this.handleGetBundlesRequest();
            } else if (GET_DEPENDENTS_OF_ACTION.equalsIgnoreCase(action)) {
                this.handleGetDependentsOfRequest();
            } else if (GET_PREREQUISITES_OF_ACTION.equalsIgnoreCase(action)) {
                this.handleGetPrerequisitesOfRequest();
            } else if (GET_SERVICES_NAMES_EXPORTED_BY_ACTION.equalsIgnoreCase(action)) {
                this.handleGetServiceNamesExportedByRequest();
            } else if (GET_SERVICES_NAMES_IMPORTED_BY_ACTION.equalsIgnoreCase(action)) {
                this.handleGetServiceNamesImportedByRequest();
            } else if (IS_ACTIVE_ACTION.equalsIgnoreCase(action)) {
                this.handleIsActiveRequest();
            } else if (IS_BUNDLE_ACTION.equalsIgnoreCase(action)) {
                this.handleIsBundleRequest();
            } else if (IS_EXPORTING_SERVICES_ACTION.equalsIgnoreCase(action)) {
                this.handleIsExportingServicesRequest();
            } else if (IS_IMPORTING_SERVICES_ACTION.equalsIgnoreCase(action)) {
                this.handleIsImportingServicesRequest();
            } else if (TO_XML_ACTION.equalsIgnoreCase(action)) {
                this.handleToXmlRequest();
            } else if (action == null) {
                this.handleDefaultRequest();
            } else {
                this.handleUnknownAction(action);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void send(boolean value) throws IOException {
        Boolean wrapper = new Boolean(value);
        String text = wrapper.toString();
        PrintWriter writer = this.response.getWriter();
        writer.print(text);
    }

    private void send(List list) throws IOException {
        HttpServletResponse response = this.getResponse();
        PrintWriter writer = response.getWriter();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String bundle = (String)iterator.next();
            writer.print(bundle);
            if (!iterator.hasNext()) continue;
            writer.print(',');
        }
    }

    private void send(String value) throws IOException {
        HttpServletResponse response = this.getResponse();
        PrintWriter writer = response.getWriter();
        writer.print(value);
    }

    private void setBundle(String bundle) {
        this.bundle = bundle;
    }

    private void setGenerator(WebPageGenerator generator) {
        this.generator = generator;
    }

    private void setModel(IBundleDependencyModel model) {
        this.model = model;
    }

    private void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    private void setResponse(HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE);
        this.response = response;
    }

    private void setShowAllBundles(boolean showAllBundles) {
        this.showAllBundles = showAllBundles;
    }

    public void unbind() {
        this.setModel(null);
    }
}

