/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;

public abstract class BaseBundleActivator
implements BundleActivator {
    private static final String FAILED_TO_FIND_PROPERTIES_FILE_KEY = "BaseBundleActivator.FailedToFindPropertiesFile";
    private static final String FAILED_TO_FIND_PROPERTIES_RESOURCE_KEY = "BaseBundleActivator.FailedToFindPropertiesResource";
    private static final String FAILED_TO_GET_IMPORTED_SERVICE_KEY = "BaseBundleActivator.FailedToGetImportedService";
    private static final String FILENAME_KEY = "BaseBundleActivator.Filename";
    private static final String RESOURCE_KEY = "BaseBundleActivator.Resource";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String SERVICE_KEY = "Common.Service";
    private static final String SHOULD_HAVE_OVERRIDDEN_METHOD_KEY = "Common.ShouldHaveOverriddenMethod";
    protected static final String[] NO_SERVICES = new String[0];
    private IBundleActivationManager bundleActivationManager;

    protected final void acquireImportedServices() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.acquireImportedServices();
    }

    protected final void acquireOptionalImportedServices() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.acquireOptionalImportedServices();
    }

    protected void activate() {
    }

    protected final void addExportedProxyService(Class interfaceType, IProxyServiceHandler handler, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addExportedProxyService(interfaceType, handler, properties);
    }

    protected final void addExportedProxyServices(Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addExportedProxyServices(interfaceTypes, handler, properties);
    }

    protected final void addExportedService(String name, Object service, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addExportedService(name, service, properties);
    }

    protected final void addExportedServices(String[] names, Object service, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addExportedServices(names, service, properties);
    }

    protected final void addImportedServiceFilter(String name, String filterString) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addImportedServiceFilter(name, filterString);
    }

    protected final void addOptionalImportedServiceFilter(String name, String filterString) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.addOptionalImportedServiceFilter(name, filterString);
    }

    private void checkImportedServiceIsNotNull(String name, Object service) {
        if (service != null) {
            return;
        }
        if (!(this instanceof IManagedServiceFactoryAdvisor)) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = this.getBundleSymbolicName();
        String label = Messages.getString(SERVICE_KEY);
        String warning = Messages.getString(FAILED_TO_GET_IMPORTED_SERVICE_KEY);
        utility.warn(component, source, warning, label, name);
    }

    private IBundleActivationManagerOwner createBundleActivationManagerOwner() {
        return new IBundleActivationManagerOwner(){

            public void activate() {
                BaseBundleActivator.this.activate();
            }

            public void deactivate() {
                BaseBundleActivator.this.deactivate();
            }

            public int getAsyncStartPriority() {
                return BaseBundleActivator.this.getAsyncStartPriority();
            }

            public String[] getImportedServiceNames() {
                return BaseBundleActivator.this.getImportedServiceNames();
            }

            public String[] getOptionalImportedServiceNames() {
                return BaseBundleActivator.this.getOptionalImportedServiceNames();
            }

            public InputStream getPropertiesInputStream() throws IOException {
                return BaseBundleActivator.this.getPropertiesInputStream();
            }

            public void handleAcquiredOptionalImportedService(String serviceName, Object service) {
                BaseBundleActivator.this.handleAcquiredOptionalImportedService(serviceName, service);
            }

            public boolean handleException(Exception exception) {
                return BaseBundleActivator.this.handleException(exception);
            }

            public void handleFailedToFindProperties(String filename) {
                BaseBundleActivator.this.handleFailedToFindProperties(filename);
            }

            public void handleReleasedOptionalImportedService(String serviceName, Object service) {
                BaseBundleActivator.this.handleReleasedOptionalImportedService(serviceName, service);
            }

            public boolean isStartAsync() {
                return BaseBundleActivator.this.isStartAsync();
            }

            public boolean isTransient() {
                return BaseBundleActivator.this.isTransient();
            }

            public boolean isUninstallable() {
                return BaseBundleActivator.this.isUninstallable();
            }

            public void start() throws Exception {
                BaseBundleActivator.this.start();
            }

            public void stop() throws Exception {
                BaseBundleActivator.this.stop();
            }
        };
    }

    protected void deactivate() {
    }

    protected int getAsyncStartPriority() {
        return 5;
    }

    protected final Bundle getBundle() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Bundle bundle = manager.getBundle();
        return bundle;
    }

    private IBundleActivationManager getBundleActivationManager() {
        return this.bundleActivationManager;
    }

    protected final BundleContext getBundleContext() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        BundleContext bundleContext = manager.getBundleContext();
        return bundleContext;
    }

    protected final String getBundleSymbolicName() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        String name = manager.getBundleSymbolicName();
        return name;
    }

    protected final File getDataDirectory() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        File file = manager.getDataDirectory();
        return file;
    }

    protected final File getDataFile(String filename) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        File file = manager.getDataFile(filename);
        return file;
    }

    protected final Object getExportedService(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object service = manager.getExportedService(name);
        return service;
    }

    protected final String[] getExportedServiceNamesFromManifest() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        String[] names = manager.getExportedServiceNamesFromManifest();
        return names;
    }

    protected final Dictionary getExportedServiceProperties(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Dictionary properties = manager.getExportedServiceProperties(name);
        return properties;
    }

    protected final Dictionary getExportedServiceProperties(String name, Object service) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Dictionary properties = manager.getExportedServiceProperties(name, service);
        return properties;
    }

    protected final Object[] getExportedServices(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object[] services = manager.getExportedServices(name);
        return services;
    }

    protected final InputStream getFilePropertiesInputStream() throws IOException {
        IBundleActivationManager manager = this.getBundleActivationManager();
        InputStream stream = manager.getFilePropertiesInputStream();
        return stream;
    }

    protected final InputStream getFilePropertiesInputStream(String filename) throws IOException {
        IBundleActivationManager manager = this.getBundleActivationManager();
        InputStream stream = manager.getFilePropertiesInputStream(filename);
        return stream;
    }

    protected final Object getImportedService(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object service = manager.getImportedService(name);
        this.checkImportedServiceIsNotNull(name, service);
        return service;
    }

    protected final Filter getImportedServiceFilter(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Filter filter = manager.getImportedServiceFilter(name);
        return filter;
    }

    protected String[] getImportedServiceNames() {
        return NO_SERVICES;
    }

    protected final String[] getImportedServiceNamesFromManifest() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        String[] names = manager.getImportedServiceNamesFromManifest();
        return names;
    }

    protected final Object getImportedServiceProperty(String name, String key) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object value = manager.getImportedServiceProperty(name, key);
        return value;
    }

    protected final String[] getImportedServicePropertyKeys(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        String[] keys = manager.getImportedServicePropertyKeys(name);
        return keys;
    }

    protected final Object getOptionalImportedService(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Object service = manager.getOptionalImportedService(name);
        return service;
    }

    protected String[] getOptionalImportedServiceNames() {
        return NO_SERVICES;
    }

    protected final Properties getProperties() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        Properties properties = manager.getProperties();
        return properties;
    }

    protected InputStream getPropertiesInputStream() throws IOException {
        return null;
    }

    protected String getProperty(String key, String defaultValue) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        String value = manager.getProperty(key, defaultValue);
        return value;
    }

    protected final InputStream getResourcePropertiesInputStream() throws IOException {
        String symbolicName = this.getBundleSymbolicName();
        int length = symbolicName.length() + 11;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(symbolicName);
        buffer.append(".properties");
        String filename = buffer.toString();
        InputStream stream = this.getResourcePropertiesInputStream(filename);
        return stream;
    }

    protected final InputStream getResourcePropertiesInputStream(String filename) throws IOException {
        Class<?> clazz = this.getClass();
        InputStream stream = clazz.getResourceAsStream(filename);
        if (stream == null) {
            WarningMessageUtility utility = WarningMessageUtility.getInstance();
            String component = Messages.getString(SAT_CORE_KEY);
            Bundle bundle = this.getBundle();
            String source = bundle.getSymbolicName();
            String warning = Messages.getString(FAILED_TO_FIND_PROPERTIES_RESOURCE_KEY);
            String label = Messages.getString(RESOURCE_KEY);
            utility.warn(component, source, warning, label, filename);
        } else {
            stream = new BufferedInputStream(stream);
        }
        return stream;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        this.warnShouldHaveOverriddenMethod("handleAcquiredOptionalImportedService(String, Object)");
    }

    protected boolean handleException(Exception exception) {
        exception.printStackTrace();
        return false;
    }

    protected void handleFailedToFindProperties(String filename) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        String warning = Messages.getString(FAILED_TO_FIND_PROPERTIES_FILE_KEY);
        String label = Messages.getString(FILENAME_KEY);
        utility.warn(component, source, warning, label, filename);
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        this.warnShouldHaveOverriddenMethod("handleReleasedOptionalImportedService(String, Object)");
    }

    protected boolean isStartAsync() {
        return false;
    }

    protected boolean isTransient() {
        return false;
    }

    protected boolean isUninstallable() {
        return false;
    }

    protected final void releaseImportedServices() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.releaseImportedServices();
    }

    protected final void releaseOptionalImportedServices() {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.releaseOptionalImportedServices();
    }

    protected final void removeExportedService(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.removeExportedService(name);
    }

    protected final void removeExportedService(String name, Object service) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.removeExportedService(name, service);
    }

    protected final void removeExportedServices(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.removeExportedServices(name);
    }

    protected final void removeImportedServiceFilter(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.removeImportedServiceFilter(name);
    }

    protected final void removeOptionalImportedServiceFilter(String name) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.removeOptionalImportedServiceFilter(name);
    }

    protected final void restartFramework() throws BundleException {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.restartFramework();
    }

    private void setBundleActivationManager(IBundleActivationManager bundleActivationManager) {
        this.bundleActivationManager = bundleActivationManager;
    }

    protected final void setExportedServiceProperties(String name, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.setExportedServiceProperties(name, properties);
    }

    protected final void setExportedServiceProperties(String name, Object service, Dictionary properties) {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.setExportedServiceProperties(name, service, properties);
    }

    protected final void shutdownFramework() throws BundleException {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.shutdownFramework();
    }

    protected void start() throws Exception {
    }

    public final void start(BundleContext bundleContext) throws Exception {
        IBundleActivationManagerOwner owner = this.createBundleActivationManagerOwner();
        FactoryUtility utility = FactoryUtility.getInstance();
        IBundleActivationManager manager = utility.createBundleActivationManager();
        this.setBundleActivationManager(manager);
        manager.start(bundleContext, owner);
    }

    protected void stop() throws Exception {
    }

    public final void stop(BundleContext bundleContext) throws Exception {
        IBundleActivationManager manager = this.getBundleActivationManager();
        manager.stop(bundleContext);
        this.setBundleActivationManager(null);
    }

    private void warnShouldHaveOverriddenMethod(String method) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        String pattern = Messages.getString(SHOULD_HAVE_OVERRIDDEN_METHOD_KEY);
        String warning = MessageFormatter.format(pattern, method);
        utility.warn(component, source, warning, null, null);
    }
}

