/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.msf;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.BundleActivationManagerOwnerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.framework.bundle.msf.FactoryConfigurationData;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;

public class ManagedServiceFactoryActivationManager
implements IManagedServiceFactoryActivationManager {
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Common.ArgumentMustNotBeNull";
    private static final String FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToCreateImportedServiceFilterForPid";
    private static final String FAILED_TO_CREATE_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToCreateObjectForPid";
    private static final String FAILED_TO_DELETE_CONFIGURATION_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToDeleteConfigurationForPid";
    private static final String FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToDestroyObjectForPid";
    private static final String FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToHandleAcquiredOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToHandleReleasedOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceFactoryActivationManager.FailedToStartBundleActivationManager";
    private static final String FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceFactoryActivationManager.ManagedServiceFactoryActivationManager.FailedToStopBundleActivationManager";
    private static final String FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToUpdateObjectForPid";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IManagedServiceFactoryAdvisor advisor;
    private BundleContext context;
    private Map factoryConfigurationDataMap;
    private String name;
    private final Object startLock = new Object();

    public ManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor) {
        this.setName(name);
        this.setAdvisor(advisor);
        this.setFactoryConfigurationDataMap(new Hashtable(37));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryConfigurationData addFactoryConfigurationData(String pid, Dictionary properties) {
        FactoryConfigurationData data;
        Map map;
        Map map2 = map = this.getFactoryConfigurationDataMap();
        synchronized (map2) {
            data = new FactoryConfigurationData(properties);
            map.put(pid, data);
        }
        return data;
    }

    private void checkArgumentIsNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        String pattern = Messages.getString(ARGUMENT_MUST_NOT_BE_NULL);
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private void create(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            Object object = advisor.create(pid, properties, manager);
            data.setObject(object);
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_OBJECT_FOR_PID_KEY);
        }
    }

    private IBundleActivationManagerOwner createBundleActivationManagerOwner(final String pid) {
        return new BundleActivationManagerOwnerAdapter(){

            public void activate() {
                ManagedServiceFactoryActivationManager.this.create(pid);
            }

            public void deactivate() {
                ManagedServiceFactoryActivationManager.this.destroy(pid);
            }

            public String[] getImportedServiceNames() {
                return ManagedServiceFactoryActivationManager.this.getImportedServiceNames(pid);
            }

            public String[] getOptionalImportedServiceNames() {
                return ManagedServiceFactoryActivationManager.this.getOptionalImportedServiceNames(pid);
            }

            public void handleAcquiredOptionalImportedService(String serviceName, Object service) {
                ManagedServiceFactoryActivationManager.this.handleAcquiredOptionalImportedService(pid, serviceName, service);
            }

            public void handleReleasedOptionalImportedService(String serviceName, Object service) {
                ManagedServiceFactoryActivationManager.this.handleReleasedOptionalImportedService(pid, serviceName, service);
            }

            public void start() {
                ManagedServiceFactoryActivationManager.this.createImportedServiceFilters(pid);
            }
        };
    }

    private Object createImportedServiceFilters(String pid) {
        Object object = null;
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.createImportedServiceFilters(pid, oldProperties, properties, manager);
            object = data.getObject();
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        try {
            Object lock;
            Object object = lock = this.getStartLock();
            synchronized (object) {
                this.stopBundleActivationManager(pid);
                this.removeFactoryConfigurationData(pid);
            }
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_DELETE_CONFIGURATION_FOR_PID_KEY);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void destroy(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Object object = data.getObject();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            try {
                advisor.destroy(pid, object, properties, manager);
            }
            catch (Throwable throwable) {
                this.logError(pid, throwable, FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            data.setObject(null);
            throw throwable;
        }
        {
            Object var8_10 = null;
            data.setObject(null);
            return;
        }
    }

    private boolean equal(Dictionary dictionary1, Dictionary dictionary2) {
        int size2;
        boolean equal;
        if (dictionary1 == dictionary2) {
            return true;
        }
        if (dictionary1 == null || dictionary2 == null) {
            return false;
        }
        int size1 = dictionary1.size();
        boolean bl = equal = size1 == (size2 = dictionary2.size());
        if (!equal) {
            return false;
        }
        Enumeration keys = dictionary1.keys();
        while (equal && keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value1 = dictionary1.get(key);
            Object value2 = dictionary2.get(key);
            equal = value1.equals(value2);
        }
        return equal;
    }

    private IManagedServiceFactoryAdvisor getAdvisor() {
        return this.advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllObjects() {
        Map map = this.getFactoryConfigurationDataMap();
        int size = map.size();
        int capacity = size * 3;
        Hashtable<String, Object> result = new Hashtable<String, Object>(capacity);
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = this.getAllPids();
            while (iterator.hasNext()) {
                String pid = (String)iterator.next();
                FactoryConfigurationData data = (FactoryConfigurationData)map.get(pid);
                Object object = data.getObject();
                if (object == null) continue;
                result.put(pid, object);
            }
        }
        return result;
    }

    public Iterator getAllPids() {
        Map map = this.getFactoryConfigurationDataMap();
        Set keys = map.keySet();
        Iterator iterator = keys.iterator();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllProperties() {
        Map map = this.getFactoryConfigurationDataMap();
        int size = map.size();
        int capacity = size * 3;
        Hashtable<String, Dictionary> result = new Hashtable<String, Dictionary>(capacity);
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = this.getAllPids();
            while (iterator.hasNext()) {
                String pid = (String)iterator.next();
                FactoryConfigurationData data = (FactoryConfigurationData)map.get(pid);
                Dictionary properties = data.getProperties();
                result.put(pid, properties);
            }
        }
        return result;
    }

    private BundleContext getBundleContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryConfigurationData getFactoryConfigurationData(String pid) {
        FactoryConfigurationData data;
        Map map;
        Map map2 = map = this.getFactoryConfigurationDataMap();
        synchronized (map2) {
            data = (FactoryConfigurationData)map.get(pid);
        }
        return data;
    }

    private Map getFactoryConfigurationDataMap() {
        return this.factoryConfigurationDataMap;
    }

    private String[] getImportedServiceNames(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        String[] names = advisor.getImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    public String getName() {
        return this.name;
    }

    private String[] getOptionalImportedServiceNames(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        String[] names = advisor.getOptionalImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    private void handleAcquiredOptionalImportedService(String pid, String importedServiceName, Object importedService) {
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Object object = data.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.handleAcquiredOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private void handleReleasedOptionalImportedService(String pid, String importedServiceName, Object importedService) {
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        Object object = data.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.handleReleasedOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private boolean isStarted() {
        BundleContext context = this.getBundleContext();
        boolean started = context != null;
        return started;
    }

    private void logError(String message, Throwable throwable) {
        LogUtility.logError(this, message, throwable);
    }

    private void logError(String pid, Throwable throwable, String key) {
        String pattern = Messages.getString(key);
        String message = MessageFormatter.format(pattern, pid);
        this.logError(message, throwable);
    }

    private void printFactoryConfigurationOn(StringBuffer buffer, String pid, Object object, Dictionary properties) {
        Enumeration enumeration = properties.keys();
        buffer.append('\t');
        buffer.append("Persistent ID: ");
        buffer.append(pid);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Object: ");
        buffer.append(object);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Properties:");
        buffer.append(LINE_SEPARATOR);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = properties.get(key);
            buffer.append('\t');
            buffer.append('\t');
            buffer.append('\t');
            buffer.append("Key=");
            buffer.append(key);
            buffer.append(", Value=");
            buffer.append(value);
            buffer.append(LINE_SEPARATOR);
        }
        buffer.append(LINE_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFactoryConfigurationsOn(StringBuffer buffer) {
        Map map;
        buffer.append(this);
        buffer.append(LINE_SEPARATOR);
        Map map2 = map = this.getFactoryConfigurationDataMap();
        synchronized (map2) {
            Iterator pids = this.getAllPids();
            Map objects = this.getAllObjects();
            Map props = this.getAllProperties();
            while (pids.hasNext()) {
                String pid = (String)pids.next();
                Object object = objects.get(pid);
                Dictionary properties = (Dictionary)props.get(pid);
                this.printFactoryConfigurationOn(buffer, pid, object, properties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactoryConfigurationData(String pid) {
        Map map;
        Map map2 = map = this.getFactoryConfigurationDataMap();
        synchronized (map2) {
            map.remove(pid);
        }
    }

    private void setAdvisor(IManagedServiceFactoryAdvisor advisor) {
        this.checkArgumentIsNotNull("advisor", this.name);
        this.advisor = advisor;
    }

    private void setBundleContext(BundleContext context) {
        this.context = context;
    }

    private void setFactoryConfigurationDataMap(Map factoryConfigurationDataMap) {
        this.factoryConfigurationDataMap = factoryConfigurationDataMap;
    }

    private void setName(String name) {
        this.checkArgumentIsNotNull("name", name);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(context);
        }
    }

    private void startBundleActivationManager(String pid) {
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        IBundleActivationManager manager = data.getBundleActivationManager();
        BundleContext context = this.getBundleContext();
        IBundleActivationManagerOwner owner = this.createBundleActivationManagerOwner(pid);
        try {
            manager.start(context, owner);
        }
        catch (Exception exception) {
            this.logError(pid, exception, FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.stopBundleActivationManagers();
            this.setBundleContext(null);
        }
    }

    private void stopBundleActivationManager(String pid) {
        FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
        if (data == null) {
            return;
        }
        IBundleActivationManager manager = data.getBundleActivationManager();
        BundleContext context = this.getBundleContext();
        try {
            manager.stop(context);
        }
        catch (Exception exception) {
            this.logError(pid, exception, FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    private void stopBundleActivationManagers() {
        Hashtable map = (Hashtable)this.getFactoryConfigurationDataMap();
        Map clone = (Map)map.clone();
        Set keys = clone.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String pid = (String)iterator.next();
            this.stopBundleActivationManager(pid);
            this.removeFactoryConfigurationData(pid);
        }
    }

    public String toString() {
        String value = super.toString();
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        String name = this.getName();
        StringBuffer buffer = new StringBuffer(350);
        buffer.append(value);
        buffer.append(", managedServiceFactoryName=");
        buffer.append(name);
        buffer.append(", advisor=");
        buffer.append(advisor);
        String result = buffer.toString();
        return result;
    }

    private void update(String pid, Dictionary properties, FactoryConfigurationData data) {
        boolean update;
        Dictionary currentProperties = data.getProperties();
        boolean match = this.equal(currentProperties, properties);
        if (match) {
            return;
        }
        data.setProperties(properties);
        Object object = data.getObject();
        Object newObject = this.createImportedServiceFilters(pid);
        boolean bl = update = object != null && object == newObject;
        if (!update) {
            return;
        }
        this.update(pid, data);
    }

    private void update(String pid, FactoryConfigurationData data) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        Object object = data.getObject();
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        Object updatedObject = advisor.update(pid, object, oldProperties, properties, manager);
        data.setObject(updatedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            Object lock;
            this.validateConfiguration(pid, properties);
            Object object = lock = this.getStartLock();
            synchronized (object) {
                FactoryConfigurationData data = this.getFactoryConfigurationData(pid);
                if (data == null) {
                    this.addFactoryConfigurationData(pid, properties);
                    this.startBundleActivationManager(pid);
                } else {
                    this.update(pid, properties, data);
                }
            }
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY);
        }
    }

    private void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        advisor.validateConfiguration(pid, properties);
    }
}

