/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.sat.core.internal.record.ServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class ExportServiceRecord
extends ServiceRecord
implements IExportServiceRecord {
    private static final String REGISTER_ADDITIONAL_PROPERTIES_PROPERTY = "org.eclipse.soda.sat.core.internal.record.register.additional.properties";
    private static final String DEFAULT_REGISTER_ADDITIONAL_PROPERTIES = "true";
    private static final boolean REGISTER_ADDITIONAL_PROPERTIES = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.internal.record.register.additional.properties", "true"));
    private String[] names;
    private Dictionary properties;
    private boolean registered;
    private ServiceRegistration registration;

    public ExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        super(bundleContext);
        this.setNames(names);
        this.setService(service);
        this.setProperties(properties);
        this.setRegistered(false);
        this.setServiceRegistration(null);
    }

    private void basicSetProperties(Dictionary properties) {
        this.properties = properties;
    }

    protected int createToStringBufferSize() {
        return super.createToStringBufferSize() + 250;
    }

    public String[] getNames() {
        return this.names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getProperties() {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            if (this.properties == null) {
                Hashtable properties = new Hashtable(29);
                this.basicSetProperties(properties);
            }
        }
        return this.properties;
    }

    public Object getProperty(String key) {
        Object property = super.getProperty(key);
        if (property != null) {
            return property;
        }
        Dictionary properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        property = properties.get(key);
        if (property == null) {
            this.signalUnknownProperty(key);
        }
        return property;
    }

    public String[] getPropertyKeys() {
        Collection<Object> collection;
        String[] keys = super.getPropertyKeys();
        int length = keys.length;
        if (length != 0) {
            return keys;
        }
        Dictionary properties = this.getProperties();
        if (properties == null) {
            return ServiceRecord.NO_PROPERTY_KEYS;
        }
        int size = properties.size();
        keys = new String[size];
        if (properties instanceof Hashtable) {
            Hashtable table = (Hashtable)properties;
            collection = table.keySet();
        } else {
            Enumeration enumeration = properties.keys();
            collection = new ArrayList(size);
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                collection.add(key);
            }
        }
        collection.toArray(keys);
        return keys;
    }

    public ServiceReference getServiceReference() {
        ServiceReference reference = null;
        ServiceRegistration registration = this.getServiceRegistration();
        if (registration != null) {
            reference = registration.getReference();
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            return this.registration;
        }
    }

    public boolean isProxy() {
        return false;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    private void populateWithAdditionalProperties(Dictionary properties) {
        if (!REGISTER_ADDITIONAL_PROPERTIES) {
            return;
        }
        this.setBundleVendorProperty(properties);
        this.setBundleVersionProperty(properties);
        this.setServiceRegistrationTimestampProperty(properties);
    }

    private void printNamesOn(StringBuffer buffer) {
        buffer.append(", names=");
        String[] names = this.getNames();
        int count = names.length;
        int i = 0;
        while (i < count) {
            String name = names[i];
            buffer.append((Object)name);
            if (i < count - 1) {
                buffer.append(", ");
            }
            ++i;
        }
    }

    protected void printOn(StringBuffer buffer) {
        ServiceRegistration registration;
        super.printOn(buffer);
        this.printNamesOn(buffer);
        Dictionary properties = this.getProperties();
        if (properties != null) {
            buffer.append(", properties=");
            buffer.append(properties);
        }
        if ((registration = this.getServiceRegistration()) != null) {
            buffer.append(", registration=");
            this.printOn(buffer, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            boolean registered = this.isRegistered();
            if (registered) {
                return;
            }
            this.setRegistered(true);
            this.registerServiceWithFramework();
        }
    }

    private void registerServiceWithFramework() {
        BundleContext bundleContext = this.getBundleContext();
        Object service = this.getService();
        String[] names = this.getNames();
        Dictionary properties = this.getProperties();
        this.populateWithAdditionalProperties(properties);
        ServiceRegistration registration = bundleContext.registerService(names, service, properties);
        this.setServiceRegistration(registration);
    }

    private void setBundleVendorProperty(Dictionary properties) {
        Bundle bundle;
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String value = utility.getBundleVendor(bundle = this.getBundle());
        if (value == null) {
            return;
        }
        properties.put("bundle.vendor", value);
    }

    private void setBundleVersionProperty(Dictionary properties) {
        Bundle bundle;
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String value = utility.getBundleVersion(bundle = this.getBundle());
        if (value == null) {
            return;
        }
        properties.put("bundle.version", value);
    }

    private void setNames(String[] names) {
        this.names = names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary properties) {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            this.basicSetProperties(properties);
            boolean registered = this.isRegistered();
            if (!registered) {
                return;
            }
            ServiceRegistration registration = this.getServiceRegistration();
            this.setServiceRegistrationTimestampProperty(properties);
            registration.setProperties(properties);
        }
    }

    private void setRegistered(boolean registered) {
        this.registered = registered;
    }

    private void setServiceRegistration(ServiceRegistration registration) {
        this.registration = registration;
    }

    private void setServiceRegistrationTimestampProperty(Dictionary properties) {
        long now = System.currentTimeMillis();
        Long value = new Long(now);
        properties.put("service.registration.timestamp", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ExportServiceRecord exportServiceRecord = this;
        synchronized (exportServiceRecord) {
            boolean registered = this.isRegistered();
            if (!registered) {
                return;
            }
            this.setRegistered(false);
            this.unregisterServiceWithFramework();
        }
    }

    private void unregisterServiceWithFramework() {
        ServiceRegistration registration = this.getServiceRegistration();
        registration.unregister();
        this.setServiceRegistration(null);
    }
}

