/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

abstract class ServiceRecord
implements IServiceRecord {
    private static final String UNKNOWN_PROPERTY_KEY = "ServiceRecord.UnknownProperty";
    protected static final String[] NO_PROPERTY_KEYS = new String[0];
    private BundleContext bundleContext;
    private Object service;

    protected ServiceRecord(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
        this.setService(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object basicGetService() {
        ServiceRecord serviceRecord = this;
        synchronized (serviceRecord) {
            return this.service;
        }
    }

    protected int createToStringBufferSize() {
        return 100;
    }

    protected final Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    protected final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private long getId() {
        Long wrapper = (Long)this.getProperty("service.id");
        long id = wrapper;
        return id;
    }

    public Object getProperty(String key) {
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        Object property = serviceReference.getProperty(key);
        if (property == null) {
            this.signalUnknownProperty(key);
        }
        return property;
    }

    public String[] getPropertyKeys() {
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return NO_PROPERTY_KEYS;
        }
        String[] keys = serviceReference.getPropertyKeys();
        return keys;
    }

    public Object getService() {
        Object service = this.basicGetService();
        return service;
    }

    protected abstract ServiceReference getServiceReference();

    public final boolean hasService() {
        Object service = this.basicGetService();
        boolean result = service != null;
        return result;
    }

    private boolean hasServiceReference() {
        ServiceReference reference = this.getServiceReference();
        boolean result = reference != null;
        return result;
    }

    private void printIdOn(StringBuffer buffer) {
        buffer.append(", id=");
        if (this.hasServiceReference()) {
            long id = this.getId();
            buffer.append(id);
        } else {
            buffer.append("<none>");
        }
    }

    protected void printOn(StringBuffer buffer) {
        this.printIdOn(buffer);
        buffer.append(", service=");
        Object service = this.getService();
        this.printOn(buffer, service);
    }

    protected final void printOn(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append(object);
        } else {
            Class<?> clazz = object.getClass();
            String name = clazz.getName();
            int hashCode = object.hashCode();
            String hexHashCode = Integer.toHexString(hashCode);
            buffer.append(name);
            buffer.append('@');
            buffer.append(hexHashCode);
        }
    }

    protected final void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setService(Object service) {
        ServiceRecord serviceRecord = this;
        synchronized (serviceRecord) {
            this.service = service;
        }
    }

    protected final void signalUnknownProperty(String key) {
        String pattern = Messages.getString(UNKNOWN_PROPERTY_KEY);
        String message = MessageFormatter.format(pattern, key);
        throw new IllegalArgumentException(message);
    }

    public final String toString() {
        int size = this.createToStringBufferSize();
        StringBuffer buffer = new StringBuffer(size);
        buffer.append(super.toString());
        this.printOn(buffer);
        String description = buffer.toString();
        return description;
    }
}

