/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container;

import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.record.container.ServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerLenientOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.osgi.framework.Filter;

public final class ImportServiceRecordContainer
extends ServiceRecordContainer
implements IImportServiceRecordContainer {
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Common.ArgumentMustNotBeNull";
    private static final String ILLEGAL_OPERATION_WHILE_CONTAINER_IS_ACQUIRED_KEY = "ImportServiceRecordContainer.IllegalOperationWhileContainerIsAcquired";
    private static IServiceRecordAction acquireAction;
    private static IServiceRecordAction isAcquiredAction;
    private static IServiceRecordAction releaseAction;
    private boolean acquired;
    private IImportServiceRecordContainerOwner owner;
    private IImportServiceRecordOwner serviceRecordOwner;
    static /* synthetic */ Class class$0;

    private static IServiceRecordAction createAcquireAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                IImportServiceRecordOwner owner = (IImportServiceRecordOwner)parameter;
                importServiceRecord.acquire(owner);
                return true;
            }
        };
    }

    private static IServiceRecordAction createIsAcquiredAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                boolean acquired = importServiceRecord.isAcquired();
                return acquired;
            }
        };
    }

    private static IServiceRecordAction createReleaseAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                importServiceRecord.release();
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getAcquireAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (acquireAction == null) {
                ImportServiceRecordContainer.setAcquireAction(ImportServiceRecordContainer.createAcquireAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return acquireAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getIsAcquiredAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (isAcquiredAction == null) {
                ImportServiceRecordContainer.setIsAcquiredAction(ImportServiceRecordContainer.createIsAcquiredAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return isAcquiredAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getReleaseAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (releaseAction == null) {
                ImportServiceRecordContainer.setReleaseAction(ImportServiceRecordContainer.createReleaseAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return releaseAction;
        }
    }

    private static void setAcquireAction(IServiceRecordAction acquireAction) {
        ImportServiceRecordContainer.acquireAction = acquireAction;
    }

    private static void setIsAcquiredAction(IServiceRecordAction isAcquiredAction) {
        ImportServiceRecordContainer.isAcquiredAction = isAcquiredAction;
    }

    private static void setReleaseAction(IServiceRecordAction releaseAction) {
        ImportServiceRecordContainer.releaseAction = releaseAction;
    }

    public ImportServiceRecordContainer() {
        this.setAcquired(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(IImportServiceRecordContainerOwner owner) {
        this.checkArgumentIsNotNull("owner", owner);
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            boolean acquired = this.getAcquired();
            if (acquired) {
                return;
            }
            this.setOwner(owner);
            boolean empty = this.isEmpty();
            if (empty) {
                this.setAcquired(true);
                owner.acquired(this);
            } else {
                IServiceRecordAction action = ImportServiceRecordContainer.getAcquireAction();
                IImportServiceRecordOwner serviceRecordOwner = this.getServiceRecordOwner();
                this.doForEach(action, serviceRecordOwner);
                boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
                if (lenient) {
                    this.setAcquired(true);
                    owner.acquired(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IImportServiceRecord record) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            this.checkIsNotAcquired();
            String name = record.getName();
            boolean added = this.add(name, record);
            return added;
        }
    }

    private void checkArgumentIsNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        String pattern = Messages.getString(ARGUMENT_MUST_NOT_BE_NULL);
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private void checkIsNotAcquired() {
        boolean acquired = this.getAcquired();
        if (!acquired) {
            return;
        }
        String message = Messages.getString(ILLEGAL_OPERATION_WHILE_CONTAINER_IS_ACQUIRED_KEY);
        throw new IllegalStateException(message);
    }

    private IImportServiceRecordOwner createServiceRecordOwner() {
        return new IImportServiceRecordOwner(){

            public void serviceAcquired(IImportServiceRecord record) {
                ImportServiceRecordContainer.this.serviceAcquired(record);
            }

            public void serviceReleased(IImportServiceRecord record) {
                ImportServiceRecordContainer.this.serviceReleased(record);
            }
        };
    }

    protected int createStringBufferSize() {
        return super.createStringBufferSize() + 100;
    }

    protected int createTableCapacity() {
        return 17;
    }

    private boolean getAcquired() {
        return this.acquired;
    }

    private IImportServiceRecordContainerOwner getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordOwner getServiceRecordOwner() {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            if (this.serviceRecordOwner == null) {
                IImportServiceRecordOwner owner = this.createServiceRecordOwner();
                this.setServiceRecordOwner(owner);
            }
        }
        return this.serviceRecordOwner;
    }

    public IImportServiceRecord getWithFilter(String name, Filter filter) {
        IImportServiceRecord record = null;
        if (filter == null) {
            record = (IImportServiceRecord)this.get(name);
        } else {
            boolean found = false;
            IServiceRecord[] records = this.getAll(name);
            int length = records.length;
            int index = 0;
            while (!found && index < length) {
                record = (IImportServiceRecord)records[index];
                Filter recordFilter = record.getFilter();
                found = filter.equals((Object)recordFilter);
                ++index;
            }
            record = found ? record : null;
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcquired() {
        boolean acquired = false;
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            acquired = this.getAcquired();
            if (!acquired) {
                IServiceRecordAction action = ImportServiceRecordContainer.getIsAcquiredAction();
                acquired = this.doForEach(action, null);
            }
        }
        return acquired;
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        IImportServiceRecordContainerOwner owner = this.getOwner();
        buffer.append(", owner=");
        buffer.append(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            IImportServiceRecordContainerOwner owner = this.getOwner();
            if (owner == null) {
                return;
            }
            boolean empty = this.isEmpty();
            if (empty) {
                this.setAcquired(false);
                owner.released(this);
            } else {
                IServiceRecordAction action = ImportServiceRecordContainer.getReleaseAction();
                this.doForEach(action, null);
                boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
                if (lenient) {
                    this.setAcquired(false);
                    owner.released(this);
                }
            }
            this.setOwner(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IImportServiceRecord record) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            this.checkIsNotAcquired();
            String name = record.getName();
            boolean removed = this.remove(name, record);
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(String name) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            block5: {
                boolean acquired = this.getAcquired();
                if (!acquired) break block5;
                return false;
            }
            IServiceRecord[] records = this.getAll(name);
            int length = records.length;
            boolean removed = true;
            int index = 0;
            while (removed && index < length) {
                IImportServiceRecord record = (IImportServiceRecord)records[index];
                removed = this.remove(record);
                ++index;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceAcquired(IImportServiceRecord record) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (lenient) {
                IImportServiceRecordContainerLenientOwner lenientOwner = (IImportServiceRecordContainerLenientOwner)owner;
                lenientOwner.serviceAcquired(this, record);
            } else {
                boolean acquired = this.isAcquired();
                if (!acquired) {
                    return;
                }
                this.setAcquired(true);
                owner.acquired(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceReleased(IImportServiceRecord record) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            IImportServiceRecordContainerOwner owner = this.getOwner();
            boolean lenient = owner instanceof IImportServiceRecordContainerLenientOwner;
            if (lenient) {
                IImportServiceRecordContainerLenientOwner lenientOwner = (IImportServiceRecordContainerLenientOwner)owner;
                this.setAcquired(false);
                lenientOwner.serviceReleased(this, record);
            } else {
                boolean acquired = this.getAcquired();
                if (!acquired) {
                    return;
                }
                this.setAcquired(false);
                owner.released(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAcquired(boolean acquired) {
        ImportServiceRecordContainer importServiceRecordContainer = this;
        synchronized (importServiceRecordContainer) {
            this.acquired = acquired;
        }
    }

    private void setOwner(IImportServiceRecordContainerOwner owner) {
        this.owner = owner;
    }

    private void setServiceRecordOwner(IImportServiceRecordOwner serviceRecordOwner) {
        this.serviceRecordOwner = serviceRecordOwner;
    }
}

