/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import org.eclipse.soda.sat.core.framework.interfaces.ILineReader;

public class LineReader
implements ILineReader {
    private BufferedReader bufferedReader;
    private String nextLine;
    private ILineReader.IAdvisor advisor;

    private static ILineReader.IAdvisor createAdvisor() {
        return new ILineReader.IAdvisor(){

            public boolean isValid(String line) {
                return true;
            }

            public String transform(String line) {
                return line;
            }
        };
    }

    public LineReader(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public LineReader(InputStream inputStream, ILineReader.IAdvisor advisor) {
        this(inputStream, 8192, advisor);
    }

    public LineReader(InputStream inputStream, int size) {
        this(inputStream, size, LineReader.createAdvisor());
    }

    public LineReader(InputStream inputStream, int size, ILineReader.IAdvisor advisor) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, size);
        this.setBufferedReader(bufferedReader);
        this.setAdvisor(advisor);
    }

    private String basicReadLine() throws IOException {
        BufferedReader bufferedReader = this.getBufferedReader();
        String line = bufferedReader.readLine();
        return line;
    }

    public void close() throws IOException {
        BufferedReader bufferedReader = this.getBufferedReader();
        bufferedReader.close();
    }

    private ILineReader.IAdvisor getAdvisor() {
        return this.advisor;
    }

    private BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    private String getNextLine() {
        return this.nextLine;
    }

    private boolean hasMoreLines() {
        String line = null;
        try {
            line = this.readLine();
            this.setNextLine(line);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        boolean result = line != null;
        return result;
    }

    public Enumeration lines() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return LineReader.this.hasMoreLines();
            }

            public Object nextElement() {
                return LineReader.this.getNextLine();
            }
        };
    }

    public String readLine() throws IOException {
        String line = null;
        boolean valid = false;
        ILineReader.IAdvisor advisor = this.getAdvisor();
        while ((line = this.basicReadLine()) != null && !(valid = advisor.isValid(line))) {
        }
        if (line != null) {
            line = advisor.transform(line);
        }
        return line;
    }

    private void setAdvisor(ILineReader.IAdvisor advisor) {
        this.advisor = advisor;
    }

    private void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    private void setNextLine(String nextLine) {
        this.nextLine = nextLine;
    }
}

