/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.profile.DeviceProfile;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.BundleActivator;
import org.osgi.service.log.LogService;

public abstract class ProfileBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    private DeviceService device = null;
    private ProfileService profile;

    public void activate() {
        NotificationService notificationService;
        DeviceService device = this.getDevice();
        if (this.profile == null) {
            this.setProfile(this.createService(device));
            if (this.profile != null) {
                Hashtable properties = this.createProperties();
                String[] names = this.getExportedServiceNames();
                if (this.profile instanceof Profile) {
                    ((Profile)this.profile).setBundleContext(this.getBundleContext());
                }
                this.addExportedServices(names, this.profile, properties);
            }
        } else if (this.profile instanceof DeviceProfile) {
            ((Profile)this.profile).setDevice(device);
        }
        if ((notificationService = (NotificationService)this.getOptionalImportedService("org.eclipse.soda.dk.notification.service.NotificationService")) != null) {
            this.profile.setNotificationService(notificationService);
        }
        this.profile.start();
    }

    public Hashtable createProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(37);
        properties.put("id", "*");
        return properties;
    }

    public abstract ProfileService createService(DeviceService var1);

    protected void deactivate() {
        ProfileService profile = this.getProfile();
        if (profile != null) {
            profile.exit();
            this.setProfile(null);
        }
    }

    public DeviceService getDevice() {
        if (this.device == null) {
            return (DeviceService)this.getImportedService(this.getInterestServiceName());
        }
        return this.device;
    }

    public abstract String[] getExportedServiceNames();

    public String getInterestServiceName() {
        return "";
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICES;
    }

    public ProfileService getProfile() {
        return this.profile;
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (this.profile != null && service instanceof NotificationService) {
            this.profile.setNotificationService((NotificationService)service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (this.profile != null && service instanceof NotificationService) {
            this.profile.setNotificationService(null);
        }
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    public void setDevice(DeviceService device) {
        this.device = device;
    }

    public void setProfile(ProfileService profile) {
        this.profile = profile;
    }
}

