/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.testcases;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.device.DeviceRegistry;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.testcases.TestDevice;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.MethodSignal;
import org.eclipse.soda.dk.signal.Signal;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class DeviceRegistryTestcase
extends TestCase
implements NotificationListener {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public DeviceRegistryTestcase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.device.testcases.DeviceRegistryTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        System.out.println("externalKey " + externalKey + " data " + data);
    }

    public void testCreate() {
        DeviceRegistry deviceRegistryService = new DeviceRegistry();
        deviceRegistryService.start();
        deviceRegistryService.exit();
    }

    public void testFilter() {
        TestDevice deviceRegistryService = new TestDevice();
        try {
            Filter filter = deviceRegistryService.createFilter("(i1=true)");
            Hashtable<String, Boolean> dictionary = new Hashtable<String, Boolean>();
            boolean result = filter.matchCase(dictionary);
            DeviceRegistryTestcase.assertTrue((!result ? 1 : 0) != 0);
            ((Dictionary)dictionary).put("i1", Boolean.TRUE);
            result = filter.matchCase(dictionary);
            DeviceRegistryTestcase.assertTrue((boolean)result);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void testInterest() {
        NotificationService broker = Notification.createBroker();
        broker.register("#", (NotificationListener)this);
        DeviceRegistry deviceRegistryService = new DeviceRegistry();
        Hashtable<String, String> configurationInformation = new Hashtable<String, String>();
        Command command = new Command("My");
        deviceRegistryService.put("My", (ControlService)command);
        deviceRegistryService.put("My2", (ControlService)new Command("My2"));
        Signal signal = new Signal("Signal0");
        deviceRegistryService.put("Signal0", (ControlService)signal);
        Measurement measurement = new Measurement("Measurement0");
        deviceRegistryService.put("Measurement0", (ControlService)measurement);
        deviceRegistryService.setNotificationService(broker);
        configurationInformation.put("id", "0");
        deviceRegistryService.setConfigurationInformation(configurationInformation);
        deviceRegistryService.start();
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("value", "my_pub_command_data");
        broker.broadcast(String.valueOf(command.toString()) + "/execute", data);
        signal.trigger((Object)"mysignaldata");
        command.execute((Object)"my_command_data");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        deviceRegistryService.exit();
    }

    public void testInterestTwo() {
        System.out.println(">>>>>>>>>start test two");
        NotificationService broker = Notification.createBroker();
        broker.register("#", (NotificationListener)this);
        TestDevice deviceRegistryService = new TestDevice();
        Hashtable<String, String> configurationInformation = new Hashtable<String, String>();
        MethodMeasurement myMeasurement = new MethodMeasurement("MyMeasurement");
        deviceRegistryService.put("MyMeasurement", (ControlService)myMeasurement);
        MethodCommand command = new MethodCommand("My");
        deviceRegistryService.put("My", (ControlService)command);
        deviceRegistryService.put("my2", (ControlService)new Command("my2"));
        MethodSignal signal = new MethodSignal("MySignal");
        deviceRegistryService.put("signal0", (ControlService)signal);
        Measurement measurement = new Measurement("measurement0");
        deviceRegistryService.put("measurement0", (ControlService)measurement);
        configurationInformation.put("id", "0");
        deviceRegistryService.setConfigurationInformation(configurationInformation);
        deviceRegistryService.setNotificationService(broker);
        deviceRegistryService.start();
        command.execute((Object)new Integer(0));
        myMeasurement.setValue((Object)new Integer(0));
        myMeasurement.executeWrite((Object)new Integer(1));
        myMeasurement.executeRead();
        myMeasurement.getValue();
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("value", "mypubcommanddata");
        broker.broadcast(String.valueOf(command.toString()) + "/execute", data);
        Hashtable<String, String> data2 = new Hashtable<String, String>();
        data2.put("value", "mypubmeasurementdata");
        broker.broadcast(String.valueOf(measurement.toString()) + "/set", data2);
        signal.trigger((Object)"mysignaldata");
        command.execute((Object)"mycommanddata");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        deviceRegistryService.exit();
    }
}

