/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitEditorEnvironment;
import org.eclipse.soda.devicekit.editor.dkml.DkmlConfiguration;
import org.eclipse.soda.devicekit.editor.dkml.DkmlDocumentProvider;
import org.eclipse.soda.devicekit.editor.dkml.DkmlModel;
import org.eclipse.soda.devicekit.editor.dkml.EditorMessages;
import org.eclipse.soda.devicekit.editor.dkml.FormattedDkml;
import org.eclipse.soda.devicekit.editor.dkml.IDeviceKitEditorPage;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedCenter;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedEvent;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedListener;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class DeviceKitSourcePage
extends TextEditor
implements IDeviceKitEditorPage,
DkmlResourceChangedListener,
IEditorMatchingStrategy {
    public static final String FORMAT = "dkml.format";
    private boolean changed = false;
    private IDocumentListener documentListener = new DocumentListener();
    private IFile file;
    private DkmlDocumentProvider documentProvider;
    private DkmlModel dkmlModel;
    private boolean dirty;
    private FormatAction fa;

    public boolean contextMenuAboutToShow(IMenuManager manager) {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getModel().saveFile(this.getFile(), true)) {
                this.getModel().updateModel(this.file);
                this.setDirty(false);
                this.fireSaveNeeded();
                this.changed = false;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getFormatAction());
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator(IDEActionFactory.ADD_TASK.getId()));
        menu.add((IContributionItem)new Separator("GotoLine"));
        this.addAction(menu, "group.rest", FORMAT);
        this.addAction(menu, "group.rest", "GotoLine");
        this.addAction(menu, "group.find", ITextEditorActionConstants.FIND);
        this.addAction(menu, "group.find", "FindNext");
        this.addAction(menu, "group.find", "FindPrevious");
        this.addAction(menu, "group.rest", IDEActionFactory.ADD_TASK.getId());
        super.editorContextMenuAboutToShow(menu);
    }

    public void fireSaveNeeded() {
        this.firePropertyChange(257);
    }

    public void formatDkml() {
        String contents = this.getCurrentDocContents();
        try {
            FormattedDkml xml = new FormattedDkml(contents);
            this.getFile().setContents((InputStream)new ByteArrayInputStream(xml.getFormattedString().getBytes()), true, true, null);
            this.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(xml.getFormattedString());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)DeviceKitEditorPlugin.getActiveWorkbenchShell(), (String)"Device Kit Error", (String)Nls.format((String)EditorMessages.getString("DeviceKitMultiPageEditor.error.format"), (Object)this.getFile().getName()));
        }
    }

    public String getCurrentDocContents() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    public IFile getFile() {
        return this.file;
    }

    protected Action getFormatAction() {
        if (this.fa == null) {
            this.fa = new FormatAction();
            this.fa.setText("Format");
        }
        return this.fa;
    }

    public DkmlModel getModel() {
        return this.dkmlModel;
    }

    public String getPageContents() {
        return null;
    }

    public IFile getReferencedFile(String name) {
        return this.getModel().getReferencedFile(name);
    }

    public void initEditor() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        this.initXml();
    }

    private void initModel() throws CoreException {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IDocumentProvider documentProvider = this.getDocumentProvider();
            documentProvider.connect((Object)editorInput);
            IAnnotationModel amodel = documentProvider.getAnnotationModel((Object)editorInput);
            if (amodel != null) {
                amodel.connect(documentProvider.getDocument((Object)editorInput));
            }
            this.dkmlModel = new DkmlModel(this.getFile(), documentProvider, editorInput);
        }
    }

    private void initXml() {
        IEditorSite site = this.getEditorSite();
        DeviceKitEditorEnvironment.connect(this);
        this.setSourceViewerConfiguration(new DkmlConfiguration());
        this.setDocumentProvider(this.getDocumentProvider());
        DkmlResourceChangedCenter.getInstance().addResouceChangeListener(this);
        site.setSelectionProvider(site.getSelectionProvider());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSource() {
        return true;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        return true;
    }

    public void changed() {
        this.changed = true;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.addDocumentListener(this.documentListener);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new DkmlDocumentProvider();
        }
        return this.documentProvider;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setInput(input);
        this.initEditor();
        try {
            this.initModel();
        }
        catch (CoreException e) {
            throw new PartInitException(e.getMessage());
        }
    }

    public void partClosed(IWorkbenchPart part) {
        this.removeListeners();
        this.removeResourceErrors();
    }

    public void preShow() {
        this.changed = false;
    }

    public void removeListeners() {
        DkmlResourceChangedCenter.getInstance().removeResourceChangeListener(this);
    }

    private void removeResourceErrors() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void resourceChanged(DkmlResourceChangedEvent event) {
        this.update();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void update() {
        String newContents = null;
        DkmlModel model = this.getModel();
        String o = model.getTagContents();
        if (o == null) {
            return;
        }
        newContents = o;
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        doc.set(newContents);
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            DeviceKitSourcePage.this.getModel().setChanged(true);
            DeviceKitSourcePage.this.getModel().updateFile(DeviceKitSourcePage.this.getFile(), DeviceKitSourcePage.this.getDocumentProvider().getDocument((Object)DeviceKitSourcePage.this.getEditorInput()).get());
            DeviceKitSourcePage.this.setDirty(true);
            DeviceKitSourcePage.this.fireSaveNeeded();
        }
    }

    class FormatAction
    extends Action {
        public FormatAction() {
            this.setId(DeviceKitSourcePage.FORMAT);
        }

        public void run() {
            DeviceKitSourcePage.this.formatDkml();
        }
    }
}

