/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DkmlDomErrorHandler
implements ErrorHandler {
    public static final int MAX_ERRORS = 100;
    private IDocument doc;
    private IFile file;
    private int errorCount;
    private IAnnotationModel annModel;

    public DkmlDomErrorHandler(IFile file, IDocumentProvider provider, Object input) throws Exception {
        this.file = file;
        this.annModel = provider.getAnnotationModel(input);
        this.removeFileMarkers();
        this.errorCount = 0;
        this.doc = new Document(this.getInitialContent());
    }

    private void addMarker(String message, int lineNumber, int columnNumber, int severity, boolean fatal) {
        try {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber != -1) {
                marker.setAttribute("lineNumber", lineNumber);
                int offset = this.getLineOffset(lineNumber - 1);
                marker.setAttribute("charStart", offset);
                int lineLength = this.getLineLength(lineNumber - 1);
                Position p = new Position(offset, lineLength);
                this.annModel.addAnnotation((Annotation)new MarkerAnnotation(marker), p);
            }
        }
        catch (Exception exception) {}
    }

    private void addMarker(SAXParseException e, int severity, boolean fatal) {
        this.addMarker(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), severity, fatal);
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.errorCount < 100) {
            this.addMarker(exception, 2, false);
        }
        ++this.errorCount;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorCount < 100) {
            this.addMarker(exception, 2, true);
        }
        ++this.errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public IFile getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInitialContent() throws Exception {
        StringBuffer buff;
        InputStream stream;
        block5: {
            stream = null;
            buff = new StringBuffer(128);
            try {
                stream = this.file.getContents();
                int curr = stream.read();
                while (curr != -1) {
                    buff.append((char)curr);
                    curr = stream.read();
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (stream != null) {
                    stream.close();
                }
                stream = null;
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (stream == null) break block5;
            }
            stream.close();
        }
        stream = null;
        return buff.toString();
    }

    private int getLineLength(int lineNumber) throws BadLocationException {
        return this.doc.getLineLength(lineNumber);
    }

    private int getLineOffset(int lineNumber) throws BadLocationException {
        return this.doc.getLineOffset(lineNumber);
    }

    private void removeFileMarkers() {
        try {
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void reportError(String message) {
        this.reportError(message, -1, -1);
    }

    public void reportError(String message, int line, int column) {
        this.addMarker(message, line, column, 2, false);
    }

    public void reportWarning(String message) {
        this.reportWarning(message, -1, -1);
    }

    public void reportWarning(String message, int line, int column) {
        this.addMarker(message, line, column, 1, false);
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorCount < 100) {
            this.addMarker(exception, 1, false);
        }
    }
}

