/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.listener;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedEvent;
import org.eclipse.soda.devicekit.editor.dkml.listener.DkmlResourceChangedListener;

public class DkmlResourceChangedCenter {
    private static DkmlResourceChangedCenter center = new DkmlResourceChangedCenter();
    private Vector resourceListeners = new Vector();

    private DkmlResourceChangedCenter() {
    }

    public static DkmlResourceChangedCenter getInstance() {
        return center;
    }

    public synchronized void addResouceChangeListener(DkmlResourceChangedListener listener) {
        if (this.resourceListeners.contains(listener)) {
            return;
        }
        this.resourceListeners.add(listener);
    }

    public String getNewFileContents(String name) {
        return DeviceKitEditorPlugin.getActiveEditor().getModel().getManager().getFileContents(name);
    }

    public synchronized void removeResourceChangeListener(DkmlResourceChangedListener listener) {
        this.resourceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IFile file, int eventType) {
        Vector list;
        DkmlResourceChangedCenter dkmlResourceChangedCenter = this;
        synchronized (dkmlResourceChangedCenter) {
            list = (Vector)this.resourceListeners.clone();
        }
        DkmlResourceChangedEvent event = new DkmlResourceChangedEvent(file, eventType);
        int i = 0;
        while (i < list.size()) {
            DkmlResourceChangedListener listener = (DkmlResourceChangedListener)list.elementAt(i);
            listener.resourceChanged(event);
            ++i;
        }
    }
}

