/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.parse;

import java.util.Vector;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolderString;
import org.w3c.dom.Node;

public class TagHolder {
    private long id;
    private String data;
    private String name;
    private Vector attributes;
    private Vector children;
    private Vector parAttributes;
    private Node node;
    private TagHolder parent;

    public TagHolder(String name) {
        this(name, new Vector(), new Vector(), null, null);
    }

    public TagHolder(String name, Vector attributes) {
        this(name, attributes, null, null, null);
    }

    public TagHolder(String name, Vector attributes, Vector children) {
        this(name, attributes, children, null, null);
    }

    public TagHolder(String name, Vector attributes, Vector children, Node node) {
        this(name, attributes, children, node, null);
    }

    public TagHolder(String name, Vector attributes, Vector children, Node node, String data) {
        this.name = name;
        this.attributes = attributes;
        this.children = children;
        this.node = node;
        this.data = data;
        this.id = this.createId();
    }

    public boolean addAttribute(String name, String value) {
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeHolder holder = (AttributeHolder)this.attributes.elementAt(i);
            if (holder.getName().equals(name)) {
                holder.setValue(value);
                return false;
            }
            ++i;
        }
        this.attributes.add(new AttributeHolder(name, value));
        return true;
    }

    public void addChild(TagHolder child) {
        this.addChild(child, -1);
    }

    public void addChild(TagHolder child, int index) {
        if (index == -1) {
            this.children.add(child);
        } else {
            this.children.insertElementAt(child, index);
        }
    }

    private long createId() {
        return System.currentTimeMillis();
    }

    public AttributeHolder getAttribute(String attribute) {
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeHolder ah = (AttributeHolder)this.attributes.elementAt(i);
            if (ah.getName().equals(attribute)) {
                return ah;
            }
            ++i;
        }
        return null;
    }

    public String getAttributeValue(String attribute) {
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeHolder ah = (AttributeHolder)this.attributes.elementAt(i);
            if (ah.getName().equals(attribute)) {
                return ah.getValue();
            }
            ++i;
        }
        return null;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String getComment() {
        return "";
    }

    public String getData() {
        return this.data;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    public TagHolder getParent() {
        return this.parent;
    }

    public AttributeHolder getParentAttribute(String key) {
        int i = 0;
        while (i < this.parAttributes.size()) {
            AttributeHolder ah = (AttributeHolder)this.parAttributes.elementAt(i);
            if (ah.getName().equals(key)) {
                return ah;
            }
            ++i;
        }
        return null;
    }

    public Vector getParentAttributes() {
        return this.parAttributes;
    }

    public boolean isComment() {
        return false;
    }

    public void removeChild(TagHolder child) {
        if (this.children.contains(child)) {
            this.children.removeElement(child);
        }
    }

    public void setAttributes(Vector attributes) {
        this.attributes = attributes;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setParent(TagHolder parent) {
        this.parent = parent;
    }

    public void setParentAttributes(Vector parAttributes) {
        this.parAttributes = parAttributes;
    }

    public String toString() {
        return new TagHolderString(this).toString();
    }
}

